#!/bin/bash

# Script to remove virus scanning for a domain

# Adds domain to the following files:
# 1. AVFILE - virus.scanning.rules
# 2. SUS_HTML_RULES_FILE - suspect.html.rules
# 3. DANG_HTML_RULES_FILE - dangerous.html.rules
# 4. SUS_CONTENT_RULES_FILE - suspect.content.rules
# 5. FILENAME_SCANNING_RULES_FILE - filename.scanning.rules
# 6. FILETYPE_SCANNING_RULES_FILE - filetype.scanning.rules

OUTFILE="/tmp/virus_removal.tmp"

RemoveDomain ()
{
	SEARCH="*@$DOMAIN"
	grep -q $SEARCH $AVFILE
	CmdOp=$?

	if [ $CmdOp -ne 0 ]
	then
		# This mans that the domain has not yet had virus scanning disabled
		logger -p local3.info -t vpanel "Removing Virus Scanning for $DOMAIN ..."

		# 1. AVFILE - virus.scanning.rules
			grep -v "default" $AVFILE > $OUTFILE
			echo -e "FromOrTo:\t*@$DOMAIN\t\t\tno" >> $OUTFILE
			echo -e "FromOrTo:\tdefault\t\t\t\tyes" >> $OUTFILE
			mv $OUTFILE $AVFILE
			logger -p local3.info -t vpanel " - virus library scanning: turned off"

		# 2. SUS_HTML_RULES_FILE - suspect.html.rules
			grep -q $SEARCH $SUS_HTML_RULES_FILE 
			RETURNV=$?
			if [ $RETURNV -ne 0 ]; then
				grep -v "default" $SUS_HTML_RULES_FILE > $OUTFILE
				echo -e "FromOrTo:\t*@$DOMAIN\t\t\tno" >> $OUTFILE
				echo -e "FromOrTo:\tdefault\t\t\t\tyes" >> $OUTFILE
				mv $OUTFILE $SUS_HTML_RULES_FILE
				logger -p local3.info -t vpanel " - virus suspect html scanning: turned off"
			else
				logger -p local3.info -t vpanel " - virus suspect html scanning: already turned off"
			fi

		# 3. DANG_HTML_RULES_FILE - dangerous.html.rules
			grep -q $SEARCH $DANG_HTML_RULES_FILE
			RETURNV=$?
			if [ $RETURNV -ne 0 ]; then
				grep -v "default" $DANG_HTML_RULES_FILE > $OUTFILE
				echo -e "FromOrTo:\t*@$DOMAIN\t\t\tyes" >> $OUTFILE
				echo -e "FromOrTo:\tdefault\t\t\t\tno" >> $OUTFILE
				mv $OUTFILE $DANG_HTML_RULES_FILE
				logger -p local3.info -t vpanel " - virus dangerous html scanning: turned off"
			else
				logger -p local3.info -t vpanel " - virus dangerous html scanning: already turned off"
			fi
		
		# 4. SUS_CONTENT_RULES_FILE - suspect.content.rules
			grep -q $SEARCH $SUS_CONTENT_RULES_FILE
			RETURNV=$?
			if [ $RETURNV -ne 0 ]; then
				logger -p local3.info -t vpanel " - virus suspect content scanning: turned off"
				grep -v "default" $SUS_CONTENT_RULES_FILE > $OUTFILE
				echo -e "FromOrTo:\t*@$DOMAIN\t\t\tyes" >> $OUTFILE
				echo -e "FromOrTo:\tdefault\t\t\t\tno" >> $OUTFILE
				mv $OUTFILE $SUS_CONTENT_RULES_FILE
			else
				logger -p local3.info -t vpanel " - virus suspect content scanning: aready turned off"
			fi

		# 5. FILENAME_SCANNING_RULES_FILE - filename.scanning.rules
			grep -q $SEARCH $FILENAME_SCANNING_RULES_FILE
			RETURNV=$?
			if [ $RETURNV -ne 0 ]; then
				grep -v "default" $FILENAME_SCANNING_RULES_FILE > $OUTFILE
				echo -e "FromOrTo:\t*@$DOMAIN\t\t\t/etc/MailScanner/filename.no-rules.conf" >> $OUTFILE
				echo -e "FromOrTo:\tdefault\t\t\t\t/etc/MailScanner/filename.rules.conf" >> $OUTFILE
				mv $OUTFILE $FILENAME_SCANNING_RULES_FILE
				logger -p local3.info -t vpanel " - virus filename scanning: turned off"
			else
				logger -p local3.info -t vpanel " - virus filename scanning: already turned off"
			fi

		# 6. FILETYPE_SCANNING_RULES_FILE - filetype.scanning.rules
			# This is taken care of through the cgi script, where a separate list file is written to

		logger -p local3.info -t vpanel "All Virus scanning removed for $DOMAIN"
else 
		logger -p local3.info -t vpanel "Attempt to disable virus scanning for $DOMAIN - already disabled"
	fi
return 0
}

#DOMAINS=`cat $REMOVEVIRUSFILE`

for DOMAIN in $@
do
	RemoveDomain
done

#rm -f $REMOVEVIRUSFILE
rm -f $OUTFILE
