#!/bin/sh

TEMPLATE="template"
APACHECONFIG="/etc/httpd/conf/httpd.conf"
BASEDIR=/var/customers
STATHEADER=/usr/local/share/weblog/config-head.pl
STATFOOTER=/usr/local/share/weblog/config-foot.pl
HOSTIP=`grep "^NameVirtualHost" $APACHECONFIG | grep -v "\*" | head -1 | cut -f2 -d " "`
DOMAINDATA="/var/customers/domain-data/domains.data"
MAILROUTING=/etc/mail/local-host-names

for DOMAIN in $@; do
	grep -qsE "^$DOMAIN," $DOMAINDATA
	if [ $? -eq 0 ]; then
		logger -p local3.info -t vpanel "Domain $DOMAIN already exists."
		continue
	fi
	VHOST="www.$DOMAIN"
	STATFILE=$BASEDIR/$VHOST/stats/updatestats.pl
	grep -qsE "ServerName\s*$VHOST" $APACHECONFIG
	if [ $? -eq 0 ]; then
		logger -p local3.info -t vpanel "Domain $DOMAIN already exists in apache config."
		continue
	fi
	#logger -p local3.info -t vpanel "Adding domain $DOMAIN into apache config."
	#echo -e "\n\n### START: $VHOST ###" >> $APACHECONFIG
        #echo -e "\n<VirtualHost $HOSTIP>" >> $APACHECONFIG
        #echo -e "\tServerAdmin info@$DOMAIN" >> $APACHECONFIG
        #echo -e "\tServerName www.$DOMAIN" >> $APACHECONFIG
	#echo -e "\tServerAlias $DOMAIN" >> $APACHECONFIG
        #echo -e "\tDirectoryIndex index.html index.htm index.php" >> $APACHECONFIG
        #echo -e "\tDocumentRoot $BASEDIR/$VHOST/website/htdocs" >> $APACHECONFIG
	#echo -e "\tAlias /stats $BASEDIR/$VHOST/stats" >> $APACHECONFIG
	#echo -e "\tAlias /vpanel /var/www/html/vpanel/" >> $APACHECONFIG
	#echo -e "\tAlias /webmail /var/www/html/webmail/" >> $APACHECONFIG
        #echo -e "\tScriptAlias\t/cgi-bin/\t$BASEDIR/$VHOST/website/htdocs/cgi-bin/" >> $APACHECONFIG
        #echo -e "\tCustomLog $BASEDIR/$VHOST/website/logs/access.log combined" >> $APACHECONFIG
        #echo -e "\tErrorLog $BASEDIR/$VHOST/website/logs/error.log" >> $APACHECONFIG
        #echo -e "</VirtualHost>\n" >> $APACHECONFIG
        #echo -e "### END: $VHOST ###" >> $APACHECONFIG
#
	logger -p local3.info -t vpanel "Adding mail routing for $DOMAIN"
	echo "$DOMAIN" >> $MAILROUTING

	logger -p local3.info -t vpanel "Creating directory structure in $BASEDIR"

	cp -r $BASEDIR/$TEMPLATE $BASEDIR/$VHOST
	#chown -R apache:apache $BASEDIR/$VHOST/website
	#chown $LOGIN:apache $BASEDIR/$VHOST/website
	#chown $LOGIN:apache $BASEDIR/$VHOST/website/htdocs
	#chown $LOGIN:apache $BASEDIR/$VHOST/website/htdocs/index.htm
	#chown $LOGIN:apache $BASEDIR/$VHOST/website/htdocs/cgi-bin
	#chown apache:apache $BASEDIR/$VHOST/stats/index.htm
	#chmod g+w $BASEDIR/$VHOST/website
	#chmod +s $BASEDIR/$VHOST/website
	# Fix to stop customer deleting logs folder [NMD, 13/09/2004]
	chown root:root $BASEDIR/$VHOST/website/logs
done

#rm -f $ADDDOMAINFILE
