#!/bin/bash

# this script takes a list of addresses and forwarding addresses from a file and adds them to the virtusertable file

# Noel McDermott 09/06/2003

#VIRTLINES=`cat $ADDFORWARDFILE | cut -f2`

COUNT=0
SEDTMP="/tmp/sed_addforwarding.tmp"
SEDOUTPUT="/tmp/sed_addforwarding.out"

for ARG in $@
do
	if [ $COUNT -eq 0 ]
	then
		FROM=$ARG
		COUNT=`expr $COUNT + 1`
	else
		TO=$ARG
		if grep -qsE "^\s*$FROM\s" $VIRTFILE; then
			echo "/^\s*$FROM\s/d" > $SEDTMP
       			sed -f $SEDTMP $VIRTFILE > $SEDOUTPUT
       			mv $SEDOUTPUT $VIRTFILE
			logger -p local3.info -t vpanel "Removed $FROM from $VIRTFILE"
		fi
		COUNT=0
		echo -e "$FROM\t\t$TO" >> $VIRTFILE
		logger -p local3.info -t vpanel "Email forwarding added to virtusertable: $FROM to $TO"
	fi
done

#rm -f $ADDFORWARDFILE
