print_header("Mail server routing");

#$domainname = "ieinternet.com";
$mail_routing = find_mail_routing($domainname);
$smtpforwarding = is_mailertable ($domainname);

# if ( ( $mail_routing ne "remote" ) && ( $mail_routing ne "local") && (!( $mail_routing =~ /.*[0-9]/ ) ) )
if ( ( $mail_routing ne "local") && ( $mail_routing eq "" ) )
{
	quit_with_errors("An error occured with sourcing your email set-up.");
}

if ( $mail_routing eq "remote" ) {

	print qq!
	
	Your email is not being protected by MailWall, IE Internet's email protection service. As a result, your email
	is not being scanned for Viruses and Spam by MailWall. Below is a summary of your current email set-up, listing your
	mail servers in order of priority:<BR><BR>

	!;

	@mailservers = find_mail_servers($domainname);
	$num_mailservers = @mailservers;
	print "<table width=30% border=0 class=text>";
	for ( $i = 0 ; $i < $num_mailservers ; $i++ )
	{
		print "<TR><TD width=10%>&nbsp;</TD><TD>";
		($preference, $mailservername) = split (/\s+/, $mailservers[$i]);
		if ( $i == 0 )
		{
			print "<i>Primary</i>:</TD>";
		} else {
			print "<i>Backup $i</i>:</TD>";
		}
		print "<TD>$mailservername</TD></TR>";
	}
	print "</table><BR>";

	print qq!

	IE Internet recommend that you pass your emails through our MailWall system, in order to protect your internal systems
	from Viruses and Spam. MailWall protection is included as part of your current $hostingplan hosting plan. If you would like to 
	change your set-up please contact us.<BR><BR>

	!;
	print_support_contact_information();
	
} else {
	print "Your email is being scanned by MailWall, IE Internet's email protection service.<BR><BR>";

	if ( ( $hostingplan ne "SOHO" ) || ( check_if_allowed_on_soho($create_smtp_forwarding) eq "yes" ) )
	{
		if ( $mail_routing eq "local" ) 
		{
			# Mail is locally stored in POP accounts
			show_status_of_service( "off", $create_smtp_forwarding, "SMTP forwarding" );	
		} else {
			if ( length($smtpforwarding) < 16 )
			{
				# Mail is smtp forwarding
				show_status_of_service( "on", $reset_smtp_forwarding, "Forwarding to $mail_routing" );
			} else {
				show_status_of_service_unmodifiable( "on", $reset_smtp_forwarding, "Custom forwarding to $smtpforwarding" );
			}
		}
	}

	print "<BR>";
	print_header("MailWall Services");


	#####
	# Virus section
	#####

	print_sub_header("Virus Protection");

	if ( ( $hostingplan ne "SOHO" ) || ( check_if_allowed_on_soho("is_anti-virus_allowed_for_soho") eq "yes" ) )
	{
		$virus_status = virus_scanning_status($domainname);

		if ($virus_status eq "off" )
		{
			show_status_of_service( "off", $turn_on_virus, "Virus Protection" );
		} else {
			show_status_of_service( "on", $turn_off_virus, "Virus Protection" );
			show_status_of_service( "on", $quarantine_management_1, "$mailwall_inset Virus Quarantine Management" );
		}
	}

	print "<BR>";

	#####
	# Spam section
	#####
	
	if ( ( $hostingplan ne "SOHO" ) || ( check_if_allowed_on_soho("is_anti-spam_allowed_for_soho") eq "yes" ) )
	{
		print_sub_header("Spam Scanning");
		$spam_status = spam_scanning_status($domainname);
		if ($spam_status eq "off" )
		{
			show_status_of_service( "off", $turn_on_spam, "Spam Scanning" );
		} else {
			show_status_of_service( "on", $turn_off_spam, "Spam Scanning" );	

			$spam_trap_status = spam_actions_status($domainname);
			if ( $spam_trap_status eq "off" )
			{
				show_status_of_service( "off", $turn_on_spamtrap, "$mailwall_inset Spam Trap" );
			} else {
				show_status_of_service( "on", $turn_off_spamtrap, "$mailwall_inset Spam Trap" );
			}

			#$whitelist_status = spam_whitelist_status($domainname);
			#if ( $whitelist_status eq "no" )
			#{
			#	show_status_of_service( "off", $turn_on_spam_whitelist, "$mailwall_inset Spam Whitelist" );
			#} else {	
				show_status_of_service( "on", $add_to_spam_whitelist, "$mailwall_inset Managing your spam whitelist" );
			#}

			# Content Management section
			#$content_management_status = content_management_scanning_status($domainname);

			#if ( $content_management_status eq "off" )
			#{
			#	show_status_of_service( "off", $turn_on_content_management, "$mailwall_inset Content Management");
			#} else {
			#	show_status_of_service( "on", $turn_off_content_management, "$mailwall_inset Content Management");

			#	show_status_of_service( "on", $content_management_quarantine_1, "$mailwall_inset $mailwall_inset 
			#									Content Quarantine");

			#	$filetype_scanning_status = filetype_scanning_status($domainname);
			#	if ( ($filetype_scanning_status eq "only_virus") || ($filetype_scanning_status eq "nothing") )
			#	{
			#		show_status_of_service( "off", "$change_filetype_scanning?change=son", 
			#							"$mailwall_inset $mailwall_inset Image Filtering");
			#	} else {
			#		show_status_of_service( "on", "$change_filetype_scanning?change=soff", 
			#							"$mailwall_inset $mailwall_inset Image Filtering");
			#	}
			#}
		}		
	}
	print "";
}


