#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$old_ip = param('oldip');
$new_ip = param('newip');


# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header("Change of SMTP forwarding IP address for $domainname");

$old_ip_syntax = is_ip_address_syntax_correct($old_ip);
$new_ip_syntax = is_ip_address_syntax_correct($new_ip);

if ( $old_ip_syntax eq "no" || $new_ip_syntax eq "no" )
{
	print "
		Sorry, but the IP address supplied [$new_ip] does not seem to have the correct syntax.
		You are advised to contact your IT Support Department for advice on the IP address you should be using.<BR><BR>
	";
	print_support_contact_information();
} elsif ( $new_ip_syntax eq "restricted" ) {
	print "
		Sorry, but the IP address supplied [$new_ip] is from a restricted IP range and cannot be used for SMTP forwarding. 
		You are advised to contact your IT Support Department for advice on the IP address you should be using.<BR><BR>
	";
	print_support_contact_information();
	
} else {

print qq!

	Thank you for your request to change the forwarding of email for the domain $domainname as detailed below:<BR><BR><BR>

	<table width=30% border=0 class=text>
	<tr><td>Old IP address:</td><td>$old_ip</td></tr>
	<tr><td>New IP address:</td><td>$new_ip</td></tr>
	</table>
!;

$ret = php_request ("setSMTPForward", "scope=domain:$domainname", "smtpForward=Yes", "ipAddress=$new_ip");
#return 1 if (defined ($ret) && ref ($ret) ne "SCALAR");
#return 0;
#open ( RESET, ">>$reset_smtp_forwarding_file" ) || file_error($reset_smtp_forwarding_file);
#print RESET $domainname , "," , $new_ip, "\n";
#close (RESET);

show_time_to_change();

}

require $footer;
