#!/bin/bash

# This script is called every 5 minutes and runs all the scripts required to update the control panel

# Noel McDermott 09/06/2003
# Noel McDermott 02/12/2003
# Noel McDermott 08/2004

VPANELDIR="/var/www/html/vpanel/"
LISTDIR=$VPANELDIR"lists/"
MANDIR=$VPANELDIR"management/"
CGIDIR=$VPANELDIR"cgi-bin/"
MAILSCANNERDIR="/etc/MailScanner/rules/"
VIRUSSCANDIR=$MAILSCANNERDIR"virus/"
SPAMSCANDIR=$MAILSCANNERDIR"spam/"
CONTENTSCANDIR=$MAILSCANNERDIR"content/"
PWPROTECTIONDIR=$VPANELDIR"password_protection_files/"
WHITELISTDIR="/etc/MailScanner/spam.bydomain/whitelist/"
DEFAULTWHITELISTFILE=$WHITELISTDIR"default"
QUARDIR="/var/spool/MailScanner/quarantine/"
CONTENT_QUAR_SUB_DIR="mcp/"
OUTBOUNDQUEUEDIR="/var/spool/mqueue/"
SPAMREPORTFILEFULLPREFIX=$LISTDIR"spam_report.*"
SPAMREPORTFILEPREFIX="spam_report.*"

VIRTFILE="/etc/mail/virtusertable"
PASSFILE="/etc/passwd"
MAILERTABLE="/etc/mail/mailertable"
SPAMTRAPFILE=$SPAMSCANDIR"spam.actions.rules"
ACCESSFILE="/etc/mail/access"
LOCALHOSTSFILE="/etc/mail/local-host-names"
MAILSPOOL="/var/spool/mail/"
SKELDIR="/etc/vpanel-skel/"

# List files

ADDADDRESSFILE=$LISTDIR"newaddress.list"
DELADDRESSFILE=$LISTDIR"deleteaddress.list"
ADDUSERFILE=$LISTDIR"newuser.list"
DELUSERFILE=$LISTDIR"deleteuser.list"
CHANGEPASSFILE=$LISTDIR"changepassword.list"
ADDFORWARDFILE=$LISTDIR"newforwarding.list"
DELFORWARDFILE=$LISTDIR"deleteforwarding.list"
ADDFTPUSERFILE=$LISTDIR"newftpuser.list"
CREATESMTPFILE=$LISTDIR"create_smtpforwarding.list"
EMPTYMAILBOXFILE=$LISTDIR"emptymailbox.list"
ADDVACATIONFILE=$LISTDIR"vacationusers.list"
REMOVEVACATIONFILE=$LISTDIR"removevacationusers.list"
NEWUSEREMAIL=$LISTDIR"newuser.email"
CHANGEINFOFILE=$LISTDIR"changeinfoaccount.list"
OVERWRITEWITHMULTIDROPFILE=$LISTDIR"overwrite_email_with_multidrop.list"
DELETEMULTIDROPFILE=$LISTDIR"delete_multidrop.list"
CREATESEARCHENGINEFILE=$LISTDIR"create_search_engine.list"
CREATEPWPROTECTIONFILE=$LISTDIR"create_password_protection.list"
DELETE_SPAM_MAILBOX="/var/spool/mail/deletespamtrap"

# MailWall list files
	REMOVEVIRUSFILE=$LISTDIR"removevirusscanning.list"
	CREATEVIRUSSCANNINGFILE=$LISTDIR"addvirusscanning.list"
	ADDSPAMFILE=$LISTDIR"addspamscanning.list"
	ADDWHITELISTFILE=$LISTDIR"create_spam_whitelist.list"
	CREATEVIRUSNOTIFICATIONFILE=$LISTDIR"add_virus_notification.list"
	REMOVEVIRUSNOTIFICATIONFILE=$LISTDIR"remove_virus_notification.list"
	RESETSMTPFILE=$LISTDIR"resetsmtpforwarding.list"
	REMOVESPAMFILE=$LISTDIR"removespamscanning.list"
	CREATESPAMTRAPFILE=$LISTDIR"create_spamtrap.list"
	DELETESPAMTRAPFILE=$LISTDIR"delete_spamtrap.list"
	RELEASE_EMAIL_FILE=$LISTDIR"release_from_quarantine.list"
	SPAMREPORTEMAIL="control_panel_spam_report@ieinternet.com"

	# Advanced Virus Features list files
	REMOVE_SUS_HTML_FILE=$LISTDIR"remove_suspect_html_scanning.list"
	CREATE_SUS_HTML_FILE=$LISTDIR"create_suspect_html_scanning.list"
	REMOVE_DANG_HTML_FILE=$LISTDIR"remove_dangerous_html_scanning.list"
	CREATE_DANG_HTML_FILE=$LISTDIR"create_dangerous_html_scanning.list"
	REMOVE_SUS_CONTENT_FILE=$LISTDIR"remove_suspect_content_scanning.list"
	CREATE_SUS_CONTENT_FILE=$LISTDIR"create_suspect_content_scanning.list"
	REMOVE_FILENAME_SCANNING_FILE=$LISTDIR"remove_filename_scanning.list"
	CREATE_FILENAME_SCANNING_FILE=$LISTDIR"create_filename_scanning.list"

	# Content management files
	CREATE_CONTENT_MANAGEMENT_FILE=$LISTDIR"create_content_management.list"
	REMOVE_CONTENT_MANAGEMENT_FILE=$LISTDIR"remove_content_management.list"
	CREATE_IMAGE_FILTERING_FILE=$LISTDIR"create_image_filtering.list"
	REMOVE_IMAGE_FILTERING_FILE=$LISTDIR"remove_image_filtering.list"
	
	# Other
	CHANGE_FILETYPE_SCANNING_FILE=$LISTDIR"change_filetype_scanning.list"

# MailScanner rules files
	# Virus rules files
	AVFILE=$VIRUSSCANDIR"virus.scanning.rules"
	VIRUSNOTIFICATIONSFILE=$VIRUSSCANDIR"virus.notifications.rules"
	SUS_HTML_RULES_FILE=$VIRUSSCANDIR"suspect.html.rules"
	DANG_HTML_RULES_FILE=$VIRUSSCANDIR"dangerous.html.rules"
	SUS_CONTENT_RULES_FILE=$VIRUSSCANDIR"suspect.content.rules"
	FILENAME_SCANNING_RULES_FILE=$VIRUSSCANDIR"filename.scanning.rules"
	FILETYPE_SCANNING_RULES_FILE=$VIRUSSCANDIR"filetype.scanning.rules"

	# Spam rules files
	SPAMSCANNINGFILE=$SPAMSCANDIR"spam.scanning.rules"
	SPAMACTIONSFILE="/etc/MailScanner/rules/spam.actions.rules"
	CONTENT_MANAGEMENT_RULES_FILE=$CONTENTSCANDIR"content.filtering.rules"
	

export LISTDIR
export MANDIR 
export PWPROTECTIONDIR
export WHITELISTDIR
export DEFAULTWHITELISTFILE
export MAILSCANNERDIR
export QUARDIR
export OUTBOUNDQUEUEDIR
export CONTENT_QUAR_SUB_DIR
export MAILSPOOL
export VIRTFILE
export PASSFILE
export ACCESSFILE
export LOCALHOSTSFILE
export SPAMTRAPFILE
export MAILERTABLE
export SKELDIR
export ADDADDRESSFILE
export DELADDRESSFILE
export ADDUSERFILE
export DELUSERFILE
export CHANGEPASSFILE
export ADDFORWARDFILE
export DELFORWARDFILE
export ADDFTPUSERFILE
export CREATESMTPFILE
export REMOVEVIRUSFILE
export REMOVESPAMFILE
export ADDVACATIONFILE
export REMOVEVACATIONFILE
export CREATESPAMTRAPFILE
export DELETESPAMTRAPFILE
export RELEASE_EMAIL_FILE
export CHANGEINFOFILE
export RELEASEEMAILFILE
export OVERWRITEWITHMULTIDROPFILE
export DELETEMULTIDROPFILE
export ADDSPAMFILE
export SPAMSCANNINGFILE
export SPAMACTIONSFILE
export RESETSMTPFILE
export CREATESEARCHENGINEFILE
export CREATEPWPROTECTIONFILE
export ADDWHITELISTFILE
export CREATEVIRUSNOTIFICATIONFILE
export REMOVEVIRUSNOTIFICATIONFILE
export VIRUSNOTIFICATIONSFILE
export EMPTYMAILBOXFILE
export AVFILE
export FILESCANFILE
export SUS_HTML_RULES_FILE
export DANG_HTML_RULES_FILE
export SUS_CONTENT_RULES_FILE
export FILENAME_SCANNING_RULES_FILE
export FILETYPE_SCANNING_RULES_FILE
export CONTENT_MANAGEMENT_RULES_FILE
export CREATEVIRUSSCANNINGFILE
export REMOVE_SUS_HTML_FILE
export CREATE_SUS_HTML_FILE
export REMOVE_DANG_HTML_FILE
export CREATE_DANG_HTML_FILE
export REMOVE_SUS_CONTENT_FILE
export CREATE_SUS_CONTENT_FILE
export REMOVE_FILENAME_SCANNING_FILE
export CREATE_FILENAME_SCANNING_FILE
export CHANGE_FILETYPE_SCANNING_FILE
export CREATE_CONTENT_MANAGEMENT_FILE
export REMOVE_CONTENT_MANAGEMENT_FILE
export CREATE_IMAGE_FILTERING_FILE
export REMOVE_IMAGE_FILTERING_FILE
export SPAMREPORTFILEFULLPREFIX

LOCKFILE=$MANDIR"vpanel.lck"
RESTARTMAILSCANNER=0
MMHVIRTTABLE=0

BACKUPTAG="`date +%H%M%m%Y%S`"

if [ -e $LOCKFILE ]; then
	FULLDATE=`date`
	echo -e "\n\n\t\tError -- A lock file exists!\n\n"
	mail -s "Control panel race condition averted on $HOSTNAME at $FULLDATE" technical@ieinternet.com < $MANDIR"racecondition.txt"
	exit
else
	touch $LOCKFILE
	if [ -e $ADDADDRESSFILE ]; then
		$MANDIR"addaddresses.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $DELADDRESSFILE ]; then
		$MANDIR"deleteaddress.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $ADDUSERFILE ]; then
		$MANDIR"addusers.sh"
	fi

	if [ -e $DELUSERFILE ]; then
		$MANDIR"deleteusers.sh"
	fi

	if [ -e $CHANGEPASSFILE ]; then
		$MANDIR"resetpassword.sh"
	fi

	if [ -e $ADDFORWARDFILE ]; then
		$MANDIR"addforwarding.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $DELFORWARDFILE ]; then
		$MANDIR"deleteforwarding.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $ADDFTPUSERFILE ]; then
		$MANDIR"addftpusers.sh"
	fi

	if [ -e $REMOVEVIRUSFILE ] ;then
		$MANDIR"remove_virus_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $ADDSPAMFILE ]; then
		$MANDIR"add_spam_scanning.sh"	
		RESTARTMAILSCANNER=1		
	fi

	if [ -e $ADDVACATIONFILE ]; then
		$MANDIR"installvacation.sh"
	fi

	if [ -e $REMOVEVACATIONFILE ]; then
		$MANDIR"removevacation.sh"
	fi

	if [ -e $CREATESPAMTRAPFILE ]; then
		$MANDIR"create_spam_trap.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $DELETESPAMTRAPFILE ]; then
		$MANDIR"delete_spam_trap.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $REMOVESPAMFILE ]; then
		$MANDIR"remove_spam_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CHANGEINFOFILE ]; then
		$MANDIR"changeinfoaccount.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $OVERWRITEWITHMULTIDROPFILE ]; then
		$MANDIR"overwrite_email_with_multidrop.sh"
		MMHVIRTTABLE=1
	fi
	
	if [ -e $DELETEMULTIDROPFILE ]; then
		$MANDIR"delete_multidrop.sh"
		MMHVIRTTABLE=1
	fi

	if [ -e $CREATESMTPFILE ]; then
		$MANDIR"create_smtp_forwarding.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $RESETSMTPFILE ]; then
		$MANDIR"reset_smtp_forwarding.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATESEARCHENGINEFILE ]; then
		$MANDIR"create_searchengine.sh"
	fi


	if [ -e $CREATEPWPROTECTIONFILE ]; then
		$MANDIR"create_password_protected_area.sh"
	fi

	if [ -e $ADDWHITELISTFILE ]; then
		$MANDIR"create_spam_whitelist.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATEVIRUSNOTIFICATIONFILE ]; then
		$MANDIR"create_virus_notification.sh"
		RESTARTMAILSCANNER=1	
	fi
	
	if [ -e $REMOVEVIRUSNOTIFICATIONFILE ]; then
		$MANDIR"remove_virus_notification.sh"
		RESTARTMAILSCANNER=1
	fi

	# Deletion of spam traps necessitates calling a perl script in the cgi-bin
	# This script must be called before empty_mailbox.sh as this latter script is used to purge the spam trap mailbox 
	if [ -e $DELETE_SPAM_MAILBOX ]; then
		$CGIDIR"empty_spam_traps.pl"
	fi

	if [ -e $EMPTYMAILBOXFILE ];then
		$MANDIR"empty_mailbox.sh"
	fi

	if [ -e $CREATEVIRUSSCANNINGFILE ]; then
		$MANDIR"add_virus_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	#############
	# Advanced virus scanning section added [ NMD, 26-08-2004 ]
	#############

	if [ -e $REMOVE_SUS_HTML_FILE ]; then
		$MANDIR"remove_suspect_html_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATE_SUS_HTML_FILE ]; then
		$MANDIR"create_suspect_html_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $REMOVE_DANG_HTML_FILE ]; then
		$MANDIR"remove_dangerous_html_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATE_DANG_HTML_FILE ]; then
		$MANDIR"create_dangerous_html_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $REMOVE_SUS_CONTENT_FILE ]; then
		$MANDIR"remove_suspect_content_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATE_SUS_CONTENT_FILE ]; then
		$MANDIR"create_suspect_content_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $REMOVE_FILENAME_SCANNING_FILE ]; then
		$MANDIR"remove_filename_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATE_FILENAME_SCANNING_FILE ]; then
		$MANDIR"create_filename_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CHANGE_FILETYPE_SCANNING_FILE ]; then
		$MANDIR"change_filetype_scanning.sh"
		RESTARTMAILSCANNER=1
	fi

	#############
	# End of advanced virus scanning section
	#############

	
	#############
	# Start of content management section
	#############


	if [ -e $CREATE_CONTENT_MANAGEMENT_FILE ]; then
		$MANDIR"create_content_management.sh"
		RESTARTMAILSCANNER=1

	fi

	if [ -e $REMOVE_CONTENT_MANAGEMENT_FILE ]; then
		$MANDIR"remove_content_management.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $CREATE_IMAGE_FILTERING_FILE ]; then
		$MANDIR"create_image_filtering.sh"
		RESTARTMAILSCANNER=1
	fi

	if [ -e $REMOVE_IMAGE_FILTERING_FILE ]; then
		$MANDIR"remove_image_filtering.sh"
		RESTARTMAILSCANNER=1
	fi

	#############
	# End of content management section
	#############

	NUM_SPAM_REPORT_FILES=`find $LISTDIR -name "$SPAMREPORTFILEPREFIX" -print | wc -l`
	if [ $NUM_SPAM_REPORT_FILES -gt 0 ]; then
		$MANDIR"report_spam.sh"
	fi
	
	if [ -e $RELEASE_EMAIL_FILE ]; then
		$MANDIR"release_email_from_quarantine.sh"
	fi

	# Release locks 
	rm -f $LOCKFILE

	# Restart affected processes 
	if [ $RESTARTMAILSCANNER == 1 ]; then
		/etc/init.d/MailScanner restart
	fi

	if [ $MMHVIRTTABLE == 1 ]; then
#		/usr/sbin/makemap hash $VIRTFILE.db < $VIRTFILE
		/usr/sbin/makemap hash $VIRTFILE.tempfix.db < $VIRTFILE
		mv -f $VIRTFILE.tempfix.db $VIRTFILE.db
	fi

fi


