#!/bin/bash

TMPFILE="/tmp/remove_spam.tmp"
TMPSEDFILE="/tmp/remove_spam.sed"

RemoveDomain ()
{
	logger -p local3.info -t vpanel "Removing Spam scanning for $DOMAIN ..."

	# 1. REMOVE SPAM SCANNING
	# Add to scanning rules file
		grep -q "*@$DOMAIN" $SPAMSCANNINGFILE
		CmdOp=$?
		if [ $CmdOp -ne 0 ]; then
			grep -v "default" $SPAMSCANNINGFILE > $TMPFILE
			echo -e "FromOrTo:\t*@$DOMAIN\t\t\tno" >> $TMPFILE
			echo -e "FromOrTo:\tdefault\t\t\t\tyes" >> $TMPFILE
			rm -f $SPAMSCANNINGFILE
			mv $TMPFILE $SPAMSCANNINGFILE
			logger -p local3.info -t vpanel "  Main spam scanning removed for $DOMAIN"
		fi

	# 2. REMOVE SPAM TRAP
	# No need as this has been taken care of through the remove spam trap cgi script

	# 3. REMOVE CONTENT MANAGEMENT
	# No need as this has been taken care of through the remove spam trap cgi script

	# 4. REMOVE IMAGE FILTERING
	# No need as this has been taken care of through the remove spam trap cgi script

	# 5. REMOVE SPAM WHITELIST
	# Remove the whitelist directory /etc/MailScanner/spam.bydomain/whitelist/domainname if it exists
		DOMAIN_WHITELIST=$WHITELISTDIR$DOMAIN
		if [ -e $DOMAIN_WHITELIST ]; then
			rm -rf $DOMAIN_WHITELIST
			logger -p local3.info -t vpanel "  Spam whitelist removed for $DOMAIN"
		fi

	logger -p local3.info -t vpanel "Spam scanning removed for $DOMAIN"
	return 0

}

DOMAINS=`cat $REMOVESPAMFILE`

for DOMAIN in $DOMAINS
do
	RemoveDomain
done

rm -f $TMPFILE
rm -f $TMPSEDFILE
rm -f $REMOVESPAMFILE
