#!/bin/bash

# Script to add vacation mail for one or more users

USERLIST=`cat $ADDVACATIONFILE`

for USERLINE in $USERLIST
do
	VACUSER=`echo $USERLINE | cut -f1 -d','`
	DOMAIN=`echo $USERLINE | cut -f2 -d','`

	# Set up the forward file

	USERHOME=`grep "^$VACUSER" $PASSFILE | cut -f6 -d":"`
	FORWARDFILE="$USERHOME/.forward"
	EMAILUSER=`grep $VACUSER $VIRTFILE | cut -f1 -d'@' | head -n1`
	echo -n "\\" > $FORWARDFILE
	echo "$VACUSER, \"|/usr/bin/vacation $VACUSER -a $EMAILUSER\"" >> $FORWARDFILE
	/bin/chown $VACUSER:apache $FORWARDFILE
	/bin/chmod 600 $FORWARDFILE

	# Copy across the actual email message
	
	VACFILE="$USERHOME/.vacation.msg"
	REPLYFILE=$LISTDIR"vacation.email.$VACUSER"
	cat $REPLYFILE > $VACFILE
	/bin/chown $VACUSER.apache $VACFILE
	/bin/chmod 644 $VACFILE

	logger -p local3.info -t vpanel "Insalled 'Out of Office' reply for $VACUSER"
done


rm -f $REPLYFILE
rm -f $ADDVACATIONFILE
