# Get information specific to the domain in question

$mainuser = $ENV{'REMOTE_USER'};
$servername = $ENV{'SERVER_NAME'};
$servername =~ s/^mail.//g;
use Sys::Hostname;
$hostname = hostname;


$passfile = "/etc/passwd";
$accounttypefile = "/var/customers/domain-data/domains.data";
$virtusertable = "/etc/mail/virtusertable";
$mailertable = "/etc/mail/mailertable";
$local_host_names = "/etc/mail/local-host-names";
$httpconffile = "/etc/httpd/conf/httpd.conf";
$mailrulesdir = "/etc/MailScanner/rules/";
$spamofffile = $mailrulesdir . "spam.scanning.rules";
$spamtrapfile = $mailrulesdir . "spam.actions.rules";
$virusofffile = $mailrulesdir . "virus.scanning.rules";
$htdigdir = "/usr/local/htdig/conf/";
$boarddir = "/var/boards/";
$databasedir = "/var/lib/mysql/";
$shopdir = "/var/shops/shared/";

if ( $servername =~ /mail./ )
{
	$flag = "mail";
} else {
	$flag = "web";
}

sub find_domain
{
	if ( $servername eq $hostname )
	{
		$searchstring = $_[0] . ":";
		open (PASSFILE, "<$passfile");
		while (<PASSFILE>)
		{
			if (/$searchstring/)
			{
				($user, $password, $user_id, $user_group, $comment, $home_directory, $shell) = split(/:/, $_);
				$domainname = $comment;
				$userlenght = length $user;
				substr ($user,$userlenght-2,2,"01");
				$loggeduser = $mainuser;
				$mainuser = $user;
				close (PASSFILE);
				return $domainname;
			}
		}
		close (PASSFILE);
		return 0;
	}
	



	$searchstring = $servername . ":";
	open (PASSFILE, "<$passfile");
	while (<PASSFILE>)
	{
		if (/$searchstring/)
		{
			($user, $password, $user_id, $user_group, $comment, $home_directory, $shell) = split(/:/, $_);
			$domainname = $comment;
			$userlenght = length $user;
			substr ($user,$userlenght-2,2,"01");
			$loggeduser = $mainuser;
			$mainuser = $user;
			close (PASSFILE);
			return $domainname;
		}
	}
	close (PASSFILE);
	return $servername;
}

sub find_hosting_plan
{
	$dedicated_status = is_server_dedicated($_[0]);
	if ( $dedicated_status eq "yes" )
	{
	        return "Dedicated server";
	} 

	open(ACCFILE, $accounttypefile) || file_error($accounttypefile);
	while (<ACCFILE>)
	{
		($domname, $userlimit, $spacelimit) = split ( /,/, $_);
		if ( $domname eq $_[0] )
		{
			if ( $userlimit == $sohouserlimit )
			{
				close (ACCFILE);
				return "SOHO";
			} elsif ( $userlimit == $bususerlimit ) {
				close (ACCFILE);
				return "Business";
			} else {
				close (ACCFILE);
				return "Application";
			}
		}
	}
	close (ACCFILE);
	return 0;
}


sub find_space_limit
{
	$dedicated_status = is_server_dedicated($_[0]);
	if ( $dedicated_status eq "yes" )
	{
		return "2000";
	}

	$searchstring = "^$_[0]";
	open ( DOMDATA, "<$domain_data_file") || file_error($domain_data_file);
	while (<DOMDATA>)
	{
		if (/$searchstring/)
		{
			( $dom, $domuser, $domspace ) = split (/,/ , $_);
			close (DOMDATA);
			return $domspace;
			break;
		}
	}
	close (DOMDATA);
	return 0;
}

sub find_user_limit
{
	$dedicated_status = is_server_dedicated($_[0]);
	if ( $dedicated_status eq "yes" )
	{
		return "500";
	}

	if ( $_[0] eq "SOHO" )
	{
		return $sohouserlimit;
	} elsif ( $_[0] eq "Business" ) {
		return $bususerlimit;
	} elsif ( $_[0] eq "Application" ) {
		return $appuserlimit;
	}
	return 0;
}

sub find_number_users
{
	$domain = $_[0];
	@ftp_users = find_valid_ftp_users($domain);
	@email_users = find_valid_users($domain);

	$num_ftp_users = @ftp_users;
	$num_email_users = @email_users;

	$total_number_users = $num_ftp_users + $num_email_users;

	return $total_number_users;
}

sub find_space_used
{
	$totalspaceused = 0;
	$matchtotal = "your account:";
	open ( SPACE, "./space.sh $_[0] |" );
	while (<SPACE>)
	{
		if ( /$matchtotal/ )
		{
			( $bump, $totalspaceused ) = split ( /:/, $_ );
		 	$totalspaceused =~ s/\.//;
			 last;
		}
	}
	close (SPACE);
	$totalspaceused =~ s/<BR>//g;
	return $totalspaceused;
}

sub find_mail_servers
{
	$mailserver = 0;
	open ( DIG, "dig $_[0] mx |" );
	$searchvar = "$_[0].*[0-9].*MX";
	while (<DIG>)
	{
		if (/$searchvar/)
		{
			@data = split (/\s+/, $_);
			@mail_servers[$mailserver++] = "$data[4] $data[5]";
		}
	}
	@mail_servers = sort {$a <=> $b} @mail_servers;
	return @mail_servers;
}

sub find_name_servers
{
	$nameserver = 0;
	open ( NSDIG , "dig $_[0] ns |" );
	$searchvar = "$_[0].*[0-9].*NS.*";
	$ieinternetdns = ".*ieinternet.net";
	$uc_ieinternetdns = ".*IEINTERNET.NET";
	while (<NSDIG>)
	{
		if (/$searchvar/)
 		{
			if ( (!(/$ieinternetdns/)) && (!(/$uc_ieinternetdns/)) )
			{
				@dnsdata = split (/\s+/, $_);
				@dns_servers[$nameserver++] = $dnsdata[4];
			}
		}
	}
	close (NSDIG);
	return @dns_servers;
}

sub is_mailertable
{
	open ( MTABLE, $mailertable ) || file_error($mailertable);
	$searchvar = "^$_[0].*smtp";
	while (<MTABLE>)
	{
		if (/$searchvar/)
		{
			s/$searchvar.*\[//;
			s/\]//;
			chomp ($_);
			return $_;
		}
	}
	return 0;
}

sub find_valid_users
{
	@delusers = ();
	@user_list = ();
	
	$ftpstring = "^ftp";
	$domainstring = "\:$_[0]\:";

	# Get a list of users awaiting deletion - not to be shown as current users

	
	if ( -e $deleteuserfile )
	{
		open (DELUSERS, $deleteuserfile) || file_error($deleteuserfile);
		while (<DELUSERS>)
		{
			chomp ($_);
			push @delusers, $_;
		}
		close (DELUSERS);
	}

	# find users associated with this domain name and create an array of existing users
	open (PASSUSERS, $passfile) || file_error($passfile);
	while (<PASSUSERS>)
	{	
		$founddeluser = 0;
		if ( (/$domainstring/) && !(/$ftpstring/) )
		{
			@userdata = ();
			@userdata = split (/:/, $_);
			$domainuser = $userdata[0];
			for $deluser (@delusers)
			{
				if ( $deluser eq $domainuser )
				{
					$founddeluser = 1;
				}
			}
			if ( $founddeluser == 0 )
			{
				push @user_list, $domainuser;
			}
		}
	}
	close (PASSUSERS);

	# Add users awaiting addition to this array
	if ( -e $newuserfile )
	{
		open (NEWUSERS, $newuserfile);
		while (<NEWUSERS>)
		{
			@new_user_data = split (/\s+/, $_);
if ( $new_user_data[3] eq $_[0] )
{
push @user_list, $new_user_data[1];
}
}
		close (NEWUSERS);
	}
	
	# sort the list of valid users
	@user_list = sort (@user_list);
	return @user_list;
}

sub find_valid_addresses_for_user
{
	# user is passed as argument to this function
	$searchstring = "$_[0]\$";
	$deleteaddress = 0;
	@addressdata = ();
	@deladdresses = ();
	@newaddresses = ();
	@address_list = ();

	# get a list of adresses awaiting deletion

	if ( -e $deleteaddressfile )
	{
		open (DELADD, $deleteaddressfile) || file_error($deleteaddressfile);
		@deladdresses = <DELADD>;
		close (DELADD);
	}

	# get a list of addresses awaiting addition
	if ( -e $newaddresslist )
	{
		open (ADDADDR, $newaddresslist) || file_error($newaddresslist);
		@newaddresses = <ADDADDR>;
		close (ADDADDR);
	}
	open (VIRT, $virtusertable) || file_error($virtusertable);
	while (<VIRT>)
	{
		if (/$searchstring/)
		{
			@addressdata = split (/\s+/, $_);
			chomp ($addressdata[0]);

			# do not include email addresses awaiting deletion
			for $_ ( @deladdresses )
			{
				if (/^$addressdata[0]/)
				{
					$deleteaddress = 1;
				}
			}
			if ( $deleteaddress == 0 )
			{
				push @address_list, $addressdata[0];
			}
		}
	}			
	
	# include email addresses awaiting addition
	for $_ ( @newaddresses )
	{
		@newaddressdata = split (/\s+/, $_);
		chomp ($newaddressdata[1]);
		if ( $newaddressdata[1] =~ /$searchstring/ )
		{
			chomp ($newaddressdata[0]);
			push @address_list, $newaddressdata[0];
		}
	}
	
	close (VIRT);
	return @address_list;
}

sub find_addresses_awaiting_deletion
{
	if ( -e $deleteaddressfile )
	{
		open (DELADD, $deleteaddressfile) || file_error($deleteaddressfile);
		@delete_addresses = <DELADD>;
		close (DELADD);
		return @delete_addresses;
	}
}

sub find_addresses_awaiting_addition
{
	if ( -e $newaddressfile )
	{
		open (ADDADDR, $newaddressfile) || file_error($newaddressfile);
		@new_addresses = <ADDADDR>;
		close (ADDADDR);
		return @new_addresses;
	}
}

sub find_addresses_awaiting_deletion_for_domain
{
	$searchstring = "$_[0]";
	@addresses_for_this_domain = ();
	@all_domains = find_addresses_awaiting_deletion();
	for $_ (@all_domains)
	{
		if (/$searchstring/)
		{
			push @addresses_for_this_domain, $_;
		}
	}
	return @addresses_for_this_domain;
}

sub find_addresses_awaiting_addition_for_domain
{
	$searchstring = "$_[0]";
	@addresses_for_this_domain = ();
	@all_domains = find_addresses_awaiting_addition();
	for $_ (@all_domains)
	{
		if (/$searchstring/)
		{
			push @addresses_for_this_domain, $_;
		}
	}
	return @addresses_for_this_domain;
}

sub find_multidrops_awaiting_deletion
{
	if ( -e $deletemultidropfile )
	{
		open (MULTI, "<$deletemultidropfile");
		@delete_multidrops = <MULTI>;
		close (MULTI);
		return @delete_multidrops;
	}
}
	
sub find_existing_addresses
{
	$searchstring = "\@$_[0]";
	@existing_addresses = ();
	open (VIRT, $virtusertable) || file_error($virtusertable);
	while (<VIRT>)
	{
		if (/$searchstring/)
		{
			@addressdata = split (/\s+/, $_);
			chomp ($addressdata[0]);
			push @existing_addresses, $addressdata[0];
		}
	}
	close (VIRT);
	return @existing_addresses;
}	

sub find_if_address_exists
{
	# address is passed as argument to this function
	$searchstring = "^$_[0]";

	# get a list of adresses awaiting deletion
	@deladdresses = find_addresses_awaiting_deletion();
	
	# get a list of addresses awaiting addition
	@newaddresses = find_addresses_awaiting_addition();

	open (VIRT, $virtusertable) || file_error($virtusertable);
	while (<VIRT>)
	{
		if (/$searchstring/)
		{
			@addressdata = split (/\s+/, $_);
			chomp ($addressdata[0]);
			# do not include email addresses awaiting deletion
			for $_ ( @deladdresses )
			{
				if (/^$addressdata[0]/)
				{
					# address awaiting deletion - return 0
					close (VIRT);
					return 0;
				}
			}			
			close (VIRT);
			return 1;
		}
	}

	# include email addresses awaiting addition
	for $_ ( @newaddresses )
	{
		@newaddressdata = split (/\s+/, $_);
		chomp ($newaddressdata[0]);
		if ( $newaddressdata[0] =~ /$searchstring/ )
		{
			# address awaiting addition - return 1
			close (VIRT);
			return 1;
		}
	}
		
	close (VIRT);

	# If it's a multidrop, check to see it it's awaiting insertion
	if ( is_multidrop($_[0]) eq "yes" )
	{
		open ( OVERWRITE, "$overwrite_email_with_multidrop_file");
		while (<OVERWRITE>)
		{
			if (/$searchstring/)
			{
				close (OVERWRITE);
				return 1;
			}
		}
		close (OVERWRITE);
	}

	return 0;
}


sub find_email_forwarding
{
	@forwarding = ();
	$searchstring = "\@$_[0]";
	open (VIRT, $virtusertable) || file_error($virtusertable);
	while (<VIRT>)
	{
		if (/$_[0]/)
		{
			@addressdata = split (/\s+/, $_);
			if ( ( $addressdata[1] =~ /\@/ ) && ($addressdata[0] =~ $searchstring) )
			{
				push @forwarding, $_;
			}
		}
	}
	close (VIRT);
	return @forwarding;
}

sub create_new_user
{
	$domain = $_[0];
	$user_type = $_[1];

	$lengthmainuser = length($mainuser);
	$lengthbaseuser = $lengthmainuser - 2;
	$baseuser = substr($mainuser, 0, $lengthbaseuser);

	# User can be an email or ftp user
	if ( $user_type eq "email" )
	{
		@userlist = find_valid_users($domain);
	} else {
		@userlist = find_valid_ftp_users($domain);
		$baseuser = "ftp" . $baseuser;	
	}

	$lasttwodigits = 0;
	$check = 0;
	while ( $check < 1000 )
	{
		$found = 0;
		$lasttwodigits = $lasttwodigits + 1;
		$lasttwochars = sprintf ("%02d", $lasttwodigits);
		$newuser = $baseuser.$lasttwochars;
		
		for $existinguser (@userlist)
		{
			if ( $newuser eq $existinguser )
			{	
				$found = 1;
			}
		}
		
		if ( $found == 0 )
		{
			# break out of the while loop - unique user has been found
			return $newuser;
		}
		$check++;
	}
}

sub create_new_password
{
	@newpass = ();
	do {
		$result = `/usr/local/bin/apg -n 1 -a 0 -m 8 -x 8 -M ncl -E '1IOl0' -t`;
		 ($password, $pronounce) = split ( /\s+/,$result);
		 $pronounce =~ s/\(//g;
		 $pronounce =~ s/\)//g;
	} until !( $password =~ /l/ );
	push @newpass, $password;
	push @newpass, $pronounce;
	return @newpass;

}

sub add_address
{ 
	$new_address = $_[0];
	$target = $_[1];

	# Test the syntax of the first argument (the from part of the pair)
	if ( check_email_address_syntax($new_address) )
	{
		return 0;
	}

	# Test the syntax of the second argument (the to part of the pair) if it is an email address (and not a user)
	if ( $target =~ /@/ )
	{
		if ( check_email_address_syntax($target) )
		{
			return 0;
		}
	}

	# Ensure that the email address is not already created, awaiting creation or awaiting deletion
	$address_exists = find_if_address_exists($new_address);
	if ( $address_exists == 0 ) 
	{
		$new_address = lc ($new_address);
		$target = lc ($target);
		# Address doesn't exist, so add it to file for later processing
		# write this new address information to file for later processing
		open (NEWADDRESS, ">>$newaddressfile");
		print NEWADDRESS $new_address, "\t\t\t", $target, "\n";
		close (NEWADDRESS);
		return 1;
	} else {
		# Address already exists - return 0 for failure
		return 2;
	}
}


sub add_user
{
	$new_flag = $_[0];
	$new_user = $_[1];
	$new_password = $_[2];
	$new_domainname = $_[3];
	$searchstring = "^$new_user";

	if ( $new_flag eq "ftp" )
	{
		# Last argument is the directory
		$new_directory = $_[4];
		@existing_users = find_valid_ftp_users($domainname);	
		open (NEWUSER, ">>$newftpuserfile");
	} else {
		$new_directory = "";
		@existing_users = find_valid_users($domainname);
		open (NEWUSER, ">>$newuserfile");
	}

	for $_ (@existing_users)
	{
		if (/$searchstring/)
		{
			# User already exists
			close (NEWUSER);
			return 0;
		}
	}

	# OK, the user doesn't exist, so add it to the appropriate file for later processing

	print NEWUSER $new_flag, " ", $new_user, " ", $new_password, " ", $new_domainname, " ", $new_directory, "\n";
	close (NEWUSER);
	return 1;
}

sub check_email_address_syntax 
{
	if (
	$_[0] =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/||
	$_[0] =~ /( |,)/ ||
	$_[0] =~ /(\*)/ ||
	$_[0] !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/ )
	{
		# incorrect syntax 
		return 1;
	} else {
		return 0;
	}
}			

sub is_multidrop
{
	( $before, $after ) = split ( /\@/, $_[0] );
	if ( $before eq "" )
	{
		return "yes";
	} else {
		return "no";
	}

}

#sub find_if_multidrop_exists	
#{
#	$searchstring = "$_[0]";
#	open ( OVERWRITE, "$overwrite_email_with_multidrop_file");
#	while (<OVERWRITE>)
#	{
#		if (/$searchstring/)
#		{
###			close (OVERWRITE);
#			return 1;		
#		}
#	}
#	close (OVERWRITE);
#	return 0;
#}

sub find_user_home_directory
{
	# User is passed as only argument
	$searchstring = "$_[0]\:x\:";
	open (PASSFILE, "<$passfile");
	while (<PASSFILE>)
	{
		if (/$searchstring/)
		{
			($user, $password, $user_id, $user_group, $comment, $home_directory, $shell) = split(/:/, $_);
			close (PASSFILE);
			return $home_directory;
		}
	}
	close (PASSFILE);
	return 0;
}

sub find_number_of_out_of_office_replies
{
	# domain name passed as only argument
	@all_users = find_valid_users($_[0]);
	
	$num_out_of_office = 0;
	for $each_user (@all_users)
	{
		$home_dir = find_user_home_directory($each_user);
		$vacation_file = $home_dir . "/.vacation.msg";
		if ( -e "$vacation_file" )
		{
			$num_out_of_office++;
		}
	}
	return $num_out_of_office;
}


sub find_valid_ftp_users
{
	@del_ftp_users = ();
	@ftp_user_list = ();

	$ftpstring = "^ftp";
	$domainstring = "\:$_[0]\:";

	# Get a list of users awaiting deletion - not to be shown as current users

	if ( -e $deleteftpuserfile )
	{
		open (DELUSERS, $deleteftpuserfile) || file_error($deleteftpuserfile);
		while (<DELUSERS>)
		{
			chomp ($_);
			push @del_ftp_users, $_;	
		}
		close (DELUSERS);
	}

	# find ftp users associated with this domain name and create an array of existing ftp users
	open (PASSUSERS, $passfile) || file_error($passfile);
	while (<PASSUSERS>)
	{
		$founddelftpuser = 0;
		if ( (/$domainstring/) && (/$ftpstring/) )
		{	
			@ftp_user_data = ();
			@ftp_user_data = split (/:/, $_);
			$domainuser = $ftp_user_data[0];
			for $del_ftp_user (@del_ftp_users)
			{
				if ( $del_ftp_user eq $domainuser )
				{
					$founddeluser = 1;
				}
			}
			if ( $founddelftpuser == 0 )
			{
				push @ftp_user_list, $domainuser;
			}
		}
	}
	close (PASSUSERS);

	# Add users awaiting addition to this array
	if ( -e $newftpuserfile )
	{
		@new_ftp_user_data = ();
		open (NEWFTPUSERS, "<$newftpuserfile") || file_error($newftpuserfile);
		while (<NEWFTPUSERS>)
		{
			@new_ftp_user_data = split (/\s+/, $_);
			if ( $new_ftp_user_data[3] eq $_[0] )
			{
				push @ftp_user_list, $new_ftp_user_data[1];
			}
		}
		close (NEWFTPUSERS);
	}

	# sort the list of valid users
	@ftp_user_list = sort (@ftp_user_list);
	return @ftp_user_list;
}

sub find_mail_routing
{
	# Domain name is passed as argument.
	# Routing can be either normal (pop), SMTP forwarding or MX record pointing to another mail server
	
	$searchstring = "^$_[0]";
	
	open (LOCALHOSTS, "<$local_host_names") || file_error($local_host_names);
	while (<LOCALHOSTS>)
	{
		if (/$searchstring/)
		{
			close (LOCALHOSTS);
			return "local";
		}
	}

	$mailertable_result = is_mailertable($_[0]);

	if ( $mailertable_result != 0 )
	{
		return $_;
	}

	# Mail is not local or smtp, so return the fact it's remote
	return "remote";
}

sub virus_scanning_status
{
	$searchstring = ".*\@$_[0]";
	open ( VIRUSFILE, "<$virus_scanning_file" ) || file_error($virus_scanning_file);
	while (<VIRUSFILE>)
	{
		if (/$searchstring/)
		{
			# Now ensure that it has not been requested to be turned on and is awaiting update
			open (TURN_ON, "<$create_virus_protection_file");
			while (<TURN_ON>)
			{
				if (/$_[0]/)
				{
					close (TURN_ON);
					close (VIRUSFILE);
					return "on";
				}
			}
			close (TURN_ON);
			close (VIRUSFILE);
			return "off";
		}
	}
	close (VIRUSFILE);

	# Now ensure that it has not been requested to be turned off and is awaiting update
	open (TURN_OFF, "<$remove_virus_protection_file");
	while (<TURN_OFF>)
	{
		if (/$_[0]/)
		{
			close (TURN_OFF);
			return "off";
		}
	}
	close (TURN_OFF);	
	return "on";
}

sub spam_scanning_status
{
	#$searchstring = ".*\@$_[0]";
	$searchstring = "^FromOrTo:.*\@$_[0]";

	# This file shows domains with spam scanning turned off
	open ( SPAMFILE, "<$spam_scanning_file" ) || file_error($spam_scanning_file);
	while (<SPAMFILE>)
	{
		if (/$searchstring/)
		{
			# Now ensure that it has not been requested to be turned on and is awaiting update
			if ( -e $create_spam_protection_file )
			{
				open (TURN_ON, "<$create_spam_protection_file");
				while (<TURN_ON>)
				{
					if (/$_[0]/)
					{
						close (TURN_ON);
						close (SPAMFILE);
						return "on";	
					}
				}
				close (TURN_ON);
			}	
			close (SPAMFILE);
			return "off";
		}
	}
	close (SPAMFILE);
	
	# Now ensure that it has not been requested to be turned off and is awaiting update
	if ( -e $remove_spam_protection_file )
	{
		open (TURN_OFF, "<$remove_spam_protection_file") || file_error($remove_spam_protection_file);
		while (<TURN_OFF>)
		{
			if (/$_[0]/)
			{
				close (TURN_OFF);
				return "off";
			}
		}
		close (TURN_OFF);
	}
	return "on";
}	

sub spam_actions_status
{
	# domain name passed as only argument
	$searchstring = "To\:\s+$_[0]\s+";
	open (SPAMTRAPS, "<$spam_trap_file") || file_error($spam_trap_file);
	while (<SPAMTRAPS>)
	{
		if ( $_ =~ m/To\:\s+$_[0]/ )
		{
			# Check to ensure that it's not awaiting deletion
			$delete_searchstring = "^$_[0]";
			if ( -e $delete_spam_trap_file )
			{
				open ( DELETETRAP, $delete_spam_trap_file ) || file_error($delete_spam_trap_file);
				while (<DELETETRAP>)
				{
					if (/$delete_searchstring/)
					{
						close (SPAMTRAPS);
						close (DELETETRAP);
						return "off";			
					}
				}
				close (DELETETRAP);
			}	
			close (SPAMTRAPS);
			return "on";
		}
	}
	close (SPAMTRAPS);
	
	# Check to ensure that it's not awaiting insertion
	$create_searchstring = "^$_[0]";
	if ( -e $create_spam_trap_file )
	{
		open ( CREATETRAP, $create_spam_trap_file ) || file_error($create_spam_trap_file);
		while (<CREATETRAP>)
		{
			if (/$create_searchstring/)
			{
				close (CREATETRAP);
				return "on";
			}
		}
	}
	close (CREATETRAP);
	return "off";
}

sub is_ip_address_syntax_correct
{
	if ( $_[0] =~ /\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b/ )
	{
		# ensure reserved IP addresses are not included
@octets = split ( /\./, $_[0] );
if ( ($octets[0] == 0) || ($octets[0] == 127) || ($octets[0] == 10) || ( ($octets[0] >= 224) && ($octets[0] <=239) ) )
 	{
			return "restricted";
		}
		if ( $octets[0] == 172 )
		{
			if ( ($octets[1] >= 16) && ($octets[1] <= 31) )
			{
				return "restricted";

			}
		}
		if ( ($octets[0] == 192) && ($octets[1] == 168) )
		{
			return "restricted";
		}
		if ( ($octets[0] == 169) && ($octets[1] == 254) )
		{
			return "restricted";
		}
		return "yes";
	} else {
		return "no";
	}
}

sub find_databases
{
	# get first 5 characters on domain name
	@dbarray = ();
	$start = substr ( $_[0], 0, 5 );

	open ( DBS, "ls $databasedir | grep -v phpbb | grep -v osc_ |" );
	while ( <DBS> )
	{
		if ($_ =~ $start)
		{
			push ( @dbarray, $_);
		}
	}
	close (DBS);
	return @dbarray;
}

sub check_if_board_exists
{
	# takes domain name as only argument
	$boardconf = $boarddir . "www." . $_[0];
	if ( -e $boardconf )
	{
		return "yes";
	} else {
		return "no";
	}
}

sub check_if_search_engine_exists
{
	# takes domain name as only argument
	($host, $tld)= split ( /\./, $_[0] );
	$htconf = $searchenginedir . $host . "." . "conf";
	if ( -e $htconf )
	{
		return "yes";
	} else {
		# ensure it's not awaiting addition
		if ( -e $create_search_engine_file )
		{
			open ( AWAITINGSE, "<$create_search_engine_file" ) || file_error($create_search_engine_file);
			while (<AWAITINGSE>)
			{
				if (/$_[0]/)
				{
					close (AWAITINGSE);
					return "yes";
				}
			}
			close (AWAITINGSE);
		}
		return "no";
	}
}

sub check_if_shop_exists
{
	# takes domain name as only argument
	$shopdomain = "shop." . $_[0];
	open ( DIG, "dig $shopdomain |" ) || file_error("Dig failure");
	$searchvar = $shopdomain . ".*[0-9].*";
	while (<DIG>)
	{
		if (/$searchvar/)
		{
			close (DIG);
			return "yes";
		}
	}
	close (DIG);
	return "no";
}

sub check_if_password_protection_exists
{
	# this entry has been made as password protection module is not complete
	return "yes";
	$home_dir = find_user_home_directory($mainuser);
	$htpass_file = $home_dir . "/.htpasswd";
	if ( -e $htpass_file )
	{
		return "yes";
	} else {
		return "no";
	}
}

sub spam_whitelist_status
{
	# takes domain name as only argument
	$whitelist_file = "$whitelistdir$_[0]";
	if ( -e $whitelist_file )
	{
		return "yes";
	}

	if ( -e $create_spam_whitelist_file )
	{
		open ( AWAITINGWHITELIST, "<$create_spam_whitelist_file") || file_error($create_spam_whitelist_file);
		while (<AWAITINGWHITELIST>)
		{
			if (/$_[0]/)
			{
				return "yes";
				close (AWAITINGWHITELIST);
			}
		}
		close (AWAITINGWHITELIST);
	}
	return "no";		
}

sub virus_notification_status
{
	open ( NOTIFY, "<$virus_notification_file" ) || file_error($virus_notification_file);
	while (<NOTIFY>)
	{
		if (/$_[0]/)
		{
			if ( -e $create_virus_notification_file )
			{
				open ( AWAITINGTURNON, "<$create_virus_notification_file") || file_error($create_virus_notification_file);
				while (<AWAITINGTURNON>)
				{
					if (/$_[0]/)
					{
						close (AWAITINGTURNON);
						close (NOTIFY);
						return "on";
					}
				}
			}
			close (AWAITINGTURNON);
			close (NOTIFY);
			return "off";

		}
	}
	close (NOTIFY);

	if ( -e $remove_virus_notification_file )
	{
		open ( AWAITINGTURNOFF, "<$remove_virus_notification_file") || file_error($remove_virus_notification_file);
		while (<AWAITINGTURNOFF>)
		{
			if (/$_[0]/)
			{
				close (AWAITINGTURNOFF);
				return "off";
			}
		}
	}
	close (AWAITINGTURNOFF);
	return "on";
}

sub find_web_server
{
	$website = "www." . $_[0];
	open ( DIG, "dig $website |" ) || file_error("dig $website");
	$searchvar = "$website.*[0-9].*";
	while (<DIG>)
	{
		if (/$searchvar/)
		{
			@webdata = split (/\s+/, $_);
			return $webdata[4];
		}
	}
	return 0;
}

sub is_ip_address_local
{
	# ip address is passed as only argument
	$search_string = "$_[0]";
	open ( IFCONFIG, "ifconfig |") || file_error("ifconfig");
	while (<IFCONFIG>)
	{
		if (/$search_string/)
		{
			close (IFCONFIG);
			return "yes";
		}
	}
	close (IFCONFIG);

	# ensure that the web server is not the windows server
	if ( $search_string =~ $windows_ip )
	{
		return "windows";
	}
#	return "no";

	#ensure that the webserver is not web01
	elsif ( $search_string =~ $plesk_web_01 )
	{
		return "plesk";
	}
	# ensure that the webserver is not web02
	elsif ( $search_string =~ $plesk_web_02 )
	{
        return "plesk";
    }else 
	{
	return "no";
	}
}


sub virus_advanced_scanning_status
{
	# This function is used by all five advanced virus features to see if they are turned on or off

	# domain name is first argument
	$searchstring = ".*\@$_[0]";
	# Category of advanced scanning is last argument
	$category = $_[1];

	if ($category eq "Suspect HTML")
	{
		$rules_file = $virus_suspect_html_file;
		$turn_on_file = $create_suspect_html_scanning_file;
		$turn_off_file = $remove_suspect_html_scanning_file;
	}

	if ($category eq "Dangerous HTML")
	{
		$rules_file = $virus_dangerous_html_file;
		$turn_on_file = $create_dangerous_html_scanning_file;
		$turn_off_file = $remove_dangerous_html_scanning_file;
	}

	if ($category eq "Suspect content")
	{
		$rules_file = $virus_suspect_content_file;
		$turn_on_file = $create_suspect_content_scanning_file;
		$turn_off_file = $remove_suspect_content_scanning_file;
	}

	if ($category eq "Filename")
	{
		$rules_file = $virus_filename_file;
		$turn_on_file = $create_filename_scanning_file;
		$turn_off_file = $remove_filename_scanning_file;
	}
	
	# Check the rules file
	open ( VIRUS_SCAN, "<$rules_file") || file_error ($rules_file);
	while (<VIRUS_SCAN>)
	{
		if (/$searchstring/)
		{
			# This means that the option is currently turned off - see if it's waiting to be turned on
			if ( -e $turn_on_file )
			{
				open ( TURN_ON, "<$turn_on_file") || file_error (turn_on_file);
				while (<TURN_ON>)
				{
					if (/^$_[0]/)
					{
						close (VIRUS_SCAN);
						close (TURN_ON);
						return "on";
					}
				}
				close (TURN_ON);
			}
			close (VIRUS_SCAN);
			return "off";
		}
	}
	close (VIRUS_SCAN);
	# Not currently turned off - see if it's waiting to be turned off
	if ( -e $ turn_off_file)
	{
		open ( TURN_OFF, "<$turn_off_file" ) || file_error($turn_off_file);
		while (<TURN_OFF>)
		{
			if (/^$_[0]/)
			{
				close (TURN_OFF);
				return "off";
			}
		}
		close (TURN_OFF);
	}

	# Not turned off or waiting to be turned off - return on
	return "on";
}

sub is_server_dedicated
{
	$search_string = "inet addr:";
	open ( IFCONFIG, "ifconfig eth0:0 |") || file_error ("ifconfig error on eth0:0");
	while (<IFCONFIG>)
	{
		if (/$search_string/)
		{
			$ip_string = $_;
			break;
		}
	}
	close (IFCONFIG);

	if ( !(defined($ip_string)) )
	{
		open ( IFCONFIG2, "ifconfig eth0:1 |") || file_error ("ifconfig error on eth0:1");;
		while (<IFCONFIG2>)
		{	
			if (/$search_string/)
			{	
				$ip_string = $_;
				break;
			}
		}
	}
	close (IFCONFIG2);

	# Remove extraneous info
		chomp ($ip_string);
		$ip_string =~ s/Bcast.*$//g;
		$ip_string =~ s/$search_string//g;
	# We now have the IP address
		$ip_string =~ s/ //g;
		$ip_address = $ip_string;
	# Now create the possible dedicated host name 
		@ip_octets = split ( /\./, $ip_address);;
		$ip_host = "$ip_octets[2]-" . "$ip_octets[3]";
		$host_name = $dedicated_server_prefix . $ip_host . $dedicated_server_suffix;
	# search for this hostname - if it exists then the server is dedicated
		open ( TESTDIG, "dig $host_name a |");
		while (<TESTDIG>)
		{
			if (/$ip_address/)
			{
				close (TESTDIG);
				return "yes";
			}
		}
		close (TESTDIG);
		return "no";
}

sub content_management_scanning_status
{
	# takes domain name as only argument
	$searchstring = ".*\@$_[0]";
	# turn on/off files
	$turn_on_file = $create_content_management_file;
	$turn_off_file = $remove_content_management_file;

	# Check the rules file
	open ( CONTENT_SCAN, "<$content_management_file") || file_error ($content_management_file);
	while (<CONTENT_SCAN>)
	{
		if (/$searchstring/)
		{
			# This means that the option is currently turned on - see if it's waiting to be turned off
			if ( -e $turn_off_file )
			{
				open ( TURN_OFF, "<$turn_off_file") || file_error (turn_off_file);
				while (<TURN_OFF>)
				{
					if (/^$_[0]/)
					{
						close (CONTENT_SCAN);
						close (TURN_OFF);
						return "off";
					}
				}	
				close (TURN_OFF);
			}
			close (CONTENT_SCAN);
			return "on";
		}
	}
	close (CONTENT_SCAN);
	# Not currently turned on - see if it's waiting to be turned on
	if ( -e $ turn_on_file)
	{
		open ( TURN_ON, "<$turn_on_file" ) || file_error($turn_on_file);
		while (<TURN_ON>)
		{
			if (/^$_[0]/)
			{
				close (TURN_ON);
				return "on";
			}
		}
		close (TURN_ON);
	}
	# Not turned on or waiting to be turned on - return off
	return "off";
}

sub filetype_scanning_status
{
	# This function checks to see which of the four options below are relevant [ if any ] for the domain
	# default: filetype.everything.conf
	# if virus filetype off but spam image scanning on: filetype.justimages.conf
	# if virus filetype on but spam image scanning off: filetype.justvirus.conf
	# if virus filetype off but spam image scanning off: filetype.nothing.conf

	# domain name is only argument
	$searchstring = ".*\@$_[0]";

	# default return value is both are active
	$default_status = "only_virus";
	$only_spam_status = "only_spam";
	$everything_status = "everything";
	$nothing_status = "nothing";

	# set the status to the default value - used if the domain is not found in the files below
	$status = $default_status;

	# possible return values
	$everything = "filetype.everything.conf";
	$only_spam = "filetype.justimages.conf";
	$nothing = "filetype.nothing.conf";
	
	open ( FILETYPE, "<$filetype_file" ) || file_error($filetype_file);
	while (<FILETYPE>)
	{
		if (/$searchstring/)
		{
			if (/$nothing/)
			{
				$status = $nothing_status;
			} elsif (/$everything/) {
				$status = $everything_status;
			} else {
				$status = $only_spam_status;
			}
			break;
		}
	}

	# Now check the change file to see what ammendments are awaiting addition
	
	if ( -e $change_filetype_scanning_file )
	{
		open (CHANGES, "<$change_filetype_scanning_file") || file_error($change_filetype_scanning_file);
		while (<CHANGES>)
		{
			if (/$_[0]/)
			{
				if (/$nothing_status/)
				{
					$status = $nothing_status;
				} elsif (/$everything_status/) {
					$status = $everything_status;
				} else {
					$status = $only_spam_status;
				}
			}		
		}
		close (CHANGES);
	}
	return $status;
}
