#!/usr/bin/perl

# This script is called to search through the deletespamtrap mailbox, extract the spam trap name and domain name provided
# and if this information tallies with the passwd file, the spam trap is deleted (emptied)
# Noel McDermott [01/09/2004]

# Important Notes: [01/09/2004]
#
# 1
# Bug known to exist: if an email is sent which provides a subject line but does not provide a spam trap name, then should another 
# deletion request be entered before the mail box is parsed, the spam trap name of the newly entered request will be coupled with
# the subject line [and so domain name] of the original request. This pair of data will then fail, as the spam trap [of second request]
# will not be owned by the domain in the subject line [of original request]. The result wll be that both spam trap deletions will fail.
#
# 2
# All file names and variables are hard coded in thi script due to difficulties in using use and require when the execution
# script [updatevpanel.sh] is in the management directory
#

$start = "^Subject:";
$end = "SpamTrapName";
$tmp_delete_spam_trap_mailbox = "/tmp/spam_trap_mailbox_section.tmp";
$delete_spam_trap_mailbox = "/var/spool/mail/deletespamtrap";

open (MBOX,$delete_spam_trap_mailbox);
while(<MBOX>)
{
	# Capture the relevant sub section of the mails in the mailbox
	open ( TMPMBOX,">>$tmp_delete_spam_trap_mailbox" );
	print TMPMBOX if /$start/../$end/;
	close (TMPMBOX);

	open ( TMPMBOX,"<$tmp_delete_spam_trap_mailbox" );
	while (<TMPMBOX>)
	{
		if (/$start/)
		{
			# Now sift through the subject line to catch the domain name
			@subject_data = split ( /\s+/, $_ );
			$num_strings = @subject_data;
			for ( $i = 0 ; $i < $num_strings ; $i++ )
			{
				if ( $subject_data[$i] =~ /.*\..*/ )
				{
					$spam_trap_domain_name = $subject_data[$i];
				}
			}
		}

		if (/$end/)
		{
			chomp ($_);			
			( $spam_trap_heading, $spam_trap_name ) = split ( /:/, $_);
			$spam_trap_name =~ s/\s+//g;
			# Now all elements have been found - ensure spam trap [$spam_trap_name] is owned by domain [$spam_trap_domain_name]
			if ( ( !(defined($spam_trap_name) ) ) || !(defined($spam_trap_domain_name) ) )
			{
				system "logger -p local3.info -t vpanel \"$spam_trap_name: deletion of mailbox failed: incomplete data supplied:-$spam_trap_name- and -$spam_trap_domain_name-\"";
				next;
			} else {
				# Ensure that the domain name owns the spam trap
				$searchstring = "^$spam_trap_name:";
				open (PASSFILE, "</etc/passwd");
				while (<PASSFILE>)
				{
					if (/$searchstring/)
					{
						($user, $password, $user_id, $user_group, $comment, $home_directory, $shell) = split(/:/, $_);
						$passwd_spam_trap_domain = $comment;
						break;
					}
				}
				close (PASSFILE);
				
				if ( ! defined($passwd_spam_trap_domain) )
				{
					system "logger -p local3.info -t vpanel \"$spam_trap_name: deletion of mailbox failed: not found in pass file\"";
					next;
				} else {
					if ( $passwd_spam_trap_domain ne $spam_trap_domain_name)
					{
						system "logger -p local3.info -t vpanel \"$spam_trap_name: owner in passfile [$passwd_spam_trap_domain] not equal to domain owner supplied [$spam_trap_domain_name]\"";
						next;
					} else {
						system "logger -p local3.info -t vpanel \"$spam_trap_name: Proceeding to delete mailbox, as provided domain owner [$spam_trap_domain_name] matches the domain in the passwd file [$passwd_spam_trap_domain]\"";
						# Place the spam trap in the empty mailbox list file	
						open (EMPTY, ">>/var/www/html/vpanel/lists/emptymailbox.list");
						print EMPTY "$spam_trap_name,$spam_trap_domain_name\n";
						close (EMPTY);
					}
				}
			}
		}
	}
	close (TMPMBOX);
	unlink ($tmp_delete_spam_trap_mailbox);
}
close(MBOX);

unlink ($delete_spam_trap_mailbox);
