#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;
$domainname = find_domain ($mainuser);
$delete_user = param ('user');

# Define the tab which appears to the front
$tab_section = $tabnum_email;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header ("Deletion of the user $delete_user for $domainname");
print "Thank you for your request to delete the user $delete_user.";

# Ensure that the user is not already awaiting deletion
$awaiting_deletion = 0;
open (AWAITING, "<$deleteuserfile");
while (<AWAITING>)
{
	if (/$delete_user/)
	{
		$awaiting_deletion = 1;
		break;
	}
}
close (AWAITING);

if  ( $awaiting_deletion == 0 )
{
	# Write the user to a file for later deletion

	$ret = php_request ("setDelChild", "scope=domain:$domainname", "childName=user:$delete_user\@$domainname");
	$ret = php_request ("addForward", $address, $target);
	if (defined ($ret) && ref ($ret) ne "SCALAR") {
		show_time_to_change();
	} else {
		print "<BR>Sorry, but the user deletion of $delete_user failed. Maybe the user as email addresses assigned to him? You need to delete them first.<BR>";
	}
} else {
	print "<BR>Sorry, but the user $delete_user seems to be awaiting deletion already.<BR>";
}

require $footer;
