#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;
$domainname = find_domain ($mainuser);

# Define the tab which appears to the front
$tab_section = $tabnum_website;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

$pw_user = param('user');
$pw_password = param('password');
$directory = param('directory');

print_header ("Creation of a password protected area on www.$domainname");

# Ensure that the .htpasswd file doesn't already exust - if so do not allow another ptotected directory to be created
$pw_exists = check_if_password_protection_exists($domainname);

if ( $pw_exists eq "yes" )
{
	print "Sorry, but it seems that you already have a password protected directory installed on your website.";
	print_support_contact_information();
} else	{
	# Write info to file for later processing
	open (PWPROTECT, ">>$create_pw_protection_file") || file_error($create_pw_protection_file);
	print PWPROTECT "$domainname,$pw_user,$pw_password,$directory\n";
	close (PWPROTECT);

	print "
		Thank you. Please find below a summary of you new password protected area:<BR><BR>
		<table width=60% border=0 class=text>
		<TR><TD>Protected directory:</TD><TD><b>www.$domainname/$directory</b></TD></TR>
		<TR><TD>Main user: </TD><TD><b>$pw_user</b></TD></TR>
		<TR><TD>Password: </TD><TD><b>$pw_password</b></TD></TR>
		<TR><TD>Web page to manage users:</TD><TD><b>www.$domainname/$directory/$password_protection_entry_page</b></TD></TR>
		</table>
	";

	show_time_to_change();	
}

require $footer;
