#!/bin/bash

HOSTSERVER=`hostname -f`
DOMAIN=$1
SITEBACKUPDIR="/var/www/html/site_backups"
DIRECTORY=/var/customers/www.$DOMAIN/website/htdocs

cd $DIRECTORY

if [ -e $SITEBACKUPDIR/$DOMAIN.zip ]
then
	rm -f $SITEBACKUPDIR/$DOMAIN.zip
fi

echo "<br>Backing up site. Please wait .....<br><br>"

/usr/bin/zip -qr -b /tmp $SITEBACKUPDIR/$DOMAIN.zip *

if [ -e $SITEBACKUPDIR/$DOMAIN.zip ]
then
	logger -p local3.info -t vpanel "$DOMAIN website backed up"
	echo "The backup of your website has completed successfully. To ensure that this backup is maintained, please"
	echo " save a copy <br>of your website to your PC. To do this, please "
	
	echo "<a href=http://$HOSTSERVER/site_backups/$DOMAIN.zip>"
	echo "<font color=#DD0000>click here</font></a>."
else
        logger -p local3.info -t vpanel "Failure to backup $DOMAIN"
	echo "Backup failed. Please contact our <a href=mailto:support@ieinternet.com>Support Department</a>"
fi

echo "<br><br>"
