#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$spam_whitelist = "$whitelistdir$domainname";
$num_addresses = param('numaddresses');
@addresses = param('addresses');
$new_address = param('newaddress');
$new_address = lc($new_address);
$whitelisted_address_already_exists = 0;

# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header("Amending the spam whitelist for $domainname");

print "
	Thank you for your request to amend your spam whitelist. An updated list of all email addresses on your spam 
	whitelist is below:<BR><BR>
";

$string = "";
 
for $_ (@addresses)
{
        print "$_<BR>";
	$string .= $_.",";
	$whitelisted_address_already_exists = 1 if ($new_address eq $_);
}

if ( $new_address ne "" )
{
	if ( check_email_address_syntax($new_address) == 1  )
	{
		print qq!
			<BR>Sorry, but your request to add <i>$new_address</i> to your spam whitelist has failed as it appears 
			its syntax is incorrect.<BR><BR>
		!;
		print_support_contact_information();		
	} else {
		# ensure that the email address is not already a part of the whitelist
		if ( $whitelisted_address_already_exists == 0 )
		{
			$string .= $new_address.",";
			$ret = php_request ("setWhiteList", "scope=domain:$domainname", "whitelist=$string");
			print "<i>$new_address</i>" if (defined ($ret) && ref ($ret) ne "SCALAR");
			print "
			        <BR><BR>If you would like to further amend your spam whitelist please 
				<a href=/$script_bin/$add_to_spam_whitelist>
			        click here</a>.<BR><BR>
			";

		} else {
			print "<BR>Sorry, but your request to add <i>$new_address</i> to your spam whitelist has failed as it appears
				to already be in your spam whitelist.<BR><BR>";
			print_support_contact_information();
		}
	}
} else {
	$ret = php_request ("setWhiteList", "scope=domain:$domainname", "whitelist=$string");
	if ( $num_addresses == 0 )
	{
		# this means that no email addresses have been added and the whitelist is now empty - display this
		print "<i><< There are no email addresses currently in your spam whitelist >></i>";
	}
	print "
		<BR><BR>If you would like to further amend your spam whitelist please
                <a href=/$script_bin/$add_to_spam_whitelist>
                click here</a>.<BR><BR>
	";
}

require $footer;
