#!/usr/bin/php
<?php
/*
 * Created on 6 Jun 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
// $SYNC_AD_DRY_MODE - BLOCKS ALL COMMITS - Displays printing to show what would be done
//	0 = OFF
//	1 = ON
$SYNC_AD_DRY_MODE = 0;

/*
 * Do not confuse with the web client's MWSoapClient. This one is more lightweight.
 */
if (class_exists ("SoapClient")) { // PHP 5 with SOAP support
	require_once ('mw2cli-php5.php');
} else {
	require_once ('mw2cli-php4.php'); // PHP 4 with PEAR
}
// Require the ADSync class, if the file exists
if (file_exists(dirname(__FILE__).'/adsync.php'))
	require_once(dirname(__FILE__).'/adsync.php');

// implement property_exists if not available. Applicable for PHP 4 and PHP 5.0
if (!function_exists ("property_exists")) {
	function property_exists ($obj, $property) {
		if (is_string ($obj)) {
			if (!class_exists ($obj)) {
				return false;
			}
			$object = new $obj;
			return array_key_exists ($property, get_object_vars ($object));
		} elseif (is_object ($obj)) {
			return array_key_exists ($property, get_object_vars ($obj));
		}
	}
}

$map = array (
	'global' => 1,
	'domain' => 3,
	'user' => 4,
	'email' => 5,
);

$hostingPlan = array (
	'app' => array ('userLimit' => 100, 'spaceLimit' => 110),
	'soho' => array ('userLimit' => 1, 'spaceLimit' => 20),
	'bus' => array ('userLimit' => 20, 'spaceLimit' => 50),
	'ded' => array ('userLimit' => 500, 'spaceLimit' => 2000),
);

$vHostDomainMap = array ();

if (!is_array ($_SERVER))
	$_SERVER = array ();
if (!array_key_exists ("HTTP_USER_AGENT", $_SERVER))
	$_SERVER['HTTP_USER_AGENT'] = "mw2cli.php";

$defaultDomain = "ieinternet.ie";

$exePath = "/var/www/html/vpanel/management";

function logger ($priority, $string)
{
	global $debug;
	static $open = false;
	if (!$open) {
		openlog ("vpanel", 0, LOG_LOCAL3);
		$open = true;
	}
	if ($debug)
		echo "$string\n";
	syslog ($priority, $string);
}

function parseLdapConf ()
{
	global $conf, $debug;
	if ($debug) echo "Parsing ldap.conf ... ";
	if (file_exists ("/etc/ldap.conf")) {
		$file = file ("/etc/ldap.conf");
		foreach ($file as $line) {
			if (preg_match ('/^\s*#/', $line) > 0)
				continue;
			if (preg_match ('/^\s*(\S+)\s+(\S.*)/', $line, $matches) > 0)
				$conf[$matches[1]] = $matches[2];
		}
	}

	foreach (array ('host', 'base') as $req)
		if (! array_key_exists ($req, $conf)) {
			echo "Missing parameter $req in /etc/ldap.conf\n";
			exit (3);
		}
	if ($debug) echo "done\n";
}

function ldapConnect ()
{
	global $conf, $ldapHandle, $debug;
	if ($debug) echo "Connecting to LDAP server ... ";

	if (!$ldapHandle = ldap_connect ($conf['host'], $conf['port'])) {
		echo "ldap_connect failed ".ldap_error($ldapHandle)."\n";
		exit (4);
	}

	if ($debug) echo "done\nAuthenticating ... ";

	ldap_set_option($ldapHandle, LDAP_OPT_PROTOCOL_VERSION, 3);
	ldap_set_option($ldapHandle, LDAP_OPT_SIZELIMIT, 1000000);

	if (array_key_exists ('binddn', $conf) && isset ($conf['binddn'])) {
		// Authenticate
		if (!ldap_bind($ldapHandle, $conf['binddn'], $conf['bindpw'])) {
			echo "ldap_bind failed ".ldap_error($ldapHandle)."\n";
			exit (4);
		}
	} else {
		// Anonymous bind
		if (!ldap_bind($ldapHandle)) {
			echo "ldap_bind failed ".ldap_error($ldapHandle)."\n";
			exit (4);
		}
	}
	if ($debug) echo "done\n";
}

function mysqlConnect ($dsn, $dbName, $dbUser, $dbPass)
{
	global $debug;
	if ($debug) echo "Connecting to MySQL server ... ";
	#$dbh = new PDO($settings['dsn'], $settings['user'], $settings['pass'], $settings['driverOpts']);
	if (!$dbh = new PDO("$dsn;dbname=$dbName", $dbUser, $dbPass, null)) {
		echo "MySQL connect failed\n";
		exit (4);
	}
	if ($debug) echo "done\n";

	$dbh->exec("SET time_zone = '+0:00'");
	$dbh->setAttribute(constant ("PDO::MYSQL_ATTR_USE_BUFFERED_QUERY"), 1); // eval required due to stupid php 4
	return $dbh;
}

function createTmpTables ($incremental = false)
{
	global $dbh, $debug;
	/*
	if ($debug) echo "Creating temporary tables ... ";
	$dbh->exec ("CREATE TEMPORARY TABLE ElemsDel (ElemID VARBINARY(100) NOT NULL, ScopeID INT(11) NOT NULL, ".
		"Name VARCHAR(255) NOT NULL, PRIMARY KEY  (ElemID), KEY ScopeID (ScopeID), ".
		"KEY ElemLabel (Name)) ENGINE=MyISAM");
	$dbh->exec ("CREATE TEMPORARY TABLE ElemsAdd (ParentScope VARCHAR(255), ChildScope VARCHAR(255)) ENGINE=MyISAM");
	*/	
	if ($debug) echo "Flushing scratch tables ... ";
	$dbh->exec ("DELETE FROM ResellerMap;");
	$dbh->exec ("DELETE FROM ElemsDel;");
	$dbh->exec ("DELETE FROM ElemsAdd;");
	$dbh->exec ("DELETE FROM ParamsDel;");
	$dbh->exec ("DELETE FROM ParamsAdd;");
	if ($debug) echo "done\n";

	if (! $incremental) {
		if ($debug) echo "Initialising table contents ... ";
		// this might take a while :-)
		$dbh->exec ("INSERT INTO 
				ElemsDel (ElemID, ScopeID, Name) SELECT ElemID, ScopeID, Name 
				FROM Elems WHERE ScopeID IN (2,3,4,5)");
		$dbh->exec ("INSERT INTO 
				ParamsDel (ElemID, ParamName, ParamValue) SELECT Elems.ElemID, ParamName, ParamValue 
				FROM Elems, Params WHERE ScopeID IN (3,4) AND Elems.ElemID = Params.ElemID");
		
		// only these params
		$dbh->exec ("DELETE FROM ParamsDel WHERE ParamName NOT IN ('MainUser', 'HostingPlan', 'Status', 'VHost', 'ForwardTo')");
		//$dbh->exec ("INSERT INTO ElemsDel (ElemID, ScopeID, Name) SELECT ElemID, ScopeID, Name FROM Elems WHERE ScopeID IN (7)");
		if ($debug) echo "done\n";
	}
}

function sqlSyncWhatever ($sqlQueryDel, $sqlArrayDel, $sqlQueryAdd, $sqlArrayAdd)
{
	global $dbh, $debug;
	
	$statement = $dbh->prepare ($sqlQueryDel);
	if (!$statement) {
		echo "Error: ";
		var_dump ($dbh->errorInfo());
		return;
	}

	$statement->execute ($sqlArrayDel);
	if ($statement->rowCount() == 0) {
		$statement = $dbh->prepare ($sqlQueryAdd);
		if (!$statement) {
			echo "Error: ";
			var_dump ($dbh->errorInfo());
			return;
		}
		$statement->execute ($sqlArrayAdd);
	} 
}

function attrCmp ($attrs, $attrName, $attrValue)
{
	if (!array_key_exists ($attrName, $attrs))
		return false;
	if (is_array ($attrs[$attrName])) {
		for ($i = 0; $i < $attrs[$attrName]['count']; $i++)
			if ($attrs[$attrName][$i] == $attrValue)
				return true;
		// not found
		return false;
	} elseif ($attrs[$attrName] == $attrValue)
		return true;
	// else
	return false;
}

function attrGetOne ($attrs, $attrName)
// if attribute is multi, return first one
{
	if (!array_key_exists ($attrName, $attrs))
		return false;
	if (is_array ($attrs[$attrName]))
		return $attrs[$attrName][0];
	//else
	return $attrs[$attrName];
}

function attrGetArray ($attrs, $attrName)
// if attribute is one, return array of one
{
	if (!array_key_exists ($attrName, $attrs))
		return array ();
	if (is_array ($attrs[$attrName])) {
		unset ($attrs[$attrName]['count']);
		return array_values ($attrs[$attrName]);
	}
	//else
	return array($attrs[$attrName]);
}

function processReseller ($resellerName) {
	global $path;
	sqlSyncWhatever (
		"DELETE FROM ElemsDel WHERE ".
			"ScopeID = 2 AND ".
			"Name = :resellerName",
		array (
			':resellerName' => $resellerName,
		),
		"INSERT INTO ElemsAdd VALUES (2, 'global:global', :resellerName)",
		array (
			':resellerName' => "reseller:".$resellerName,
		)
	);
}

function processDomain ($domainName) {
	global $path;
	sqlSyncWhatever (
		"DELETE FROM ElemsDel AS d USING ElemsDel AS d, ElemsDel AS r WHERE ".
			"d.ScopeID = 3 AND r.ScopeID = 2 AND ".
			"d.Name = :domainName AND ".
			"r.Name = :resellerName AND ".
			"SUBSTR(d.ElemID, 1, LENGTH(d.ElemID) - 10) = r.ElemID",
		array (
			':resellerName' => $path[0],
			':domainName' => $domainName,
		),
		"INSERT INTO ElemsAdd VALUES (3, :resellerName, :domainName)",
		array (
			':domainName' => "domain:".$domainName,
			':resellerName' => "reseller:".$path[0],
		)
	);
}

function processUser ($userName)
{
	global $path;
	list ($systemUser, $domainName) = explode ('@', $userName);
	sqlSyncWhatever (
		"DELETE FROM ElemsDel AS u USING ElemsDel AS u, ElemsDel AS d, ElemsDel AS r WHERE ".
			"u.ScopeID = 4 AND d.ScopeID = 3 AND r.ScopeID = 2 AND " .
			"u.Name = :userName AND " .
			"d.Name = :domainName AND ".
			"r.Name = :resellerName AND ".
			"SUBSTR(u.ElemID, 1, LENGTH(u.ElemID) - 10) = d.ElemID AND " .
			"SUBSTR(d.ElemID, 1, LENGTH(d.ElemID) - 10) = r.ElemID",
		array (
			':userName' => $systemUser,
			':domainName' => $domainName,
			':resellerName' => $path[0],
		),
		"INSERT INTO ElemsAdd VALUES (4, :domainName, :userName)",
		array (
			':domainName' => "domain:".$domainName,
			':userName' => "user:".$systemUser,
		)
	);
}

function processEmail ($emailName) {
	global $path;
	list ($systemUser, $domainName) = explode ('@', $path[2]);
	list ($emailPart) = explode ('@', $emailName);
	sqlSyncWhatever (
		"DELETE FROM ElemsDel AS e USING ElemsDel AS e, ElemsDel AS u, ElemsDel AS d, ElemsDel AS r WHERE ".
			"u.ScopeID = 4 AND d.ScopeID = 3 AND e.ScopeID = 5 AND r.ScopeID = 2 " .
			"AND u.Name = :userName AND d.Name = :domainName AND e.Name = :emailName AND r.Name = :resellerName ".
			"AND SUBSTR(e.ElemID, 1, LENGTH(e.ElemID) - 10) = u.ElemID ".
			"AND SUBSTR(u.ElemID, 1, LENGTH(u.ElemID) - 10) = d.ElemID ".
			"AND SUBSTR(d.ElemID, 1, LENGTH(d.ElemID) - 10) = r.ElemID",
		array (
			':emailName' => $emailPart,
			':domainName' => $path[1],
			':userName' => $systemUser,
			':resellerName' => $path[0],
		),
		"INSERT INTO ElemsAdd VALUES (5, :user, :email)",
		array (
			':user' => "user:".$path[2],
			':email' => "email:".$emailPart,
		)
	);
}

function processForward ($forwardName, $forwardTo) {
	list ($emailPart, $domainName) = explode ('@', $forwardName);
	#echo "syncing $forwardName ($emailPart, $domainName) -> $forwardTo ... \n";
	sqlSyncWhatever (
		"DELETE FROM ElemsDel AS f USING ElemsDel AS f, Elems AS d WHERE ".
			"f.ScopeID = 9 AND d.ScopeID = 3 " .
			"AND f.Name = :forwardName AND d.Name = :domainName ".
			"AND SUBSTR(f.ElemID, 1, LENGTH(f.ElemID) - 10) = d.ElemID",
		array (
			':forwardName' => $emailPart,
			':domainName' => $domainName,
		),
		"INSERT INTO ElemsAdd VALUES (9, :domain, :forward)",
		array (
			':domain' => "domain:".$domainName,
			':forward' => "forward:".$emailPart,
		)
	);
	sqlSyncWhatever (
		"DELETE FROM ParamsDel USING ParamsDel, Elems AS f, Elems AS d WHERE ".
		"f.ElemID = ParamsDel.ElemID AND f.Name = :elemName ".
		"AND d.Name = :domainName ".
		"AND SUBSTR(f.ElemID, 1, LENGTH(f.ElemID) - 10) = d.ElemID ".
		"AND f.ScopeID = 9 AND d.ScopeID = 3 ".
		"AND ParamName = 'ForwardTo' AND ParamValue = :paramValue",
		array (
			':elemName' => $emailPart,
			':domainName' => $domainName,
			':paramValue' => $forwardTo,
		),
		"INSERT INTO ParamsAdd VALUES (:elemName, :paramName, :paramValue)",
		array (
			':elemName' => "forward:".$forwardName,
			':paramName' => "ForwardTo",
			':paramValue' => $forwardTo,
		)
	);
}

function processParam ($elemName, $scopeID, $paramName, $paramValue, $elemNameLong = null)
{
	if ($scopeID == 4)
		$scopeName = "user";
	elseif ($scopeID == 3)
		$scopeName = "domain";
	sqlSyncWhatever (
		"DELETE FROM ParamsDel USING ParamsDel, Elems WHERE ".
		"Elems.ElemID = ParamsDel.ElemID AND Elems.Name = :elemName ".
		"AND ScopeID = :scopeID ".
		"AND ParamName = :paramName AND ParamValue = :paramValue",
		array (
			':elemName' => $elemName,
			':scopeID' => $scopeID,
			':paramName' => $paramName,
			':paramValue' => $paramValue,
		),
		"INSERT INTO ParamsAdd VALUES (:elemName, :paramName, :paramValue)",
		array (
			':elemName' => $scopeName.":".($elemNameLong ? $elemNameLong : $elemName),
			':paramName' => $paramName,
			':paramValue' => $paramValue,
		)
	);
}

function getScopeByID ($elemID)
{
	global $dbh;
	$stmt = $dbh->prepare ("SELECT s.Name AS Name FROM Elems AS e, Scopes AS s
				WHERE e.ElemID = :elemID AND e.ScopeID = s.ScopeID");
	$stmt->execute (array (':elemID' => $elemID));
	if (!$row = $stmt->fetch())
		return false;
	$scope = $row['Name'];
	$table = ucfirst (strtolower($row['Name']))."sView";
	$stmt = $dbh->prepare ("SHOW TABLES LIKE '{$table}'");
	$stmt->execute();
	if (!$row = $stmt->fetch())
		$table = "DefaultView";
		
	$stmt = $dbh->prepare ("SELECT ScopeType, ScopeName, ElemID FROM $table
		WHERE ScopeType = :scopeType AND ElemID = :elemID");
	$stmt ->execute (
		array (
			':scopeType' => $scope,
			':elemID' => $elemID,
		)
	);
	if (!$row = $stmt->fetch())
		return false;
	// else
	return $row['ScopeType'].":".$row['ScopeName'];
}

/*function getSmtpSetupByID ($elemID) {
	global $dbh;
	$stmt = $dbh->prepare ("SELECT p.ParamName, p.ParamValue FROM Params p
				WHERE p.ElemID = :elemID
				AND p.ParamName IN ('SMTPConfiguredOnly','SMTPForward','SMTPForwardIP')");
	$stmt->execute (array (':elemID' => $elemID));
	$ret = $stmt->fetchAll(PDO::FETCH_ASSOC);
	$stmt->closeCursor();
	return $ret;
}*/

function getIPs ($hostname, $validate = array ())
{
	$ips = array ();
	foreach (dns_get_record ($hostname) as $rec) {
		if (array_key_exists ('ip', $rec)) {
			if ($validate && in_array ($rec['ip'], $validate))
				return true;
			else
				$ips[] = $rec['ip'];
		}
	}
	if ($validate)
		return false; // no matches
	// else
	return $ips;
}

function getSelectValue ($obj)
{
	$retval = "";
	$items = $obj->items;
	if (is_object ($items) && property_exists ($items, "item"))
		$items = $items->item;
	foreach ($items as $item)
		if ((is_object ($item) && ($item->selected == "true" || $item->selected === true))) {
			$retval = $item->value;
			break;
		} elseif ((is_array($item) && $item['selected'] == "true")) {
			$retval = $item['value'];
			break;
		}
	return $retval;
}

function validateVHost ($param)
{
	global $hostname, $debug, $soapClient, $vHostDomainMap;
	$domainName = preg_replace ('/.*(:|@)/', '', $param); // get rid of username/email
	@$results = dns_get_record ($domainName, DNS_MX);
	if (!is_array ($results)) { // resolving problem
		echo "Looks like $item belongs to a domain that does not resolve, skipping.\n";
		return false;
	}
	$localIPs = getIPs ($hostname);
	
	foreach ($results as $result)
		if ($result['target'] == $hostname || // hostname matches
			getIPs($result['target'], $localIPs)) { // ip matches
			if (! array_key_exists ($domainName, $vHostDomainMap)) {
				$vHostDomainMap[$domainName] = $hostname;
				$params['scope'] = "domain:$domainName";
				$response = $soapClient->sendCommand ("getParamsDomain", $params);
				if (isset ($response) && property_exists ($response['responseParams'], "vHost")) {
					$soapVHost = getSelectValue ($response['responseParams']->vHost);
					if ($soapVHost != $hostname && // hostname matches
						! getIPs($soapVHost, $localIPs)) { // IP matches
						if ($debug)
							echo "Domain $domainName has MX pointing to local vhost, but SOAP disagrees, fixing.\n";
						$params['vHost'] = $hostname;
						$response = $soapClient->sendCommand ("setParamsDomain", $params);
					}
				}
			}
			return true;
			break;
		}
	if ($debug)
		echo "Item $param does not seem to belong to current vhost, skipping.\n";
	return false;
}

function processDelElemList ()
{
	global $dbh, $debug, $soapClient;
	$operation = "setVHostDelChild";
	$params = array ();
	if ($debug) echo "Processing Del Elems List ... ";
	if (! $stmt = $dbh->prepare ("SELECT * FROM ElemsDel ORDER BY LENGTH(ElemID) DESC")) {
		echo "Problem preparing SELECT FROM ElemsDel\n";
		exit (4);
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM ElemsDel\n";
		exit (4);
	}
	while ($row = $stmt->fetch()) {
		$elemID = $row['ElemID'];
		$params['childName'] = getScopeByID ($elemID);
		$params['scope'] = getScopeByID (substr ($elemID, 0, strlen($elemID) - 10));
		if ($debug) echo "Deleting ".$params['childName']." from ".$params['scope']."... ";
		$response = $soapClient->sendCommand ($operation, $params);
		
		if (isset ($response) && $response['responseParams']->success)
			echo " done.\n";
		else
			echo " ".$soapClient->lastError."\n";
	}
	#$dbh->exec ("DELETE FROM ElemsDel");
	if ($debug) echo "done\n";
}

function incElem ($elemID)
{
	$length = strlen ($elemID);
	$num = gmp_init ($elemID, 10);
	$newStr = gmp_strval (gmp_add ($num, 1));
	$newStr = str_repeat ("0", $length - strlen($newStr)) . $newStr;
	return $newStr;
}

function syncSoHoSA ()
{
	global $dbh, $debug, $spamAssassinDB;
	if (is_array ($spamAssassinDB)) {
		foreach (array ('dsn', 'dbName', 'dbUser', 'dbPass') as $key)
			if (!(array_key_exists ($key, $spamAssassinDB) && isset ($spamAssassinDB[$key]))) {
				echo "SA DB key $key not defined.\n";
				exit (3);
			}
	} else  {
		echo "SpamAssassin DB not defined.\n";
		exit (3);
	}
	if ($debug) echo "Processing syncSoHoSA... contd\n";
	if (! $stmt = $dbh->prepare ("SELECT Elems.Name AS Domain FROM Elems, Params, Scopes WHERE " .
			"Elems.ElemID = Params.ElemID AND Elems.ScopeID = Scopes.ScopeID AND " .
			"Scopes.Name = 'domain' AND Params.ParamName = 'HostingPlan' AND " .
			"Params.ParamValue = 'soho'")) {
		echo "Problem preparing SELECT FROM Elems, Params, Scopes\n";
		exit (4);
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM Elems, Params, Scopes\n";
		exit (4);
	}
	$dbhSA = mysqlConnect ($spamAssassinDB['dsn'], $spamAssassinDB['dbName'], 
		$spamAssassinDB['dbUser'], $spamAssassinDB['dbPass']);
	while ($row = $stmt->fetch()) {
		$domainName = $row['Domain'];
		if (! $stmt2 = $dbhSA->prepare ("SELECT prefid, value FROM userpref WHERE " .
				"username = :userName AND preference = 'add_header' AND value LIKE 'spam Flag YES %'")) {
			echo "Problem with preparing SELECT FROM userpref\n";
			continue;
		}
		if (! $stmt2->execute (array (':userName' => "%$domainName"))) {
			echo "Problem with executing SELECT FROM userpref\n";
			continue;
		}
		if ($row = $stmt2->fetch()) {
			if ($row['value'] != "spam Flag YES nothing") {
				echo "UPDATE $domainName spam action to nothing\n";
				$dbhSA->query ("UPDATE userpref SET value ='spam Flag YES nothing' WHERE prefid = ".$row['prefid']);
			}
		} else {
				echo "INSERT $domainName spam action to nothing\n";
				$dbhSA->query ("INSERT INTO userpref (username, preference, value) " .
						"VALUES ('%$domainName', 'add_header', 'spam Flag YES nothing')");
		}
	
	}
	if ($debug) echo "done\n";
}

function processAddElemList ()
{
	// TODO: make this into SOAP
	global $dbh, $map, $debug, $soapClient;
	$operation = "setVHostAddChild";
	$params = array ();
	if ($debug) echo "Processing Add Elems List ... contd\n";
	if (! $stmt = $dbh->prepare ("SELECT * FROM ElemsAdd ORDER BY Depth ASC")) {
		echo "Problem preparing SELECT FROM ElemsAdd\n";
		exit (4);
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM ElemsAdd\n";
		exit (4);
	}
	while ($row = $stmt->fetch()) {
		list ($params['childType'], $params['childName']) = explode (":", $row['ChildScope']);
		if ($debug) echo "Adding ".$row['ChildScope']. " to ".$row['ParentScope'];
		$params['scope'] = $row['ParentScope'];
		$response = $soapClient->sendCommand ($operation, $params);
		if (isset ($response) && $response['responseParams']->success)
			echo " done.\n";
		else
			echo " ".$soapClient->lastError."\n";
	}
	#$dbh->exec ("DELETE FROM ElemsAdd");
	if ($debug) echo "done\n";
}

function processDelParamList ()
{
	global $dbh, $debug, $soapClient;
	if ($debug) echo "done\n";
	$operation = "setVHostDelParam";
	$params = array ();
	if ($debug) echo "Processing Del Params List ... contd\n";
	if (! $stmt = $dbh->prepare ("SELECT * FROM ParamsDel ORDER BY LENGTH(ElemID) DESC")) {
		echo "Problem preparing SELECT FROM ParamsDel\n";
		exit (4);
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM ParamsDel\n";
		exit (4);
	}
	while ($row = $stmt->fetch()) {
		$elemID = $row['ElemID'];
		$params['scope'] = getScopeByID ($elemID);
		$params['paramName'] = $row['ParamName'];
		if ($debug) echo "Deleting ".$params['paramName']." from ".$params['scope']." ... ";
		$response = $soapClient->sendCommand ($operation, $params);
		if (isset ($response) && $response['responseParams']->success)
			echo " done.\n";
		else
			echo " ".$soapClient->lastError."\n";
	}
	$dbh->exec ("DELETE FROM ParamsDel");
	if ($debug) echo "done\n";
}

function processAddParamList ()
{
	// TODO: make this into SOAP
	global $dbh, $map, $debug, $soapClient;
	$operation = "setVHostAddParam";
	$params = array ();
	if ($debug) echo "Processing Add Params List ... contd\n";
	//if (! $stmt = $dbh->prepare ("SELECT * FROM ParamsAdd ORDER BY Depth ASC")) {
	if (! $stmt = $dbh->prepare ("SELECT * FROM ParamsAdd")) {
		echo "Problem preparing SELECT FROM ParamsAdd\n";
		exit (4);
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM ParamsAdd\n";
		exit (4);
	}
	while ($row = $stmt->fetch()) {
		$params['scope'] = $row['Scope'];
		$params['paramName'] = $row['ParamName'];
		$params['paramValue'] = $row['ParamValue'];
		if ($debug) echo "Setting ".$params['paramName']." to ".$params['paramValue']." for ".$params['scope']." ... ";
		$response = $soapClient->sendCommand ($operation, $params);
		if (isset ($response) && $response['responseParams']->success)
			echo " done.\n";
		else
			echo " ".$soapClient->lastError."\n";
	}
	$dbh->exec ("DELETE FROM ParamsAdd");
	if ($debug) echo "done\n";
}

function addResellerMap ($reseller, $user)
{
	global $dbh;
	$statement = $dbh->prepare ("INSERT INTO ResellerMap (ResellerName, UserName) VALUES (:reseller, :user)");
	if (!$statement)
		var_dump ($dbh->errorInfo());
	$statement->execute (array (':reseller' => $reseller, ':user' => $user));
}

function lookupReseller ($userList)
{
	global $dbh, $defaultDomain;
	$string = implode ("', '", $userList);
	$statement = $dbh->prepare ("SELECT DISTINCT ResellerName FROM ResellerMap WHERE UserName IN ('$string') " .
		"AND ResellerName != '$defaultDomain'");
	$statement->execute ();
	
	if ($reseller = $statement->fetch())
		return $reseller['ResellerName'];
	// else
	return $defaultDomain;
}

function lookupMainUser ($userList)
{
	global $dbh, $defaultDomain;
	$string = implode ("', '", $userList);
	$statement = $dbh->prepare ("SELECT DISTINCT UserName FROM ResellerMap WHERE UserName IN ('$string')");
	$statement->execute ();

	if ($admins = $statement->fetchAll(constant ("PDO::FETCH_COLUMN"))) { //stupid php 4
		$return = array_diff ($userList, $admins);
		if (count ($return) > 0) {
			list ($key) = array_keys ($return);
			return $return[$key]; // return first non-admin
		}
	}

	// no non-admins present, so try if it is a reseller (other than ieinternet)
	$statement = $dbh->prepare ("SELECT UserName FROM ResellerMap WHERE UserName IN ('$string') AND ResellerName != '$defaultDomain'");
	$statement->execute ();

	if ($user = $statement->fetch())
		return $user['UserName'];
	// else return first, which as we have calculated will be a member of ieinternet staff.
		return $userList[0];
}


function processLDAPChildren ($base, $incremental = false, $listFilter = null)
{
	global $ldapHandle, $debug, $resellerMap, $path, $treeStage;
	
	if (isset ($listFilter))
		$filters = array ($listFilter);
	else
		$filters = array (
			"(objectClass=ldapDomain)(domainRole=Reseller)",
			"(objectClass=sendmailMTAMap)",
			"(objectClass=ldapDomain)",
			"(objectClass=ldapDomain)(domainRole=Reseller)",
		);

	foreach ($filters as $filter) {
		if (! isset ($listFilter))
			$treeStage++;
		if ($incremental)
			$searchFilter = "(&$filter(modifyTimestamp>=20080730100000Z))";
		else
			$searchFilter = "(&$filter)";
			
		#if ($debug) echo "Retrieving children of $base with $searchFilter ... ";
		$searchResult = ldap_search ($ldapHandle, $base, $searchFilter);
		#if ($debug) echo "done\n";
			
		for ($entryID = ldap_first_entry ($ldapHandle, $searchResult);
			$entryID != false; 
			$entryID = ldap_next_entry ($ldapHandle, $entryID)) {
			if ($entryID == false)
				break;
			$dn = ldap_get_dn($ldapHandle, $entryID);
			#if ($debug) echo "got $dn\n";
			$attrs = ldap_get_attributes ($ldapHandle, $entryID);
			if (attrCmp ($attrs, "objectClass", "posixAccount")) {
				$userName = attrGetOne ($attrs, "cn");
				$userNameShort = $userName;
				if ($treeStage == 1)
					addResellerMap ($path[1], $userName);
				if (preg_match ('/cn=([^,]+)/', $dn, $matches))
					$userName .= "@".$matches[1];
				$path[2] = $userName;
				if ($treeStage == 3) { // reseller and domain are parents
					foreach (attrGetArray ($attrs, "mail") as $email) {
						$path[3] = $email;
						if (!preg_match ('/^@/', $email))
							processEmail ($email);
						array_pop ($path);
					}
					processUser ($userName);
					$gid = attrGetOne ($attrs, "gidNumber");
					$status = "Unknown";
					if ($gid == 65534)
						$status = "Active";
					elseif ($gid == 66666)
						$status = "Locked";
					processParam ($userNameShort, 4, "Status", $status, $userName);
				}
				array_pop ($path);
				//echo "$dn is a user\n";
			} elseif (attrCmp ($attrs, "objectClass", "ldapDomain")) {
				$domainName = attrGetOne ($attrs, "cn");
				$domainRole = attrGetOne ($attrs, "domainRole");
				if ($treeStage == 3)
					$path[0] = lookupReseller(attrGetArray ($attrs, "memberUid"));

				$path[1] = $domainName;
				
				if ($treeStage < 4)
					processLDAPChildren($dn, $incremental, "(objectClass=posixAccount)");
				if ($treeStage == 3) {
					processDomain ($domainName);
					processParam ($domainName, 3, "MainUser", lookupMainUser(attrGetArray($attrs, "memberUid")));
					processParam ($domainName, 3, "VHost", attrGetOne($attrs, "mailServer"));
					processParam ($domainName, 3, "HostingPlan", attrGetOne($attrs, "hostingPlan"));
					processParam ($domainName, 3, "Status", attrGetOne($attrs, "domainStatus"));
				} elseif ($treeStage == 4)
					processReseller ($domainName);
				array_pop ($path);
				if ($treeStage == 3)
					array_pop ($path);
				
				//echo "$dn is a domain\n";
			} elseif (attrCmp ($attrs, "objectClass", "posixGroup")) {
				echo "$dn is a group\n";
				//;
			} elseif (attrCmp ($attrs, "objectClass", "organizationalUnit")) {
				//echo "$dn is an organisational unit\n";
				;
			} elseif (attrCmp ($attrs, "objectClass", "sendmailMTAMap")) {
				//echo "$dn is a forward\n";
				// Peter: this is broken so I'm disabling it
				#$forwardName = attrGetOne ($attrs, "sendmailMTAKey");
				#$forwardTo = attrGetOne ($attrs, "sendmailMTAMapValue");
				#if (preg_match ('/@/', $forwardName))
					#processForward ($forwardName, $forwardTo);
			} else {
				echo "$dn is unknown\n";
				#var_dump ($attrs['objectClass']);
			}
		}
	}
}

function submitQuota ()
{
	global $params, $soapClient, $debug;
	$operation = "setVHostUpdateQuota";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success) {
		if ($debug)
			echo "Done.\n";
	} else {
		echo "Problem submitting quota.\n";
		echo $soapClient->lastError."\n";
	}
	$params['data'] = array ();
}

function genericRequest ($operation, $args)
{
	global $params, $soapClient, $debug;
	foreach ($args as $arg) {
		$part = explode ("=", $arg);
		if (count ($part) == 2) {
			if (preg_match ('/,/', $part[1])) {
				$params[$part[0]] = explode (",", $part[1]);
				if (end($params[$part[0]]) == "") // if string ends with ",", skip last element which is empty
					($params[$part[0]]);
				
			} else
				$params[$part[0]] = $part[1];
		}
	}
	$response = $soapClient->sendCommand ($operation, $params);
	#if ($response && $response['responseParams']->success) {
	if ($response) {
		if ($debug)
			echo "Done.\n";
		foreach ($response['paramInfo'] as $paramName => $paramType) {
			if (!(property_exists ($response['responseParams'], $paramName) && 
				is_object($response['responseParams']->$paramName)
				))
				continue;
			$obj = $response['responseParams']->$paramName;
			if (property_exists ($obj, "name") && $obj->name != "")
				print $obj->name;
			else
				print $paramName;
			print "=";
			switch ($paramType) {
				case "formSlider":
				case "formText":
				case "formBar":
					print $obj->value;
					break;
				case "formArticle":
					print $obj->body;
					break;
				case "formSelect":
					if (!array_key_exists ("item", $obj->items))
						$array = $obj->items;
					elseif (!is_array ($obj->items->item))
						$array = array ($obj->items->item);
					else
						$array = $obj->items->item;
					foreach ($array as $item)
						if ($item->selected != false && $item->selected !== "false") {
							print $item->value;
							break;
						}
					break;
				case "formDomainEmailList":
					if (!property_exists ($obj->domainEmailList, "item"))
						$array = $obj->domainEmailList;
					elseif (!is_array ($obj->domainEmailList->item))
						$array = array ($obj->domainEmailList->item);
					else
						$array = $obj->domainEmailList->item;
					$found = false;
					foreach ($array as $item) {
						if ($found)
							print ",";
						print $item;
						$found = true;
					}
					break;
				default:
					print "$paramType";
					break;
			}
			print "\n";
		}
	} else {
		echo "Problem executing command \"$operation\"\n";
		echo $soapClient->lastError."\n";
	}
}

function quotaSync ()
{
	global $params;
	$lines = explode ("\n", `/usr/sbin/repquota -a`);
	$params['data'] = array ();
	foreach ($lines as $line) {
		if (preg_match ('/^(\S+)\s+--\s+(\d+)/', $line, $matches) &&
			!preg_match ('/^#\d+$/', $matches[1])) // ignore missing usernames
			$params['data'][] = array ($matches[1], $matches[2]);
		if (count ($params['data']) >= 50) // can't handle large amounts of data :-(
			submitQuota();
	}
	if (count ($params['data']) > 0) // flush
		submitQuota();
}

function addParam ($scope, $paramName, $paramValue)
{
	global $params, $soapClient;
	$params['scope'] = $scope;
	$params['paramName'] = $paramName;
	$params['paramValue'] = $paramValue;
	$operation = "setVHostAddParam";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function delParam ($scope, $paramName)
{
	global $params, $soapClient;
	$params['scope'] = $scope;
	$params['paramName'] = $paramName;
	$operation = "setVHostDelParam";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function addChild ($scope, $child)
{
	global $params, $soapClient;
	$params['scope'] = $scope;
	list ($params['childType'], $params['childName']) = explode (":", $child);
	$operation = "setVHostAddChild";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function addFullHost ($domain, $userName, $password, $hostingPlan, $reseller = "ieinternet.ie")
{
	global $params, $hostname, $soapClient;
	$params['scope'] = "reseller:$reseller";
	$params['childDomain'] = $domain;
	$params['hosting'] = $hostingPlan;
	$params['vHost'] = $hostname;
	$params['childUserDefault'] = $userName;
	$params['childUserEmail'] = "";
	$params['password'] = $password;
	$params['pwd1'] = '';
	$params['pwd2'] = '';
	$operation = "setAddDomain";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function addUser ($domain, $password, $email = "")
{
	global $params, $hostname, $soapClient;
	$params['scope'] = "domain:$domain";
	$params['password'] = $password;
	$params['childEmail'] = $email;
	$operation = "setAddChildDomain";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function addForward ($source, $target)
{
	global $params, $hostname, $soapClient;
	list ($emailPart, $domain) = explode ("@", $source);
	$params['scope'] = "domain:$domain";
	$params['childName'] = $emailPart;
	$params['forward'] = $target;
	$operation = "setAddForward";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function setPassword ($user, $password)
{
	global $params, $hostname, $soapClient;
	$params['scope'] = "user:$user";
	$params['pwd'] = $password;
	$operation = "setPassword";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response && $response['responseParams']->success)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
	}
}

function importForwards ($fileName = "/etc/mail/virtusertable")
// also imports multi drop settings
{
	global $params, $hostname, $soapClient;
	$lines = file_read ($fileName, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
	foreach ($lines as $line) {
		$line = preg_replace ('/(\s)+/', '$1', $line); # trim whitespace
		$line = preg_replace ('/#.*/', '', $line); # ignore comments
		if (preg_match ('/(\S+@\S+)\s+(\S+@\S+)/', $line, $matches)) {
			# this is a forward
			
			if (!validateVHost ($matches[1]))
				continue; // only domains belonging to vhost
			$params['scope'] = "forward:".$matches[1];
			$operation = "getForwardTo";
			$response = $soapClient->sendCommand ($operation, $params);
			if ($response && $response['responseParams']->forwardTo) {
				if ($response['responseParams']->forwardTo->value != $matches[2]) {
					echo "Will redirect {$matches[1]} -> {$matches[2]} ... ";
					$operation = "setForwardTo";
					$params['forwardTo'] = $matches[2];
					$response = $soapClient->sendCommand ($operation, $params);
					if ($response && $response['responseParams']->success)
						echo "ok.\n";
					else
						echo $soapClient->lastError."\n";
				}	
			} else {
				echo "Will add {$matches[1]} -> {$matches[2]} ... ";
				addForward ($matches[1], $matches[2]);
			}
		} else if (preg_match ('/^\s*@(\S+)\s+(\S+@\S+)/', $line, $matches)) {
			# multi drop to email

			if (!validateVHost ($matches[1]))
				continue; // only domains belonging to vhost
			$params['scope'] = "domain:".$matches[1];
			$operation = "getMultiDrop";
			$response = $soapClient->sendCommand ($operation, $params);

			$operation = "setMultiDrop";
			$params['multiDrop'] = "email";
			$params['multiDropTarget'] = $matches[2];

			if ($response && $response['responseParams']->multiDrop) {
				$value = getSelectValue ($response['responseParams']->multiDrop);
				if ($value != "email" ||
					$response['responseParams']->multiDropTarget->value != $matches[2]) {
					$response = $soapClient->sendCommand ($operation, $params);
					if ($response && $response['responseParams']->success)
						echo "Set multi drop for $matches[1] to $matches[2].\n";
					else
						echo $soapClient->lastError."\n";
				}
			} else {
				$response = $soapClient->sendCommand ($operation, $params);
				if ($response && $response['responseParams']->success)
					echo "Set multi drop for $matches[1] to $matches[2].\n";
				else
					echo $soapClient->lastError."\n";
			}
		} else if (preg_match ('/^\s*@(\S+)\s+(\S+)/', $line, $matches)) {
			# multi drop to main user

			if (!validateVHost ($matches[1]))
				continue; // only domains belonging to vhost
			$params['scope'] = "domain:".$matches[1];
			$operation = "getMultiDrop";
			$response = $soapClient->sendCommand ($operation, $params);

			$operation = "setMultiDrop";
			$params['multiDrop'] = "mainuser";
			$params['multiDropTarget'] = "";

			if ($response && $response['responseParams']->multiDrop) {
				$value = getSelectValue ($response['responseParams']->multiDrop);
				if ($value != "mainuser") {
					$response = $soapClient->sendCommand ($operation, $params);
					if ($response && $response['responseParams']->success)
						echo "Set multi drop for $matches[1] to main user.\n";
					else
						echo $soapClient->lastError."\n";
				}
			} else {
				$response = $soapClient->sendCommand ($operation, $params);
				if ($response && $response['responseParams']->success)
					echo "Set multi drop for $matches[1] to main user.\n";
				else
					echo $soapClient->lastError."\n";
			}
		}
	}
}

function importWhiteLists ()
{
	global $params, $hostname, $soapClient;
	$basePath = "/etc/MailScanner/spam.bydomain/whitelist/";
	
	$domains = array ();
	
	if (is_dir($basePath)) {
		if ($dh = opendir($basePath)) {
			while (($file = readdir($dh)) !== false) {
				if (! is_file ($basePath.$file))
					continue;
				$domains[$file] = file_read ($basePath.$file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
			}
			closedir($dh);
		}
	}
	
	foreach ($domains as $domainName => $whitelist) {
		if ($domainName == "default") // skip default
			continue;
			
		if (!validateVHost ($domainName))
			continue; // only domains belonging to vhost
			
		$params['scope'] = "domain:".$domainName;
		// exclude default whitelist
		$whitelist = array_diff ($whitelist, $domains['default']);
		$parsed = array ();
		foreach ($whitelist as $entry) {
			if (preg_match('/^\*@(\S+)/', $entry, $matches))
				$entry = $matches[1]; // convert to SA format
			$parsed[] = $entry;
		}
		$params['whitelist'] =  $parsed;
		$operation = "setWhiteList";
		$response = $soapClient->sendCommand ($operation, $params);

		if ($response && $response['responseParams']->success)
			echo "Imported whitelist for domain $domainName.\n";
		else
			echo "Trouble importing whitelist for domain $domainName: ".$soapClient->lastError."\n";
	}
}

function importSMTPForwarding ($fileName = "/etc/mail/mailertable")
{
	global $params, $hostname, $soapClient;
	
	$operation = "setVHostAddParam";
	
	$lines = file_read ($fileName, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
	
	foreach ($lines as $line) {
		if (! preg_match ('/^\s*(\S+)\s+smtp:\[(\S+)\]/', $line, $matches))
			continue;
		$domain = $matches[1];
		if (!validateVHost ($domain))
			continue; // only domains belonging to vhost
		$params['scope'] = "domain:".$domain;
		$params['paramName'] = "SMTPForward";
		$params['paramValue'] = "Yes";
		$response = $soapClient->sendCommand ($operation, $params);
		if ($response && $response['responseParams']->success)
			echo "SMTP forwarding for domain $domain turned on.\n";
		else
			echo "Trouble setting SMTP forwarding status for domain $domain :".$soapClient->lastError."\n";

		$params['paramName'] = "SMTPForwardIP";
		$targets = implode (",", explode ("]:[", $matches[2]));
		$params['paramValue'] = $targets;
		$response = $soapClient->sendCommand ($operation, $params);
		if ($response && $response['responseParams']->success)
			echo "SMTP forwarding for domain $domain directed to $targets.\n";
		else
			echo "Trouble setting SMTP forwarding target for domain $domain :".$soapClient->lastError."\n";
	}
}

function importVacations ()
{
	global $params, $hostname, $soapClient;
	$basePath = "/var/customers/";
	
	$domains = array ();
	
	if (is_dir($basePath)) {
		if (! $dh = opendir($basePath))
			continue;
		while (($domainDir = readdir($dh)) !== false) {
			$domainDir = $basePath.$domainDir."/homes/";
			if (! is_dir ($domainDir))
				continue;
			if (! $dh2 = opendir($domainDir))
				continue;
			while (($user = readdir ($dh2)) !== false) {
				if (strlen ($user) < 3)
					continue;
				$vacationStatus = "No";
				if (file_exists ($domainDir.$user."/.forward"))
					foreach (file_read ($domainDir.$user."/.forward") as $forwardLine)
						if (preg_match ('/vacation/', $forwardLine))
							$vacationStatus = "Yes";
							
				if ($vacationStatus == "No")
					continue;
					
				$vacationText = "";
				if (file_exists ($domainDir.$user."/.vacation.msg"))
					foreach (file_read ($domainDir.$user."/.vacation.msg") as $msgLine) {
						if ($vacationText != "" || ! preg_match ('/^((\S+\s*:.*)|(\s*))$/', $msgLine))
							$vacationText .= $msgLine;
					}
				
				$pwEntry = posix_getpwnam ($user);
				if (!$pwEntry['gecos']) {
					logger (LOG_INFO, "Cannot determine domain for $user.");
					continue;
				}
				
				if (!validateVHost ($pwEntry['gecos']))
					continue; // only domains belonging to vhost
			
				$operation = "setVHostAddParam";
				$params['scope'] = "user:".$user."@".$pwEntry['gecos'];
				$params['paramName'] = 'VacationStatus';
				$params['paramValue'] = $vacationStatus;
				$response = $soapClient->sendCommand ($operation, $params);
				if ($response && $response['responseParams']->success)
					echo "Vacation status for $user set to $vacationStatus.\n";
				else
					echo "Trouble setting vacation status for $user: ".$soapClient->lastError."\n";
				
				$params['paramName'] = 'VacationText';
				$params['paramValue'] = $vacationText;
				$response = $soapClient->sendCommand ($operation, $params);
				if ($response && $response['responseParams']->success)
					echo "Vacation text for $user set to $vacationText.\n";
				else
					echo "Trouble setting vacation text for $user: ".$soapClient->lastError."\n";
			}
			closedir ($dh2);
		}
		closedir($dh);
	}
}

function createSpamTraps ($vHost = null)
{
	global $dbh, $params, $hostname, $soapClient, $debug, $spamAssassinDB;
	if ($debug) echo "Processing createSpamTraps... stage 1 (create users)\n";
	// find all domains that do not have a spamtrap
	if (! $stmt = $dbh->prepare ("SELECT DISTINCT Name FROM Elems AS Domain WHERE ScopeID = 3 AND NOT EXISTS " .
		"(SELECT * FROM Elems AS Email WHERE Email.ScopeID = 5 AND " .
		"SUBSTR(Email.ElemID,1,LENGTH(Email.ElemID)-20) = Domain.ElemID AND Email.Name = 'spamtrap')")) {
		echo "Problem preparing SELECT FROM Elems\n";
		return;
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM Elems\n";
		return;
	}
	
	foreach ($stmt->fetchAll() as $row) {
		$domainName = $row['Name'];
		if (! $stmt2 = $dbh->prepare ("SELECT ParamName, ParamValue FROM Elems, Params WHERE Elems.Name = :domainName AND " .
			"Elems.ScopeID = 3 AND ".
			"Elems.ElemID = Params.ElemID AND Params.ParamName IN ('MainUser','VHost')")) {
			echo "Problem preparing SELECT FROM Elems, Params\n";
			return;
		}
		
		if (! $stmt2->execute (array (':domainName'=> $domainName))) {
			echo "Problem executing SELECT FROM Elems, Params\n";
			return;
		}
		
		$mainUser = $domainOn = null;
		while ($row = $stmt2->fetch()) {
			switch ($row['ParamName']) {
				case "VHost":
					$domainOn = $row['ParamValue'];
					break;
				case "MainUser":
					$mainUser = $row['ParamValue'];
					break;
				default:
					break;
			}
		}
		
		if (!$mainUser) {
			echo "No main user for $domainName, skipping\n";
			continue;
		}
		
		if ($vHost && $vHost != $domainOn)
			continue; // skip if we specified a vHost and it differs
		
		$spamUser = "spam".$mainUser;
		
		if (! $stmt2 = $dbh->prepare ("SELECT User.Name AS User FROM Elems AS Domain, Elems AS User WHERE " .
			"Domain.Name = :domainName AND User.Name = :spamUser AND " .
			"Domain.ElemID = SUBSTR(User.ElemID, 1, LENGTH(Domain.ElemID)) AND " .
			"Domain.ScopeID = 3 AND User.ScopeID = 4")) {
			echo "Problem preparing SELECT FROM Elems, Elems\n";
			return;
		}
		
		if (! $stmt2->execute (array (':domainName'=> $domainName, ':spamUser' => $spamUser))) {
			echo "Problem executing SELECT FROM Elems, Elems\n";
			return;
		}

		
		if (! ($row = $stmt2->fetch())) {
			$response = $soapClient->sendCommand ("setAddChild", array (
				'scope' => "domain:".$domainName,
				'childType' => "user",
				'childName' => "$spamUser",
			));
			if ($response && $response['responseParams']->success)
				echo "Added user $spamUser for $domainName.\n";
			else {
				echo "Error adding $spamUser to $domainName: ".$soapClient->lastError."\n";
				continue;
			}
		} 
		
		$response = $soapClient->sendCommand ("setAddChild", array (
			'scope' => "user:".$spamUser."@".$domainName,
			'childType' => "email",
			'childName' => "spamtrap",
		));
		if ($response && $response['responseParams']->success)
			echo "Added email spamtrap@$domainName for $spamUser@$domainName.\n";
		else {
			echo "Error adding spamtrap@$domainName for $spamUser@$domainName ".$soapClient->lastError."\n";
			continue;
		}
	}
	
	if ($debug) echo "done\n";
	if ($debug) echo "Processing createSpamTraps... stage 2 (add SpamAssassin settings)\n";
	
	if (is_array ($spamAssassinDB)) {
		foreach (array ('dsn', 'dbName', 'dbUser', 'dbPass') as $key)
			if (!(array_key_exists ($key, $spamAssassinDB) && isset ($spamAssassinDB[$key]))) {
				echo "SA DB key $key not defined.\n";
				exit (3);
			}
	} else  {
		echo "SpamAssassin DB not defined.\n";
		exit (3);
	}
	$dbhSA = mysqlConnect ($spamAssassinDB['dsn'], $spamAssassinDB['dbName'], 
		$spamAssassinDB['dbUser'], $spamAssassinDB['dbPass']);
		
	if (! $stmt = $dbh->prepare ("SELECT Domain.Name AS Domain, User.Name AS User, Email.Name AS Email FROM " .
			"Elems AS Domain, Elems AS User, Elems AS Email WHERE ".
			"Domain.ScopeID = 3 AND User.ScopeID = 4 AND Email.ScopeID = 5 AND " .
			"SUBSTR(Email.ElemID,1,LENGTH(Domain.ElemID)) = Domain.ElemID AND ".
			"SUBSTR(Email.ElemID,1,LENGTH(User.ElemID)) = User.ElemID AND ".
			"Email.Name = 'spamtrap' "
			)) {
		echo "Problem preparing SELECT FROM Elems\n";
		return;
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM Elems\n";
		return;
	}
	
	foreach ($stmt->fetchAll() as $row) {
		$domainName = $row['Domain'];
		$spamTrap = $row['User'];
		if (! $stmt2 = $dbhSA->prepare ("SELECT prefid, value FROM userpref WHERE " .
				"username = :userName AND preference = 'add_header' AND value LIKE 'spam SpamTrap %'")) {
			echo "Problem with preparing SELECT FROM userpref\n";
			continue;
		}
		if (! $stmt2->execute (array (':userName' => "%$domainName"))) {
			echo "Problem with executing SELECT FROM userpref\n";
			continue;
		}
		if ($row2 = $stmt2->fetch()) {
			if ($row2['value'] != "spam SpamTrap $spamTrap") {
				echo "UPDATE $domainName SpamTrap to $spamTrap\n";
				$dbhSA->query ("UPDATE userpref SET value ='spam SpamTrap $spamTrap' WHERE prefid = ".$row2['prefid']);
			}
		} else {
			echo "INSERT $domainName SpamTrap to $spamTrap\n";
			$dbhSA->query ("INSERT INTO userpref (username, preference, value) " .
				"VALUES ('%$domainName', 'add_header', 'spam SpamTrap $spamTrap')");
		}
	}
	
}

function errorInfo($dbh)
{
	$tmp = $dbh->errorInfo();
	return $tmp[2];
}

function setupDomainAdmins()
{
	global $dbh, $params, $hostname, $soapClient, $debug;
	if ($debug) echo "Processing setupDomainAdmins... contd\n";
	// find all domains that do not have a spamtrap
	if (! $stmt = $dbh->prepare ("SELECT Elems.ElemID, Name, ParamValue AS MainUser FROM Elems, Params WHERE " .
		"ScopeID = 3 AND Params.ElemID = Elems.ElemID AND Params.ParamName = 'MainUser'")) {
		echo "Problem preparing SELECT FROM Elems :".errorInfo($dbh)."\n";
		return;
	}
	if (! $stmt->execute ()) {
		echo "Problem executing SELECT FROM Elems :".errorInfo($dbh)."\n";
		return;
	}
	
	foreach ($stmt->fetchAll() as $row) {
		$domainName = $row['Name'];
		$mainUser = $row['MainUser'];
		$elemID = $row['ElemID'];
		$nextElemID = incElem ($elemID);
		
		if (! $stmt2 = $dbh->prepare ("SELECT Elems.ElemID, TargetID FROM Elems, PermMatrix WHERE " .
			"Elems.ElemID = PermMatrix.ElemID AND Elems.ScopeID = 4 AND Elems.Name = :mainUser AND " .
			"PermMatrix.ElemID BETWEEN :elemID AND :nextElemID AND " .
			"LENGTH(PermMatrix.ElemID) = :length")) {
			echo "Problem preparing SELECT FROM Elems, PermMatrix :".errorInfo($dbh)."\n";
			return;
		}
		
		if (! $stmt2->execute (array (
			':elemID'=> $elemID,
			':nextElemID' => $nextElemID,
			':mainUser' => $mainUser,
			':length' => strlen($elemID) + 10,
			))) {
			echo "Problem executing SELECT FROM PermMatrix :".errorInfo($dbh)."\n";
			return;
		}
		
		
		foreach ($stmt2->fetchAll() as $row2)
			if (strpos ($elemID, $row2['TargetID']) === 0) { // has at least access to the domain
				$stmt2->closeCursor();
				continue 2;
			}
		
		$stmt2->closeCursor();
		echo "Main user $mainUser for $domainName doesn't have SOAP permissions, fixing.\n";
		
		if (! $stmt3 = $dbh->prepare ("INSERT INTO PermMatrix (ElemID, TargetID, ModuleID, PermID) " .
			"SELECT ElemID, :elemID, 1, 5 FROM Elems WHERE Name = :mainUser AND ScopeID = 4 AND " .
			"ElemID BETWEEN :elemID2 AND :nextElemID AND " .
			"LENGTH(ElemID) = :length")) {
			echo "Problem preparing INSERT INTO PermMatrix SELECT FROM Elems :".errorInfo($dbh)."\n";
			return;
		}
		if (! $stmt3->execute (array (
			':elemID'=> $elemID,
			':elemID2'=> $elemID,
			':nextElemID' => $nextElemID,
			':mainUser' => $mainUser,
			':length' => strlen($elemID) + 10,
			))) {
			echo "Problem executing INSERT INTO PermMatrix SELECT FROM Elems :".errorInfo($dbh)."\n";
			return;
		}
		if ($stmt3->rowCount() == 0)
			echo "did not do anything :-(\n";
	}
}

function importSpamHandling()
{
	global $debug, $params, $hostName, $soapClient;
	
	$scanningFile = "/etc/MailScanner/rules/spam/spam.scanning.rules";
	$actionsFile = "/etc/MailScanner/rules/spam/spam.actions.rules";
	
	if ($debug) echo "Processing importSpamHandling ... contd\n";
	
	$actions = array ();
	
	foreach (file_read ($actionsFile) as $line)
		if (preg_match ('/^\s*To:\s+(\S+)\s+forward\s+spam/', $line, $matches)) {
			$actions[$matches[1]] = "spamtrap";
		}
	foreach (file_read ($scanningFile) as $line)
		if (preg_match ('/^\s*(FromOrTo|To):\s+\*@(\S+)\s+no/', $line, $matches)) {
			$actions[$matches[2]] = "nothing";
		}
		
	
	foreach ($actions as $domainName => $action) {
		if (!validateVHost ($domainName))
			continue; // only domains belonging to vhost
			
		$params['scope'] =  "domain:$domainName";
		
		$operation = "getSpamAction";
		$response = $soapClient->sendCommand ($operation, $params);
		$operation = "setSpamAction";
		$params['action'] = $action;
		
		$oldAction = "";
		
		if ($response && isset ($response['responseParams']->action)) {
			$oldAction = getSelectValue ($response['responseParams']->action);
		} else {
			echo "Trouble getting spam action for domain $domainName: ".$soapClient->lastError."\n";
			continue;
		}
		
		if ($action != $oldAction) {
			$response = $soapClient->sendCommand ($operation, $params);
			if ($response && $response['responseParams']->success)
				echo "Set spam action for domain $domainName to $action".($oldAction?" (was $oldAction)":"").".\n";
			else {
				echo "Trouble setting spam action for domain $domainName: ".$soapClient->lastError."\n";
				continue;
			}
		}
	}
	if ($debug) echo "done\n";
}

function importVirusScanning()
{
	global $params, $hostname, $soapClient;
	
	$basePath = "/etc/MailScanner/rules/virus/";
	
	$lines = array ();
	$scanningStatus = array ();
	
	if (is_dir($basePath)) {
		if ($dh = opendir($basePath)) {
			while (($file = readdir($dh)) !== false) {
				if (! is_file ($basePath.$file))
					continue;
				$lines = array_merge ($lines, file_read ($basePath.$file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
			}
			closedir($dh);
		}
	}
	
	foreach ($lines as $line) {
		$line = preg_replace ('/#.*/', '', $line); # ignore comments
		
		if (!preg_match ('/^\s*(FromOrTo|To):\s+\*@(\S+)\s+no/', $line, $matches))
			continue;
			
		if (!validateVHost ($matches[2]))
			continue; // only domains belonging to vhost
			
		$params['scope'] = "domain:".$matches[2];
		$operation = "getVirusScan";
		$response = $soapClient->sendCommand ($operation, $params);

		$operation = "setVirusScan";
		$params['virusScan'] = "No";

		if ($response && $response['responseParams']->virusScan) {
			$oldStatus = getSelectValue ($response['responseParams']->virusScan);
				
			if ($oldStatus == "No")
				continue;
			echo "Setting Virus Scanning for $matches[2] to No ";
			$response = $soapClient->sendCommand ($operation, $params);
			if ($response && $response['responseParams']->success)
				echo "ok.\n";
			else
				echo $soapClient->lastError."\n";
		}
	}
}

function getWhiteList ($scope)
{
	global $params, $hostname, $soapClient;
	$params['scope'] = $scope;
	$operation = "getWhiteList";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response)
		echo implode ("\n", $response['responseParams']->whitelist->domainEmailList->item)."\n";
	else {
		echo $soapClient->lastError."\n";
		return;
	}
}

// Get a list of email addresses associated with a scope
function getScopeEmailAddresses($scope) {
	global $hostname, $soapClient;
	$params['scope'] = $scope;
	$operation = "getScopeChildrenEmails";
	$response = $soapClient->sendCommand ($operation, $params);
  $ret = array ();
	if ($response) {
		$ret = $response['responseParams']->emails->item;
	} else {
		return false;
	}
	if (!is_array($ret))
    $ret = array ($ret);
  return $ret;
}

function getSMTPForward ($scope) {
	global $hostname, $soapClient;
	$params['scope'] = $scope;
	$operation = "getSMTPForward";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response) {
		$responseForwardSel = $responseConfigSel = 'No';
		
		$responseForward = $response['responseParams']->smtpForward;
		$responseConfig = $response['responseParams']->configuredOnly;
		
		// Loop through and do count
		foreach ((count($responseForward->items->item) == 1 ? $responseForward->items : $responseForward->items->item) as $item) {
			if ($item->selected) {
				$responseForwardSel = $item->value;
				break;
			}
		}
		foreach ((count($responseConfig->items->item) == 1 ? $responseConfig->items : $responseConfig->items->item) as $item) {
			if ($item->selected) {
				$responseConfigSel = $item->value;
				break;
			}
		}
		$result = array(
			'smtpForward' => $responseForwardSel,
			'ipAddress' => $response['responseParams']->ipAddress,
			'configuredOnly' => $responseConfigSel,
			
		);
		return $result;
		
	} else {
		echo $soapClient->lastError."\n";
		return false;
	}
}

function status ()
{
	global $params, $hostname, $soapClient;
	$params['scope'] = "domain:ieinternet.ie";
	$operation = "getStatus";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response)
		exit (0);
	elseif ($soapClient->lastErrorCode == "MaintenanceMode")
		exit (1);
	else
		exit (2);
}

function addWhiteList ($scope, $emailOrDomain)
{
	global $params, $hostname, $soapClient;
	$params['scope'] = $scope;
	$params['emailOrDomain'] = $scope;
	$operation = "getSpamAssassin";
	$response = $soapClient->sendCommand ($operation, $params);
	if ($response)
		echo "Done.\n";
	else {
		echo $soapClient->lastError."\n";
		return;
	}
}

function getBaseDir ($domainName)
{
	return "/var/customers/www.$domainName";
}

function modifyFile ($fileName, $filters)
{
	/*
	 * add - add a line, can prevent dupes if the "replace" key is used
	 * modify - modify a line
	 * delete - delete a line
	 * replace - modify or add (if not exists)
	 */
	if (!file_exists ($fileName))
		touch ($fileName);

	$fileSize = filesize ($fileName);
	$freeSpace = disk_free_space (dirname($fileName));
	if ($freeSpace < $fileSize * 3) {
		echo "not enough free space\n";
		return false;
	}
	
	$stat = stat ($fileName);
	
	if (array_key_exists ('action', $filters))
		$filters = array ($filters);
	
	foreach ($filters as $filter)
		switch ($filter['action']) {
			case "add":
				if (array_key_exists ('search', $filter)) {
					$inputHandle = fopen ($fileName, "r");
					while ($line = fgets ($inputHandle))
						if (preg_match ($filter['search'], $line)) {
							echo "duplicate found, skipping\n";
							break 2;
						}
					fclose ($inputHandle);
				}
				
				$inputHandle = fopen ($fileName, "a");
				fwrite ($inputHandle, $filter['replace']."\n");
				fclose ($inputHandle);
				break;
			case "delete":
			case "modify":
			case "replace":
				$modified = false;
				$inputHandle = fopen ($fileName, "r");
				$tmpFile = tempnam (dirname($fileName), basename($fileName));
				chown ($tmpFile, $stat[4]);
				chgrp ($tmpFile, $stat[5]);
				chmod ($tmpFile, $stat[2] & 07777);
				$outputHandle = fopen ($tmpFile, "w");
				while ($line = fgets ($inputHandle)) {
					if (preg_match ($filter['search'], $line))
							if ($filter['action'] == "delete")
								$line = null;
							else if ($filter['action'] == "modify" || $filter['action'] == "replace") {
								if (array_key_exists('search2', $filter))
									$line = preg_replace (
										$filter['search2'],
										array_key_exists('replace2', $filter) ? 
											$filter['replace2'] : 
											"/". $filter['replace'] . "/",
										$line
									);
								else
									$line = $filter['replace']."\n";
								$modified = true;
							}
					if (isset ($line))
						fwrite ($outputHandle, $line);
				}
				fclose ($inputHandle);
				if ($filter['action'] == "replace" && ! $modified)
					fwrite ($outputHandle, $filter['replace']."\n");
				fclose ($outputHandle);
				rename ($tmpFile, $fileName);
				break;
			default:
				echo "unknown action {$filter['action']}\n";
				break;
		}
	return true;
}

function getEmailFromVirtusertable ($userName, $domainName, $array = false)
{
	# extract first Email from virtusertable
	$email = $userName.'@'.$domainName; // default
	$emails = array ();
  $mappings = array ();

	foreach (file ("/etc/mail/virtusertable") as $line) {
		if (preg_match ('/^\s*((\S+)@'.$domainName.')\s+'.$userName.'\s*$/', $line, $matches)) {
			$email = $matches[1];
			if (!$array)
				break;
			$emails[] = $matches[2];
		} elseif (preg_match ('/^\s*((\S+)@'.$domainName.')\s+(\S+_\S+)\s*$/',
$line, $matches)) {
      $mappings[$matches[3]] = array (
        'long' => $matches[1],
        'short' => $matches[2],
      );
    }
	}

  if ((count ($emails) == 0 || $array) && count ($mappings) > 0) {
    foreach (file ("/etc/mail/aliases") as $line) {
		  if (preg_match ('/^\s*(\S+):\s+(\S+,)?'.$userName.'(,\S+)?\s*$/', $line,
$matches) && array_key_exists ($matches[1], $mappings)) {
		    $email = $mappings[$matches[1]]['long'];
		    if (!$array)
			    break;
		    $emails[] = $mappings[$matches[1]]['short'];
      }
    }
  }
	
	if ($array)
		return $emails;
	// else
	return $email;
}

function showHelp ()
{
	echo "mw2cli.php [-c configfile] [-h] operation [param1 param2 ... ]\n";
	echo "configfile     = override config file location\n";
	echo "operation       = perform operation\n";
	echo "-h              = show this help\n";
}

# main
$options = getopt ("c:h");

$operation = null;

$path = array ();
$shift = 0;

$cfgFile = "/usr/local/etc/mw2cli.conf.php";

foreach ($options as $key => $value) {
	switch ($key) {
		case "c":
			$cfgFile = $value;
			$argv = array_slice ($argv, 2);
			break;
		case "h":
			showHelp ();
			exit;
			break;
	}
}

$operations = array (
	"getChanges", "ldapSync", "ldapSyncIncremental", "quotaSync",
);

$argv = array_slice ($argv, 1);

if (count ($argv) == 0) {
	echo "No operation specified.\n";
	exit (1);
}

$operation = $argv[0];

$conf = array ('port' => 389, 'base' => null, 'host' => "localhost"); # default value
parseLdapConf ();
require_once ($cfgFile); // allow this one to override ldap.conf

if (!isset ($wsdlLocation) ||
	!isset ($namespace) ||
	!isset ($soapUser) ||
	!isset ($soapPass) ||
	!isset ($emailUser) ||
	!isset ($emailPass)
) {
	echo "Required parameter(s) missing from config file.";
	exit (1);
}

$soapClient = new MWSoapClient ($wsdlLocation, $namespace, $soapUser, $soapPass, $emailUser, $emailPass);

$localhostnames = file_read ("/etc/mail/local-host-names", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if (count($localhostnames) > 0)
  $hostname = $localhostnames[0];

if (!isset ($hostname))
	if (array_key_exists ("SERVER_NAME", $_SERVER))
		$hostname = $_SERVER['SERVER_NAME'];
	else
		$hostname = php_uname("n");
	
$params = array ();
$smtpForwards = array ();
$params ['scope'] = "vhost:".$hostname;
$treeStage = 0;

$debug = posix_isatty(1);

if ($operation == "syncAd") {
	$operation = "getSyncAdQueue";
	if ($debug)
		echo "Requesting list of AD Servers to be synced...\n";
	$response = $soapClient->sendCommand ($operation, $params);
	
	if($debug && $soapClient->lastError)
		echo $soapClient->lastError . "\n";
	if($debug && $SYNC_AD_DRY_MODE)
		echo "DRY MODE ENGAGED, NO DB MODIFICATIONS WILL BE MADE\n";

	// Check that we have a repsonse
	if ($response) {
		$rows = array();
		if (property_exists ($response['responseParams'], "row")) { // PHP4
			$rows = $response['responseParams']->row;
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (is_array ($response['responseParams'])) { // PHP4 in other cases
			$rows = $response['responseParams'];
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (property_exists ($response['responseParams'], "queue"))
			if (property_exists ($response['responseParams']->queue, "row"))
				$rows = $response['responseParams']->queue->row;
	}
	
	// if we have results, then process
	if ($response && count ($rows) > 0) {
		foreach ($rows as $obj) {
			$adds = $dels = array();
			if (is_object ($obj))
				$item = $obj->item;
			else
				$item = $obj;
			if ($debug)
				echo "Syncing with AD Server:$item[1] for Scope:$item[0] \n";
			// switch strings for booleans
			$item[6] = ('Y' == $item[6]) ? true : false;
			$item[7] = ('Y' == $item[7]) ? true : false;
			$ad = new AdSync($item[1],$item[2],$item[3],$item[4],$item[5],$item[6],$item[7]);
			// if we don't get a connection, continue through next server
			if (!$ad->connect())
				continue;
			if(!$result=$ad->searchAddresses(substr($item[0],strpos($item[0],':')+1)))
				continue;
				
			// Be polite, disconnect cleanly
			$ad->disconnect();
			unset($ad);
			
			// Get current email addresses
			$emailAddresses = getScopeEmailAddresses($item[0]);
			// get a list of differences to add and remove
			$emailAdditions = array_diff($result,$emailAddresses);
			$emailDeletions = array_diff($emailAddresses,$result);
			// Sort re-index arrays properly
			sort($emailAdditions);
			sort($emailDeletions);
			$numAdds = sizeof($emailAdditions);
			$numDels = sizeof($emailDeletions);
			
			// Get Main User
			$response = $soapClient->sendCommand ('getMainUser', array('scope' => $item[0]));
			// If we've no main user then we can't do any additions
			if (!$response||
				!isset($response['responseParams'])||
				!property_exists($response['responseParams'],'mainUser')
			) continue;

			$users = $response['responseParams']->mainUser->items->item;
			$mainUser = false;
			if (!is_array ($users))
				$users = array ($users);
			$numUsers = sizeof($users);
			for ($i=0;$i<$numUsers;$i++) {
				if ($users[$i]->selected == true) {
					$mainUser = $users[$i]->value;
					break;
				}
			}
			// Default to first user in the list
			if (!$mainUser)
				$mainUser = $users[0]->value;
			
				if ($debug)
					echo "Main user retrieved as : $mainUser\n";
					
			// Process Adds
			if ($numAdds) {
				$operation = 'setAddChild';
				for ($i=0;$i<$numAdds;$i++) {
					$paramsNew = array('scope' => $mainUser,'childType'=>'email','childName' => "$emailAdditions[$i]");
					
					if ($debug)
						echo "Processing addition : {$emailAdditions[$i]}\n";					
					if(!$SYNC_AD_DRY_MODE)
						$response = $soapClient->sendCommand ($operation, $paramsNew);
						
					if ($response && isset($response['responseParams'])) {
						if (property_exists($response['responseParams'],'success')
						&& true == $response['responseParams']->success) {
							if ($debug)
								echo "{$emailAdditions[$i]} added successfully\n";
							$adds[] = $emailAdditions[$i];
						} else {
							if ($debug)
								echo "Failed to add {$emailAdditions[$i]}\n";
						}
					} else {
						if ($debug)
							echo "Failed to add {$emailAdditions[$i]}, unknown outcome\n";
					}
				}
			} else {
				if ($debug)
					echo "No additions to process.\n";
			}
			
			// Process Deletions
			if ($numDels) {
				$operation = "setDelChild";
				for ($i=0;$i<$numDels;$i++) {
					// Skip iteration if this is a system type address
					if (strpos(strtolower($emailDeletions[$i]),'spamtrap@')===0 ||
						strpos(strtolower($emailDeletions[$i]),'abuse@')===0 ||
						strpos(strtolower($emailDeletions[$i]),'postmaster@')===0
					) continue;
					$paramsNew = array('scope' => $item[0],'childName' => "email:$emailDeletions[$i]");
					
					if ($debug)
						echo "Processing deletion : {$emailDeletions[$i]}\n";
					if(!$SYNC_AD_DRY_MODE)			
						$response = $soapClient->sendCommand ($operation, $paramsNew);
					
					if ($response && isset($response['responseParams'])) {
						if (property_exists($response['responseParams'],'success')
						&& true == $response['responseParams']->success) {
							if ($debug)
								echo "{$emailDeletions[$i]} deleted successfully\n";
							$dels[] = $emailDeletions[$i];
						} else {
							if ($debug)
								echo "Failed to delete {$emailDeletions[$i]}\n";
						}
					} else {
						if ($debug)
							echo "Failed to delete {$emailDeletions[$i]}, unknown outcome\n";
					}
				}
			} else {
				if ($debug)
					echo "No deletions to process.\n";
			}

		  $params ['scope'] = "vhost:".$hostname;
		  $params['domain'] = $item[0];
		  $params['id'] = $item[8];
		  $params['addArray'] = (count ($adds) > 0 ? $adds : null);
		  $params['delArray'] = (count ($dels) > 0 ? $dels : null);
		  if(!$SYNC_AD_DRY_MODE)
			  $response = $soapClient->sendCommand ("setSyncAdQueue", $params);
			  
		  if ($response['responseParams']->success) {
			  if ($debug)
				  echo "Marked Item {$params['id']} for Scope {$params['scope']} in DB as done.\n";
		  } else {
			  if ($debug)
				  echo "DB update failed.\n";
		  }
		}
	} else {
		if ($debug)
			echo "No list of Active Directory servers pending.\n";
	}
} else if ($operation == "getPolicies") {
	$operation = "getVHostPolicyQueue";
	if ($debug)
		echo "Requesting list of policy changes to be deployed...\n";
	$response = $soapClient->sendCommand ($operation, $params);
	
	$filePath = '/etc/MailScanner/rules/virus';
	$files = array(
		'DangerousHTML'		=> 'dangerous.html.rules',
		'SuspectFiles'		=> 'filename.scanning.rules',
		'ExeFiles'			=> 'filetype.scanning.rules',
		'EncFiles'			=> 'suspect.content.rules',
		'SuspectHTML'		=> 'suspect.html.rules',
		'WebBugs'			=> 'suspect.htmltag.rules',
	);
	
	$rows = array ();
	
	if ($response) {
		if (property_exists ($response['responseParams'], "row")) { // PHP4
			$rows = $response['responseParams']->row;
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (is_array ($response['responseParams'])) { // PHP4 in other cases
			$rows = $response['responseParams'];
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (property_exists ($response['responseParams'], "queue"))
			if (property_exists ($response['responseParams']->queue, "row"))
				$rows = $response['responseParams']->queue->row;
//		if (is_array ($rows) && count ($rows) > 0 && ! is_array ($rows[0]))
	}
	
	if ($response && count ($rows) > 0) {
		foreach ($rows as $obj) {
			if (is_object ($obj))
				$item = $obj->item;
			else
				$item = $obj;
			echo "Deploying $item[7] $item[3] on $item[1] $item[5] -> $item[6] = $item[4]\n";

			if (!isset($files[$item[3]])) {
				if ($debug)
					echo "No File for Type $item[3]\n";
				continue;
			}
			$file = "$filePath/{$files[$item[3]]}";

			// Construct rule parts
			$ruleControl = ($item[5]) ? 'From' : 'To';
			$ruleFrom = (strpos($item[5],'@')) ? $item[5] : ((strlen($item[5])) ? "*@$item[5]" : '');
			$ruleTo = (strpos($item[6],'@')) ? $item[6] : ((strlen($item[6])) ? "*@$item[6]" : '');
			if (($ruleControl=='From') && ($ruleTo)) $ruleTo = "and\tTo:\t$ruleTo"; 
			
			$ruleAction = ('ignore' == $item[4]) ? 'no' :'yes';
			
			// Override rull action for certain files
			switch ($item[3]) {
				case 'SuspectFiles' :
					$ruleAction = ('no' == $ruleAction) ? 
							'/etc/MailScanner/filename.no-rules.conf' :
							'/etc/MailScanner/filename.rules.conf';
					break;
				case  'ExeFiles' : 
					$ruleAction = ('no' == $ruleAction) ? 
							'/etc/MailScanner/filename.no-rules.conf' :
							'/etc/MailScanner/filetype.justvirus.conf';
					break;
				case 'WebBugs' :
					$ruleAction = ('no' == $ruleAction) ? 
							'yes' :
							'disarm';
					break;
				case 'DangerousHTML' :
					$ruleAction = ('no' == $ruleAction) ?
							'yes' :
							'no';
					break;
				case 'EncFiles' :
					$ruleAction = ('no' == $ruleAction) ?
							'yes' :
							'no';
				default:
					break;
			}
			
			$ruleLine = "$ruleControl:\t\t$ruleFrom\t$ruleTo\t\t$ruleAction";

			if ($debug)
				echo "Modifying $file\n";
			// Switch on
			switch ($item[7]) {
				case "PolicyAdd":
					modifyFile ($file, array (
						'action' => "replace",
						'search' => '/^'.$ruleControl.':\s+'.str_replace('*','\*',$ruleFrom).'\s+'.str_replace('*','\*',$ruleTo).'\s+/',
						'replace' => "$ruleLine",
					));
					break;
				case "PolicyChange":
					modifyFile ($file, array (
						'action' => "replace",
						'search' => '/^'.$ruleControl.':\s+'.str_replace('*','\*',$ruleFrom).'\s+'.str_replace('*','\*',$ruleTo).'\s+/',
						'replace' => "$ruleLine",
					));
					break;
				case "PolicyDel":
					modifyFile($file, array (
						'action' => "delete",
						'search' => '/^'.$ruleControl.':\s+'.str_replace('*','\*',$ruleFrom).'\s+'.str_replace('*','\*',$ruleTo).'\s+/',
					));
					break;
				default:
					if ($debug)
						echo "No such Policy : $item[7]\n";
						
					break;
			}
			$params['vHost'] = $hostname;
			$params['id'] = $item[0];
			$response2 = $soapClient->sendCommand ("setVHostPolicyQueue", $params);
			if ($response2['responseParams']->success) {
				if ($debug)
					echo "Marked in DB as done.\n";
			} else {
				if ($debug)
					echo "DB update failed.\n";
			}
		}
	} else {
		if ($debug)
			echo "No list of Active Directory servers pending.\n";
	}
} else if ($operation == "getChanges") {
	$operation = "getVHostQueue";
	if ($debug)
		echo "Requesting list of changes to be deployed...\n";
	$response = $soapClient->sendCommand ($operation, $params);
	
	$rows = array ();
	
	if ($response) {
		if (property_exists ($response['responseParams'], "row")) { // PHP4
			$rows = $response['responseParams']->row;
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (is_array ($response['responseParams'])) { // PHP4 in other cases
			$rows = $response['responseParams'];
			if (count ($rows) > 0 && !is_array ($rows[0])) // if there is only one element 
				$rows = array ($rows);
		} elseif (property_exists ($response['responseParams'], "queue"))
			if (property_exists ($response['responseParams']->queue, "row"))
				$rows = $response['responseParams']->queue->row;
//		if (is_array ($rows) && count ($rows) > 0 && ! is_array ($rows[0]))
	}
	
	if ($response && count ($rows) > 0) {
		foreach ($rows as $obj) {
			if (is_object ($obj))
				$item = $obj->item;
			else
				$item = $obj;
			echo "Deploying $item[5] on $item[1]".
				($item[5] == "ParamChange" ? " $item[3] = $item[4]" : " -> $item[3]")."\n";
			switch ($item[5]) {
				case "ParamChange":
					list ($parentScope, $parentName) = explode (":", $item[1]);
					switch ($item[3]) {
						case "HostingPlan":
							if ($parentScope != "domain")
								continue;
							$userLimit = 1;
							$spaceLimit = 20;
							if (array_key_exists ($item[4], $hostingPlan)) {
								$userLimit = $hostingPlan[$item[4]]['userLimit'];
								$spaceLimit = $hostingPlan[$item[4]]['spaceLimit'];
							}
							modifyFile("/var/customers/domain-data/domains.data", array (
								'action' => "replace",
								'search' => '/^'.$parentName.',/',
								'replace' => $parentName.",". $userLimit.",".$spaceLimit,
							));
							/*
							if ($item[4] == "soho")
								modifyFile ("/etc/MailScanner/rules/spam/spam.scanning.rules",
									array (
										array (
											'action' => "replace",
											'search' => '/@'.$parentName.'\s/',
											'replace' => 'FromOrTo:	*@'.$parentName.'		no',
										),
										array (
											'action' => "delete",
											'search' => '/FromOrTo:\s+default\s/',
										),
										array (
											'action' => "add",
											'replace' => 'FromOrTo:	default		yes',
										),
									)
								);
							else
								modifyFile ("/etc/MailScanner/rules/spam/spam.scanning.rules",
									array (
										array (
											'action' => "delete",
											'search' => '/@'.$parentName.'\s/',
										),
									)
								);
							*/
							break;
						case "FlushInbox":
							if ($parentScope != "user")
								continue;
							list ($userName, $domain) = explode ("@", $parentName);
							$mailbox = "/var/mail/".$userName;
							if (file_exists ($mailbox))
								unlink ($mailbox);
							logger (LOG_INFO, "Emptied mailbox for user $userName");
							break;
						case "ForwardTo":
							if ($parentScope != "forward" && $parentScope != "user")
								continue;
							
							$base = $parentName;
							if ($parentScope == "user") {
								list ($base, $domain) = explode ("@", $parentName);
							} else {
								list (,$domain) = explode ("@", $parentName);
							}
							// Get current forward setup
							$forwardSetup = getSMTPForward('domain:'.$domain);
							
							$todo = array (
								'aliases' => array (
									'action' => "replace",
									'source' => $base.":",
									'target' => $item[4],
								),
								'virtusertable' => array (
									'action' => "replace",
									'source' => $base,
									'target' => $item[4],
								)
							);
							
							if ($item[4] == "") // no target -> just delete all
								$todo['aliases']['action'] = 
									$todo['virtusertable']['action'] = 
									"delete";
							
							if ($parentScope == "user") {
								$todo['virtusertable']['action'] = "delete"; // no virtusertable entries for user
								if ($item[4] == $base) // user points to self -> delete all
									$todo['aliases']['action'] = 
										"delete";
							} elseif ($parentScope == "forward") {
								// TODO: avoid possible collisions
								$alias = preg_replace ('/[^a-zA-Z0-9]/', '_', $parentName); // allowable chars
								
								$todo['aliases']['source'] =
									$alias.":";
										
								if (count (explode (',', $item[4])) == 1) // only one entry -> no aliases
									$todo['aliases']['action'] = "delete";
								else
									$todo['virtusertable']['target'] = $alias; // otherwise use aliases
							}
							
							
							foreach ($todo as $file => $action) {
								modifyFile ("/etc/mail/".$file,
									array (
										array (
											'action' => $action['action'],
											'search' => '/^\s*'.$action['source'].'\s+/',
											'replace' => $action['source']."\t\t\t".$action['target'],
										),
									)
								);
								logger (LOG_INFO, "{$action['action']} forwarding ".
									"{$action['source']} -> {$action['target']} in $file");
							}
							// If SMTP Forward, and for configured addresses only, and this is a forward
							if ('Yes' == $forwardSetup['configuredOnly'] && 'Yes' == $forwardSetup['smtpForward'] && 'forward' == $parentScope) {
								modifyFile ("/etc/mail/access", array (
									'action' => "replace",
									'search' => '/^To:'.$parentName.'\s+/',
									'replace' => "To:$parentName\t\t\tRELAY",
								));
								// Add log entry
								logger (LOG_INFO, "Added $parentName to /etc/mail/access");
							}
							break;
						case "SMTPForwardIP":
							if ($parentScope != "domain")
								continue;
							if ($item[4] != "") {
								$targetString = implode ("]:[", explode (",", $item[4]));
								modifyFile ("/etc/mail/mailertable", array (
									'action' => "replace",
									'search' => '/^\s*'.$parentName.'\s/',
									'replace' => "$parentName\t\t\tsmtp:[$targetString]",
								));
								logger (LOG_INFO, "SMTP forwarding for $parentName set to $item[4].");
							}
							break;
						case "SMTPForward":
							if ($parentScope != "domain")
								continue;
							// get forwarding setup
							$forwardSetup = getSMTPForward($item[1]);
							if (!$forwardSetup)
								continue;
							if ('Yes' == $item[4] && 'No' == $forwardSetup['configuredOnly']) {
								modifyFile("/etc/mail/local-host-names", array (
									'action' => "delete",
									'search' => '/^\s*'.$parentName.'\s*$/',
								));
								logger (LOG_INFO, "Deleted $parentName from /etc/mail/local-host-names");
								modifyFile ("/etc/mail/access", array (
									'action' => "replace",
									'search' => '/^To:'.$parentName.'\s+/',
									'replace' => "To:$parentName\t\t\tRELAY",
								));
								logger (LOG_INFO, "Added $parentName to /etc/mail/access");
								modifyFile ("/etc/mail/mailertable", array (
									'action' => "replace",
									'search' => '/^\s*'.$parentName.'\s/',
									'replace' => "$parentName\t\t\tsmtp:[]",
									'search2' => '/^\s*'.$parentName.'\s+smtp:\[(\S+)\]/',
									'replace2' => '/'.$parentName."\t\t\t".'smtp:\[\1\]/',
								));
								logger (LOG_INFO, "Added $parentName to /etc/mail/mailertable");
								logger (LOG_INFO, "SMTP forwarding for $parentName setup.");
							} else if ('No' == $item[4]) {
								modifyFile("/etc/mail/local-host-names", array (
									'action' => "replace",
									'search' => '/^\s*'.$parentName.'\s*$/',
									'replace' => "$parentName",
								));
								logger (LOG_INFO, "Added $parentName to /etc/mail/local-host-names");
								modifyFile ("/etc/mail/access", array (
									'action' => "delete",
									'search' => '/^To:'.$parentName.'\s+/',
								));
								logger (LOG_INFO, "Deleted $parentName from /etc/mail/access");
								modifyFile ("/etc/mail/mailertable", array (
									'action' => "delete",
									'search' => '/^\s*'.$parentName.'\s+/',
								));
								logger (LOG_INFO, "Deleted $parentName from /etc/mail/mailertable");
								logger (LOG_INFO, "SMTP forwarding for $parentName removed.");
							}
							break;
						case "SMTPConfiguredOnly":
							if ($parentScope != "domain")
								continue;
							
							// get forwarding setup
							$forwardSetup = getSMTPForward($item[1]);
							$emailAddresses = getScopeEmailAddresses($item[1]);
							if (!$forwardSetup)
								continue;
								
							if ('Yes' == $item[4] && 'Yes' == $forwardSetup['smtpForward']) {
								modifyFile("/etc/mail/local-host-names", array (
									'action' => "delete",
									'search' => '/^\s*'.$parentName.'\s*$/',
								));
								logger (LOG_INFO, "Deleted $parentName from /etc/mail/local-host-names");
								modifyFile ("/etc/mail/access", array (
									'action' => "delete",
									'search' => '/^To:'.$parentName.'\s+/',
								));
								modifyFile ("/etc/mail/access", array (
									'action' => "delete",
									'search' => '/^To:\S+@'.$parentName.'\s+/',
								));
								logger (LOG_INFO, "Deleted $parentName from /etc/mail/access");
								foreach ($emailAddresses as $addr) {
									modifyFile ("/etc/mail/access", array (
										'action' => "replace",
										'search' => "/^To:$addr\s+/",
										'replace' => "To:$addr\t\t\tRELAY",
									));
								}
								logger (LOG_INFO, "Added $parentName to /etc/mail/access");
								logger (LOG_INFO, "SMTP forwarding for $parentName setup.");								
								
							} else if ('No' == $item[4]) {
								modifyFile ("/etc/mail/access", array (
									'action' => "delete",
									'search' => '/^To:\S+@'.$parentName.'\s+/',
								));
								logger (LOG_INFO, "Deleted $parentName emails from /etc/mail/access");
								// If we are still forwarding then we need to make sure to relay								
								if ('Yes' == $forwardSetup['smtpForward']) {
									modifyFile ("/etc/mail/access", array (
										'action' => "replace",
										'search' => '/^To:'.$parentName.'\s+/',
										'replace' => "To:$parentName\t\t\tRELAY",
									));
									logger (LOG_INFO, "Added $parentName to /etc/mail/access");
								}
							}
							break;
						case "VirusScan":
							if ($parentScope != "domain")
								continue;
							if  ($item[4] == "Yes") {
								foreach (array (
									"virus.scanning.rules", /*"suspect.html.rules", 
									"suspect.htmltag.rules", "dangerous.html.rules",
									"suspect.content.rules",
									"filename.scanning.rules", "filetype.scanning.rules",*/
									) as $file) {
									modifyFile ("/etc/MailScanner/rules/virus/$file",
										array (
											'action' => "delete",
											'search' => '/(@|:?\s+)'.$parentName.'\s/',
										)
									);
									logger (LOG_INFO, "Removed $parentName from $file, which enables this scan type.");
								}
							} else {
								foreach (array ("virus.scanning.rules", /*"suspect.html.rules", 
													"suspect.htmltag.rules", "dangerous.html.rules", 
													"suspect.content.rules"*/) as $file) {
									switch ($file) {
										case "suspect.htmltag.rules":
											$value = "yes";
											break;
										case "suspect.html.rules":
											$value = "yes no";
											break;
										default:
											$value = "no";
											break;
									}
									modifyFile ("/etc/MailScanner/rules/virus/$file",
										array (
											'action' => "replace",
											'search' => '/(@|:?\s+)'.$parentName.'\s/',
											'replace' => 'FromOrTo: '.$parentName.'			'.$value,
										)
									);
									logger (LOG_INFO, "Added $parentName to $file, which disables this scan type.");
								}
								/*foreach (array ("filename.scanning.rules", "filetype.scanning.rules") as $file) {
									modifyFile ("/etc/MailScanner/rules/virus/$file",
										array (
											'action' => "replace",
											'search' => '/(@|:?\s+)'.$parentName.'\s/',
											'replace' => 'FromOrTo: '.$parentName.'			/etc/MailScanner/filename.no-rules.conf',
										)
									);
									logger (LOG_INFO, "Added $parentName to $file, which disables this scan type.");
								}*/
							}
							break;
						case "PolicyNotify":
							if ($parentScope != "domain")
								continue;
							if  ($item[4] == "Yes") {
								modifyFile ("/etc/MailScanner/rules/virus/virus.notifications.rules",
										array (
											'action' => "delete",
											'search' => '/(@|:?\s+)'.$parentName.'\s/',
										)
								);
								logger (LOG_INFO, "Removed $parentName from virus.notifications.rules, which enables virus notifications.");
							} else {
								modifyFile ("/etc/MailScanner/rules/virus/virus.notifications.rules",
										array (
											'action' => "replace",
											'search' => '/(@|:?\s+)'.$parentName.'\s/',
											'replace' => "FromOrTo:\t$parentName\t\t\tno",
										)
								);
								logger (LOG_INFO, "Added $parentName to virus.notifications.rules, which disables virus notifications.");
							}
							break;
						case "MultiDrop":
							if ($parentScope != "domain")
								continue;
							if  ($item[4] == "") {
								modifyFile("/etc/mail/virtusertable", array (
									'action' => "delete",
									'search' => '/^\s*@'.$parentName.'\s+/',
								));
								logger (LOG_INFO, "Deleted multidrop for domain $parentName from /etc/mail/virtusertable.");
							} else {
								list ($scopeType, $scopeName) = explode (":", $item[4]);
								if ($scopeType === "user") {
									list ($scopeName, $domain) = explode ("@", $scopeName);
									modifyFile("/etc/mail/virtusertable", array (
										'action' => "replace",
										'search' => '/^\s*@'.$parentName.'\s+/',
										'replace' => "@".$parentName."\t\t\t".$scopeName,
									));
									logger (LOG_INFO, "Set multidrop for domain $parentName to $scopeName in /etc/mail/virtusertable.");
								} elseif ($scopeType === "email") {
									modifyFile("/etc/mail/virtusertable", array (
										'action' => "replace",
										'search' => '/^\s*@'.$parentName.'\s+/',
										'replace' => "@".$parentName."\t\t\t".$scopeName,
									));
									logger (LOG_INFO, "Set multidrop for domain $parentName to $scopeName in /etc/mail/virtusertable.");
								}
							}
							break;
						case "VacationStatus":
							if ($parentScope != "user")
								continue;
							list ($parentUser, $trash) = explode ("@", $parentName);
							
							$emailString = "";
							foreach (getEmailFromVirtusertable ($parentUser, $trash, true) as $email)
								$emailString .= "-a $email ";
							
							$pwEntry = posix_getpwnam ($parentUser);
							
							$vacFile = $pwEntry['dir']."/.forward";
							if ($item[4] == "Yes") {
								$outputHandle = fopen ($vacFile, "w");
								fwrite ($outputHandle, "\\$parentUser, \"|/usr/bin/vacation $emailString $parentUser\"\n");
								fclose ($outputHandle);
								chown ($vacFile, $parentUser);
								chgrp ($vacFile, "apache");
								chmod ($vacFile, 0600);
								logger (LOG_INFO, "Enabled vacation for user $parentUser");
							} else {
								#unlink ($pwEntry['dir']."/.vacation.msg");
								if (file_exists ($pwEntry['dir']."/.vacation.db"))
									unlink ($pwEntry['dir']."/.vacation.db");
								if (file_exists ($vacFile))
									unlink ($vacFile);
								logger (LOG_INFO, "Disabled vacation for user $parentUser");
							}
							break;
						case "VacationText":
							if ($parentScope != "user")
								continue;
							list ($parentUser, $trash) = explode ("@", $parentName);
							
							$email = getEmailFromVirtusertable ($parentUser, $trash);
							
							$pwEntry = posix_getpwnam ($parentUser);
							$vacFile = $pwEntry['dir']."/.vacation.msg";
							$outputHandle = fopen ($vacFile, "w");
							
							fwrite ($outputHandle, "From: $email\n");
							fwrite ($outputHandle, "Subject: Out of Office\n");
							fwrite ($outputHandle, "Delivered-By-The-Graces-Of: The Vacation Program\n\n");
							fwrite ($outputHandle, $item[4]."\n");
							fclose ($outputHandle);
							chown ($vacFile, $parentUser);
							chgrp ($vacFile, "apache");
							chmod ($vacFile, 0644);
							break;
						case "Status":
							if ($parentScope != "domain")
								continue;
							$baseDir = getBaseDir ($parentName);
							$cancelDir = $baseDir.".CANCELLED";
							$templateDir = "/var/customers/template.cancelled";
							
							if ($item[4] == "Active") {
								if (file_exists ($cancelDir)) {
									if (file_exists ($baseDir))
										system ("rm -rf \"$baseDir\"");
									rename ($cancelDir, $baseDir);
								}
								modifyFile ("/etc/mail/access", array (
									'action' => "replace",
									'search' => '/^To:'.$parentName.'\s+/',
									'replace' => "To:$parentName\t\t\tRELAY",
								));
								logger (LOG_INFO, "Reconnected domain $parentName");
							} elseif ($item[4] == "Suspended") {
								if (file_exists ($baseDir))
									rename ($baseDir, $cancelDir);
								if (file_exists ($templateDir))
									system ("cp -r \"$templateDir\" \"$baseDir\"");
								modifyFile ("/etc/mail/access", array (
									'action' => "replace",
									'search' => '/^To:'.$parentName.'\s+/',
									'replace' => "To:$parentName\t\t\t550 Mailbox disbled.",
								));
								logger (LOG_INFO, "Cancelled domain $parentName");
							}
							break;
            case "ArchiveStatus":
							if ($parentScope != "domain")
								continue;
							if ($item[4] == "1" || $item[4] == "2") {
								modifyFile ("/etc/MailScanner/rules/mail.retention.rules", array (
									'action' => "replace",
									'search' => '/^(From|To|FromOrTo):\s*\*@'.$parentName.'\s+/',
									'replace' => "FromOrTo:\t*@$parentName\t\t\t/var/spool/retention.in",
								));
              } else {
								modifyFile ("/etc/MailScanner/rules/mail.retention.rules", array (
									'action' => "delete",
									'search' => '/^(From|To|FromOrTo):\s*\*@'.$parentName.'\s+/'));
              }
							break;
						default:
							echo "Don't know how to deploy $item[3], skipping\n";
							break;
					}
					break;
				case "ScopeAdd":
					$childScope = "";
					list ($parentScope, $parentName) = explode (":", $item[1]);
					list ($childScope, $childName) = explode (":", $item[3]);
					switch ($childScope) {
						case "email":
							list ($parentUser, $trash) = explode ("@", $parentName);
							$forwardSetup = getSMTPForward('domain:'.$trash);
							modifyFile("/etc/mail/virtusertable", array (
								'action' => "replace",
								'search' => '/^\s*'.$childName.'\s+/',
								'replace' => $childName."\t\t\t".$parentUser
							));
							logger (LOG_INFO, "Added $childName to /etc/mail/virtusertable");
							// If this is SMTP Forwarding with accept filtering on, we need to add to the access file
							if ('Yes' == $forwardSetup['smtpForward'] && 'Yes' == $forwardSetup['configuredOnly']) {
								modifyFile ("/etc/mail/access", array (
									'action' => "replace",
									'search' => "/^To:$childName\s+/",
									'replace' => "To:$childName\t\t\tRELAY",
								));
								logger (LOG_INFO, "Added $childName to /etc/mail/access");
							}
							break;
						case "user":
							list ($childUser, $trash) = explode ("@", $childName);
							$baseDir = getBaseDir ($parentName);
							system ("/usr/sbin/useradd -mk /etc/vpanel-skel -g apache -c \"$parentName\" -d \"$baseDir/homes/$childUser\" -s /bin/false \"$childUser\"");
							chown ("$baseDir/homes/$childUser", $childUser);
							chgrp ("$baseDir/homes/$childUser", "apache");
							chmod ("$baseDir/homes/$childUser", 0750);
							logger (LOG_INFO, "New user $childName created for $parentName");
							break;
						case "domain":
							modifyFile("/var/customers/domain-data/domains.data", array (
								'action' => "replace",
								'search' => '/^'.$childName.',/',
								// will be reset soon afterwards so no worries
								'replace' => $childName.",1,1",
							));
							logger (LOG_INFO, "Added domain $childName to /var/customers/domain-data/domains.data");
							$baseDir = getBaseDir ($childName);
							if (!file_exists ($baseDir)) {
								mkdir ($baseDir, 0755);
								logger (LOG_INFO, "Created directory $baseDir");
							}
							if (!file_exists ($baseDir."/homes")) {
								mkdir ($baseDir."/homes", 0755);
								logger (LOG_INFO, "Created directory $baseDir/homes");
							}
							break;
						case "forward":
							break; // handled by ForwardTo, handling it here makes no sense
						default;
							break;
					}
					break;
				case "ScopeDel":
					$childScope = "";
					list ($childScope, $childName) = explode (":", $item[1]);
					switch ($childScope) {
						case "domain":
							modifyFile("/etc/mail/access", array (
								'action' => "delete",
								'search' => '/^To:'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/access");
							modifyFile("/etc/mail/mailertable", array (
								'action' => "delete",
								'search' => '/^\s*'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/mailertable");
							modifyFile("/etc/mail/local-host-names", array (
								'action' => "delete",
								'search' => '/^\s*'.$childName.'\s*$/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/local-host-names");
							modifyFile("/var/customers/domain-data/domains.data", array (
								'action' => "delete",
								'search' => '/^'.$childName.',/',
							));
							logger (LOG_INFO, "Deleted $childName from /var/customers/domain-data/domains.data");
							$baseDir = getBaseDir ($childName);
							if (file_exists ($baseDir)) {
								system ("rm -rf \"$baseDir\"");
								logger (LOG_INFO, "Deleted $baseDir");
							}
							if (file_exists ($baseDir.".CANCELLED")) {
								system ("rm -rf \"$baseDir.CANCELLED\"");
								logger (LOG_INFO, "Deleted $baseDir.CANCELLED");
							}
							
							// Delete any custom policies
							foreach (array (
									"virus.scanning.rules", "suspect.html.rules", 
									"suspect.htmltag.rules", "dangerous.html.rules",
									"suspect.content.rules",
									"filename.scanning.rules", "filetype.scanning.rules",
									) as $file) {
								$fullFile = "/etc/MailScanner/rules/virus/$file";
								if (file_exists ($fullFile)) {
									modifyFile ($fullFile,
										array (
											'action' => "delete",
											'search' => '/^(FromOrTo|FromAndTo|To):\s+\S+@'.$parentName.'\s+/',
										)
									);
									logger (LOG_INFO, "Removed $parentName from $file, as domain is being deleted scan type.");
								}
							}
							
							break;
						case "forward":
							modifyFile("/etc/mail/virtusertable", array (
								'action' => "delete",
								'search' => '/^\s*'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/virtusertable");
							modifyFile("/etc/mail/access", array (
								'action' => "delete",
								'search' => '/^To:'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/access");
							// Delete any custom policies
							foreach (array (
									"virus.scanning.rules", "suspect.html.rules", 
									"suspect.htmltag.rules", "dangerous.html.rules",
									"suspect.content.rules",
									"filename.scanning.rules", "filetype.scanning.rules",
									) as $file) {
								$fullFile = "/etc/MailScanner/rules/virus/$file";
								if (file_exists ($fullFile)) {
									modifyFile ($fullFile,
										array (
											'action' => "delete",
											'search' => '/^(FromOrTo|FromAndTo|To):\s+'.$childName.'\s+/',
										)
									);
									logger (LOG_INFO, "Removed $parentName from $file, as domain is being deleted scan type.");
								}
							}
							break;
						case "email":
							modifyFile("/etc/mail/virtusertable", array (
								'action' => "delete",
								'search' => '/^\s*'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/virtusertable");
							modifyFile("/etc/mail/access", array (
								'action' => "delete",
								'search' => '/^To:'.$childName.'\s+/',
							));
							logger (LOG_INFO, "Deleted $childName from /etc/mail/access");
							// Delete any custom policies
							foreach (array (
									"virus.scanning.rules", "suspect.html.rules", 
									"suspect.htmltag.rules", "dangerous.html.rules",
									"suspect.content.rules",
									"filename.scanning.rules", "filetype.scanning.rules",
									) as $file) {
								$fullFile = "/etc/MailScanner/rules/virus/$file";
								if (file_exists ($fullFile)) {
									modifyFile ($fullFile,
										array (
											'action' => "delete",
											'search' => '/^(FromOrTo|FromAndTo|To):\s+'.$childName.'\s+/',
										)
									);
									logger (LOG_INFO, "Removed $parentName from $file, as domain is being deleted scan type.");
								}
							}
							break;
						case "user":
							list ($childUser, $trash) = explode ("@", $childName);
							$pwEntry = posix_getpwnam ($childUser);
							if (!$pwEntry) {
								logger (LOG_INFO, "Was told to delete user $childUser but it doesn't exist");
								break;
							}
							if (!$pwEntry['gecos']) {
								logger (LOG_INFO, "Was told to delete user $childUser but it isn't associated with any domain.");
								break;
							}
							if ($pwEntry['uid'] < 100) {
								logger (LOG_INFO, "Was told to delete user $childUser but its UID is lower than 100.");
								break;
							}
							system ("/usr/sbin/userdel -r \"$childUser\"");
							logger (LOG_INFO, "Deleted user $childUser and its home directory");
							if (file_exists ("/var/mail/$childUser")) {
								unlink ("/var/mail/$childUser");
								logger (LOG_INFO, "Deleted $childUser's mail Inbox.");
							}
							break;
						default;
							break;
					}
					break;
				default:
					echo "Do not know how to deploy, skipping\n";
					break;
			}
			
			$params['vHost'] = $hostname;
			$params['id'] = $item[0];
			$response2 = $soapClient->sendCommand ("setVHostQueue", $params);
			if ($response2['responseParams']->success)
				echo "Marked in DB as done.\n";
			else
				echo "DB update failed.\n";
		}
	} elseif ($response) {
		if ($debug)
			echo "No changes pending.\n";
		exit (0);
	} else {
		echo "Error getting change list: ".$soapClient->lastError."\n";
		exit (4);
	}
} elseif ($operation == "ldapSync" || $operation == "ldapSyncIncremental") {
	if (is_array ($mailWallDB)) {
		foreach (array ('dsn', 'dbName', 'dbUser', 'dbPass') as $key)
			if (!(array_key_exists ($key, $mailWallDB) && isset ($mailWallDB[$key]))) {
				echo "MailWall DB key $key not defined.\n";
				exit (3);
			}
	} else  {
		echo "MailWall DB not defined.\n";
		exit (3);
	}
	ldapConnect ();
	$dbh = mysqlConnect ($mailWallDB['dsn'], $mailWallDB['dbName'], 
		$mailWallDB['dbUser'], $mailWallDB['dbPass']);
	$dbh->exec ("SET SQL_LOG_BIN=0");
	if ($operation == "ldapSync")
		createTmpTables ($operation == "ldapSyncIncremental");
	processLDAPChildren ($conf['base'], $operation == "ldapSyncIncremental");
	if ($operation == "ldapSync")
		processDelElemList ();
	processAddElemList();
	if ($operation == "ldapSync")
		processDelParamList ();
	processAddParamList();
	
	$dbh->exec ("SET SQL_LOG_BIN=1");
	syncSoHoSA();
	setupDomainAdmins();
} elseif ($operation == "quotaSync") {
	quotaSync();
	exit;
} elseif ($operation == "addParam") {
	if (count ($argv) >= 4)
		addParam ($argv[1], $argv[2], $argv[3]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "delParam") {
	if (count ($argv) >= 3)
		delParam ($argv[1], $argv[2]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "addChild") {
	if (count ($argv) >= 3)
		addChild ($argv[1], $argv[2]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "addFullHost") {
	if (count ($argv) >= 6)
		addFullHost ($argv[1], $argv[2], $argv[3], $argv[4], $argv[5]);
	elseif (count ($argv) == 5)
		addFullHost ($argv[1], $argv[2], $argv[3], $argv[4]);
	else {
		echo "Required parameter(s) missing, maybe you forgot partner at the end (new functionality).\n";
		exit (2);
	}
} elseif ($operation == "addUser") {
	if (count ($argv) == 3)
		addUser ($argv[1], $argv[2]);
	elseif (count ($argv) >= 4)
		addUser ($argv[1], $argv[2], $argv[3]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "addForward") {
	if (count ($argv) == 3)
		addForward ($argv[1], $argv[2]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "setPassword") {
	if (count ($argv) == 3)
		setPassword ($argv[1], $argv[2]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "addWhiteList") {
	if (count ($argv) == 3)
		addWhiteList ($argv[1], $argv[2]);
	else {
		echo "Required parameter(s) missing.\n";
		exit (2);
	}
} elseif ($operation == "importForwards") {
	if (count ($argv) == 2)
		importForwards ($argv[1]);
	else
		importForwards ();
} elseif ($operation == "importWhitelists") {
	importWhiteLists ();
} elseif ($operation == "importSMTPForwarding") {
	importSMTPForwarding ();
} elseif ($operation == "importSpamHandling") {
	importSpamHandling ();
} elseif ($operation == "importVirusScanning") {
	importVirusScanning ();
} elseif ($operation == "importVacations") {
	importVacations ();
} elseif ($operation == "createSpamTraps") {
	$dbh = mysqlConnect ($mailWallDB['dsn'], $mailWallDB['dbName'], 
		$mailWallDB['dbUser'], $mailWallDB['dbPass']);
	if (count ($argv) == 2)
		createSpamTraps($argv[1]);
	else
		createSpamTraps();
} elseif ($operation == "nagios") {
	status ();
} else {
	array_shift ($argv);
	genericRequest ($operation, $argv);
	#echo "Unknown operation $operation.\n";
	#exit (1);
}

exit (0);
