<?php
/*
 * Created on 9 Sep 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
function file_read ($file, $flags = 0)
{
	return file ($file, $flags);
}

class MWSoapClient extends SoapClient {
	
	private $headers;
	private $namespace;
	
	public $lastError;
	public $lastErrorCode;
		
	public function __construct($wsdlLocation, $namespace, $soapUser, $soapPass, $emailUser, $emailPass)
	{
		// construct the parent client from the wsdl
		parent::__construct($wsdlLocation);
		
		// set up some member vars
		// the mailwall xml namespace
		$this->namespace = $namespace;
		// the soap user and password for the session
		$this->headers['authSoapUser'] = $soapUser;
		$this->headers['authSoapPassword'] = $soapPass;
		// the email and password
		$this->headers['authEmail'] = $emailUser;
		$this->headers['authPassword'] = $emailPass;
		
		// parse the wsdl functions/types/parameterssr
		$this->parseParameterInfo();
	}
	
	public function sendCommand($command, $params = array())
	{
		// construct header
		$requestHeader = new SoapHeader($this->namespace, "requestHeader", $this->headers, false);
		$responseHeader = null;
		
		// construct parameters
		$requestParams[$command] = new StdClass();
		foreach ($params as $paramName => $paramValue) {
			$requestParams[$command]->$paramName = $paramValue;
		}
		try {
			// do the request
			$responseParams = $this->__soapCall($command, $requestParams, null, $requestHeader, $responseHeader);
			
			// return the response headers/parameters
			return array(
				'responseHeaders' => ( 
					array_key_exists ('responseHeader', $responseHeader) ? 
						$responseHeader['responseHeader'] : array()),
				'responseParams' => ($responseParams ? $responseParams : array()),
				'paramInfo' => $this->types[$this->functions[$command]['response']],
			);
		} catch (Exception $e) {
			// set the last error
			if ($e instanceof SoapFault) {
				$this->lastError = "SoapFault({$e->faultcode}): {$e->faultstring}";
				$this->lastErrorCode = $e->faultcode;
				if (property_exists ($e, "detail") && property_exists ($e->detail, "message"))
					$this->lastError = $e->detail->message;
			} else {
				$this->lastError = "Exception(" . get_class($e) . "): " . $e->getMessage();
				$this->lastErrorCode = "Exception";
			}
			return null;
		}
	}
	
	// this function parses the phpsoap wsdl output to gather info on functions, parameters and types
	private function parseParameterInfo()
	{
		// parse functions
		$functions = $this->__getFunctions();
		foreach ($functions as $functionString) {
			// get the function information
			list($functionName, $functionRequest, $functionResponse) = 
				explode(" ", preg_replace('/^(\w+) (\w+)\((\w+) \$\w+\)$/', '$2 $3 $1', $functionString));
			
			// put info in the array
			$this->functions[$functionName] = array('request' => $functionRequest, 'response' => $functionResponse);
		}
		
		// parse types, and so also parse parameters
		$types = $this->__getTypes();
		foreach ($types as $type) {
			// remove carriage returns
			$typeClean = str_replace(array("\n","\r\n"), array(" "," "), $type);
			
			// get the type name
			$typeName = preg_replace('/^\w+ (\w+) \{([\w\W]*) \}$/', '$1', $typeClean);
			$this->types[$typeName] = array();
			
			// get the list of vars in the type
			$typeVars = trim(preg_replace('/^\w+ (\w+) \{([\w\W]*) \}$/', '$2', $typeClean));
			foreach (explode(";", $typeVars) as $var) {
				@list($varName, $varType) = explode(" ", preg_replace('/^(\w+) (\w+)$/', '$2 $1', trim($var)));
				if ($varName && $varType) $this->types[$typeName][$varName] = $varType;
			}
		}
	}
}

?>
