<?php
/*
 * Created on 9 Sep 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
require_once('SOAP/Client.php');

function is_assoc($_array) {
	if (! is_array($_array))
		return false;
		
	foreach ($_array as $key => $var)
		if (! is_numeric ($key))
			return true;
			
	return false;
}

function is_crappy_object ($_obj) {
	if (!is_object ($_obj))
		return false;
		
	foreach ($_obj as $key => $var)
		if (! is_numeric ($var))
			return false;
			
	return true;
}

function obj_to_array ($_obj)
{
	$array = array ();
	foreach ($_obj as $key => $value)
		if (is_object ($value))
			$array[$key] = array_to_obj ($value);
		else
			$array[$key] = $value;
	return $array;
}

function array_to_obj ($_array)
{
	$obj = new StdClass();
	
	if ((is_object ($_array) && is_crappy_object ($_array)) ||
		(is_array ($_array) && ! is_assoc ($_array))) {
		$obj = obj_to_array ($_array);
	} else {
		foreach ($_array as $key => $value) {
			if (is_array($value) || is_object ($value))
				$obj->$key = array_to_obj ($value);
			else {
				$obj->$key = $value;
			}
		}
	}
	return $obj;
}

if (!function_exists ('property_exists')) {
	function property_exists ($class, $property) {
		if (is_object ($class))
			$vars = get_object_vars ($class);
		elseif (is_array ($class))
			$vars = array_keys ($class);
		else
			$vars = get_class_vars ($class);

		if (is_array ($vars))
			return array_key_exists ($property, $vars);
		else
			return false;
	}
}

if (!defined ("FILE_IGNORE_NEW_LINES"))
	define("FILE_IGNORE_NEW_LINES", 2);
if (!defined ("FILE_SKIP_EMPTY_LINES"))
	define("FILE_SKIP_EMPTY_LINES", 4);

function file_read ($file, $flags = 0)
{
	$output = array ();
	foreach (file ($file) as $line) {
		if (($flags & FILE_IGNORE_NEW_LINES) > 0)
			list ($line, $tmp) = explode ("\n", $line);
		if (($flags & FILE_SKIP_EMPTY_LINES) > 0  && preg_match ('/^\s*$/', $line))
			continue;
		$output[] = $line;
	}
	return $output;
}

if (!defined ("DNS_MX"))
	define("DNS_MX", 16384);
function dns_get_record ($string, $type = 0)
{
	list ($mx_records, $mx_weight) = array ("", ""); // get rid of warnings
	$return = array ();
	if ($type == DNS_MX) {
		getmxrr ($string, $mx_records, $mx_weight);
		// Put the records together in a array we can sort
		for($i=0;$i<count($mx_records);$i++)
			$return[] = array (
				'host' => $string,
				'type' => "MX",
				'pri' => $mx_weight[$i],
				'target' => $mx_records[$i],
				'class' => "IN",
				//'ttl' => 6765,
			);
	} else {
		foreach (gethostbynamel ($string) as $record)
			$return[] = array (
				'host' => $string,
				'type' => "A",
				'ip' => $record,
				'class' => "IN",
				//'ttl' => 8125,
			);
	}
	return $return;
}

class MWSoapClient extends SOAP_Client {
	
	var $headers;
	var $namespace;
	
	var $lastError;
	var $lastErrorCode;
		
	// constructor
	function MWSoapClient($wsdlLocation, $namespace, $soapUser, $soapPass, $emailUser, $emailPass)
	{
		// construct the parent client from the wsdl
		parent::SOAP_Client($wsdlLocation, true, false, array (), true);
		
		// set up some member vars
		// the mailwall xml namespace
		$this->namespace = $namespace;
		// the soap user and password for the session
		$this->headers['authSoapUser'] = $soapUser;
		$this->headers['authSoapPassword'] = $soapPass;
		// the email and password
		$this->headers['authEmail'] = $emailUser;
		$this->headers['authPassword'] = $emailPass;
	}
	
	function sendCommand($command, $params = array())
	{
		// construct header
		$requestHeader = new SOAP_Header("{".$this->namespace."}requestHeader", "Struct", $this->headers, 0);
		$responseHeader = null;
		
		$this->addHeader ($requestHeader);
		
		$retval = $this->call($command, $params, array (
			'namespace' => $this->namespace,
			'timeout' => 0,
			//'use' => "literal", // is supposed to help but doesn't
			//'keep_arrays_flat' => false, // neither does this
		));
		
		$service = $this->_wsdl->service;
		$paramStruct = $this->_wsdl->getOperationData($service, $command);
		$paramInfo = array ();
		if (is_array ($paramStruct)) 
			foreach ($paramStruct['output']['parts'] as $part) {
				$paramInfo[$part['name']] = $part['type'];
			}
		
		// undo overzealous xml "optimisation" of SOAP
		if (count ($paramInfo) == 1 && count (get_object_vars($retval)) > 1) {
			list ($varName) = array_keys ($paramInfo);
			$retval = array ($varName => $retval);
		}
		
		$responseParams = array_to_obj ($retval); // convert to PHP5 SOAP style
		
		if (! (is_object ($retval) && method_exists ($retval, "getFault"))) {
			// return the response headers/parameters
			return array(
				'responseParams' => ($responseParams ? $responseParams : array()),
				'paramInfo' => $paramInfo,
			);
		} else {
			// set the last error
			if (method_exists ($retval, "getFault")) {
				$result = $retval->getFault();
				$this->lastError = "SoapFault({$result->faultcode}): {$result->faultstring}";
				$this->lastErrorCode = $result->faultcode;
				if (property_exists ($result, "detail") && property_exists ($result->detail, "message"))
					$this->lastError = $result->detail->message;
			} else {
				$this->lastError = "Exception(unpecified error)";
				$this->lastErrorCode = "Exception";
			}
			return null;
		}
	}
}

?>
