#!/bin/bash

# Script to remove virus scanning for a domain
# Adds domain from following files:
#  AVFILE - virus.scanning.rules
#  FILESCANFILE - filename.scanning.rules
#  CODESCANFILE - filetype.scanning.rules 
#  MESSAGESCANFILE - suspect.scanning.rules

TMPFILE="virus_removal.temp"

RemoveDomain ()
{
        grep -q "*@$DOMAIN" $AVFILE
        CmdOp=$?

        if [ $CmdOp -ne 0 ]
        then
		logger -p local3.info -t vpanel "Removing Anti-Virus Scanning for $DOMAIN ..."

		# Add to virus.scanning.rules
                grep -v "default" $AVFILE > $TMPFILE
                echo -e "FromOrTo:\t*@$DOMAIN\t\t\tno" >> $TMPFILE
                echo -e "FromOrTo:\tdefault\t\t\t\tyes" >> $TMPFILE
                rm -f $AVFILE
                mv $TMPFILE $AVFILE
		logger -p local3.info -t vpanel "Removed virus library scanning for $DOMAIN"

		# Add to filename.scanning.rules 
		grep -v "default" $FILESCANFILE > $TMPFILE
		echo -e "FromOrTo:\t\t*@$DOMAIN\t\t/etc/MailScanner/filename.no-rules.conf" >> $TMPFILE
		echo -e "FromOrTo\t\tdefault\t\t\t/etc/MailScanner/filename.rules.conf" >> $TMPFILE
		rm -f $FILESCANFILE
		mv $TMPFILE $FILESCANFILE
		logger -p local3.info -t vpanel "Removed file name scanning for $DOMAIN"

		# Add to codescan rules file
		grep -v "default" $CODESCANFILE > $TMPFILE
		echo -e "FromOrTo:\t\t*@$DOMAIN\t\t/etc/MailScanner/filetype.no-rules.conf" >> $TMPFILE
		echo -e "FromOrTo:\t\tdefault\t\t/etc/MailScanner/filetype.rules.conf" >> $TMPFILE
		rm -f $CODESCANFILE
		mv $TMPFILE $CODESCANFILE
		logger -p local3.info -t vpanel "Removed file type scanning for $DOMAIN"
		
		# Add to message scan file
		grep -v "default" $MESSAGESCANFILE > $TMPFILE
		echo -e "FromOrTo:\t\t*@$DOMAIN\t\t\tyes" >> $TMPFILE
		echo -e "FromOrTo:\t\tdefault\t\t\tno" >> $TMPFILE				
		rm -f $MESSAGESCANFILE
		mv $TMPFILE $MESSAGESCANFILE
		logger -p local3.info -t vpanel "Removed message scan sacnning for $DOMAIN"

		logger -p local3.info -t vpanel "Removal of Anti-Virus Scanning for $DOMAIN completed"
        else 
		logger -p local3.info -t vpanel "Attempt to disable virus scanning for $DOMAIN - already disabled"
	fi
        return 0
}

#DOMAINS=`cat $REMOVEVIRUSFILE`

for DOMAIN in $@
do
	RemoveDomain
done

#rm -f $REMOVEVIRUSFILE
