#!/bin/bash

# This script will, taking a message reference number and ID, do the following:
# 1. ensure that the email is intended for the domain of the user who requested the release
# 2. check the mail for viruses
# 3. release the mail to the intended recipient if it's found to not contain a virus

# KOD, 10-03-2004
# NMD, 16-03-2004

QUARDIR="/var/spool/MailScanner/quarantine"
OUTBOUNDQUEUEDIR="/var/spool/mqueue"
MAILFAILNOID=$MANDIR"mailrelease.nosuchid.failure"
MAILFAILVIRUS=$MANDIR"mailrelease.hasvirus.failure"
MAILSUCCESSFILE=$MANDIR"mailrelease.success"
TMPEMAIL="/tmp/quarantine_email.tmp"

#########
# Collect email information from list file
#########

declare -a SENDER
declare -a REFERENCE
declare -a ID

FIELD1="`cat $RELEASEEMAILFILE | cut -f1 -d,`"
FIELD2="`cat $RELEASEEMAILFILE | cut -f2 -d,`"
FIELD3="`cat $RELEASEEMAILFILE | cut -f3 -d,`"

let COUNT=1

for FIELD in $FIELD1
do
	RECIPIENT[COUNT]=$FIELD
	COUNT=`expr $COUNT + 1`
done

let COUNT=1
                                                                                                                      
for FIELD in $FIELD2
do
        REFERENCE[COUNT]=$FIELD
        COUNT=`expr $COUNT + 1`
done

let COUNT=1
                                                                                                                      
for FIELD in $FIELD3
do
        ID[COUNT]=$FIELD
        COUNT=`expr $COUNT + 1`
done


#########
# Release email if it exists, does not contain a virus and belongs to the domain of the requesting domain name
#########

let I=0

for ((I=1 ; I<COUNT ; I++))
do
	RELEASEDIR="$QUARDIR/${REFERENCE[I]}/${ID[I]}"
	CONTROLADDRESS="info@${RECIPIENT[I]}"
	SUBJECT="Request to release email [ Reference ${REFERENCE[I]}, ID ${ID[I]} ] from the IE Internet Quarantine"

	if [ -e $RELEASEDIR ]; then
	        TOHEADER="`grep To: $RELEASEDIR/qf${ID[I]} | grep -v "Reply-To"`"
        	TOADDRESS=`echo $TOHEADER | head -1 | cut -f2 -d " "`
		echo $TOHEADER | grep -q ${RECIPIENT[I]}
		CmdOp=$?

		# Prepare email headers
		echo -e "To: $TOADDRESS" > $TMPEMAIL
		echo -e "From: MailWall@ieinternet.com (IE Internet MailWall)" >> $TMPEMAIL
		echo -e "Cc: $CONTROLADDRESS" >> $TMPEMAIL
		echo -e "Reply-To: do-not-reply@ieinternet.com" >> $TMPEMAIL
		echo -e "Subject: $SUBJECT" >> $TMPEMAIL
		echo -e "\n[ This is an automated message - please do not reply ]\n" >> $TMPEMAIL

		if [ $CmdOp -ne 0 ] ; then
			# The requesting domain does not own the email - reject the request, log it and mail customer
			logger -p local3.info -t vpanel "Virus Release: $RELEASEDIR/df${ID[I]} for ${RECIPIENT[I]} failed - not owner"
			mail -s "$SUBJECT" -c "$CONTROLADDRESS" "$TOADDRESS" < $MAILFAILNOID
		else
			/usr/local/bin/f-prot -silent -archive $RELEASEDIR
			RETURNV=$?

			if [ $RETURNV -eq 0 ]; then
			  # No virus - release the email
                          cp $RELEASEDIR/df${ID[I]} $OUTBOUNDQUEUEDIR
                          cp $RELEASEDIR/qf${ID[I]} $OUTBOUNDQUEUEDIR
			  logger -p local3.info -t vpanel "Virus Release: $RELEASEDIR/df${ID[I]} for ${RECIPIENT[I]} released"	
			  cat $MAILSUCCESSFILE >> $TMPEMAIL
			else
			  # Virus - quarantine the email again and email the intended recipient
			  logger -p local3.info -t vpanel "Virus Release: $RELEASEDIR/df${ID[I]} for ${RECIPIENT[I]} failed - virus"
                          cat $MAILFAILVIRUS >> $TMPEMAIL
			fi  
		fi
	else
		# The email does not exist - log it and notify the customer
		logger -p local3.info -t vpanel "Virus Release: $RELEASEDIR/df${ID[I]} for ${RECIPIENT[I]} failed - no such file"
		cat $MAILFAILNOID >> $TMPEMAIL
	fi
	cat $TMPEMAIL | /usr/sbin/sendmail -t -i
done
rm -f $TMPEMAIL
rm -f $RELEASEEMAILFILE
