#!/bin/bash

# This script will, taking a message reference number and ID, do the following:
# 1. ensure that the email is intended for the domain of the user who requested the release
# 2. check the mail for viruses
# 3. release the mail to the intended recipient if it's found to not contain a virus

# KOD, 10-03-2004
# NMD, 16-03-2004, 30-08-2004

MAILFAILNOID=$MANDIR"mailrelease.nosuchid.failure"
MAILFAILVIRUS=$MANDIR"mailrelease.hasvirus.failure"
MAILSUCCESSFILE=$MANDIR"mailrelease.success"

OWNER_MAILFAILNOID=$MANDIR"mailrelease.nosuchid.failure.owner"
OWNER_MAILFAILVIRUS=$MANDIR"mailrelease.hasvirus.failure.owner"
OWNER_MAILSUCCESSFILE=$MANDIR"mailrelease.success.owner"

TMPEMAIL="/tmp/quarantine_email.tmp"
OWNER_TMPEMAIL="/tmp/quarantine_email.owner.tmp"

#########
# Collect email information from list file
#########

declare -a QUARTYPE
declare -a SENDER
declare -a REFERENCE
declare -a ID

FIELD1="`cat $RELEASE_EMAIL_FILE | cut -f1 -d,`"
FIELD2="`cat $RELEASE_EMAIL_FILE | cut -f2 -d,`"
FIELD3="`cat $RELEASE_EMAIL_FILE | cut -f3 -d,`"
FIELD4="`cat $RELEASE_EMAIL_FILE | cut -f4 -d,`"

let COUNT=1

# first element determines if it's a virus or content quarantine release
for FIELD in $FIELD1
do
	QUARTYPE[COUNT]=$FIELD
	COUNT=`expr $COUNT + 1`
done

let COUNT=1

for FIELD in $FIELD2
do
	RECIPIENT[COUNT]=$FIELD
	COUNT=`expr $COUNT + 1`
done

let COUNT=1

for FIELD in $FIELD3
do
REFERENCE[COUNT]=$FIELD
COUNT=`expr $COUNT + 1`
done

let COUNT=1

for FIELD in $FIELD4
do
ID[COUNT]=$FIELD
COUNT=`expr $COUNT + 1`
done


#########
# Release email if it exists, does not contain a virus and belongs to the domain of the requesting domain name
#########

let I=0

for ((I=1 ; I<COUNT ; I++))
do
	ERROR=0
	QUAR_TYPE=${QUARTYPE[I]}
	if [ $QUAR_TYPE == "virus" ]; then
		RELEASEDIR="$QUARDIR${REFERENCE[I]}/${ID[I]}"
	elif [ $QUAR_TYPE == "content" ]; then
		RELEASEDIR="$QUARDIR${REFERENCE[I]}/$CONTENT_QUAR_SUB_DIR"
		# Set the status of the virus scan to 0 as this email has already been scanned for viruses
		VIRUS_RETURNV=0
	else
		# An error has occured - skip to next release request
		logger -p local3.info -t vpanel "Attempt to access quarantine failed: incorrect parameters passed. \
		The parameters passed were -1-$QUAR_TYPE- -2-${RECIPIENT[I]}- -3-${REFERENCE[I]}- -4-${ID[I]}-"
		continue
	fi	
		
	if [ ! -e $RELEASEDIR ]; then
		ERROR=1
		logger -p local3.info -t vpanel "$QUAR_TYPE release: $QUEUE_FILE for ${RECIPIENT[I]} failed - no such directory"
	else
		QUEUE_FILE=$RELEASEDIR/qf${ID[I]}
		DATA_FILE=$RELEASEDIR/df${ID[I]}
		
		# Look for RFC822 address
		TOADDRESS=`grep RFC822 $QUEUE_FILE | head -1 | cut -f2 -d " "`
		echo $TOADDRESS | grep -q ${RECIPIENT[I]}
		RFC_FOUND=$?
		if [ $RFC_FOUND -ne 0 ] ; then
			# no RFC822 address - look for the To address
			TOADDRESS=`grep To: $QUEUE_FILE | grep -v Reply-To | head -1 | cut -f2 -d " "`
			echo $TOADDRESS | grep -q ${RECIPIENT[I]}
			TO_FOUND=$?
			if [ $TO_FOUND -ne 0 ] ; then
				# No/Incorrect "To" address found - log and report the error
				logger -p local3.info -t vpanel "Attempt to access quarantine failed: No/Incorrect To/RFC822 \
				addresses found in $QUEUE_FILE"
				ERROR=1
			fi
		fi
	fi

	# Create email headers
	CONTROLADDRESS="info@${RECIPIENT[I]}"
	SUBJECT="Request to release email [ reference ${REFERENCE[I]}, ID ${ID[I]} ] from the IE Internet $QUAR_TYPE quarantine"
	
	# Create email headers for recipient and owner of domain

		echo -e "To: $TOADDRESS" > $TMPEMAIL
		echo -e "To: $CONTROLADDRESS" > $OWNER_TMPEMAIL

		echo -e "From: MailWall@ieinternet.com (IE Internet MailWall)" >> $TMPEMAIL
		echo -e "From: MailWall@ieinternet.com (IE Internet MailWall)" >> $OWNER_TMPEMAIL

		echo -e "Reply-To: do-not-reply@ieinternet.com" >> $TMPEMAIL
		echo -e "Reply-To: do-not-reply@ieinternet.com" >> $OWNER_TMPEMAIL

		echo -e "Subject: $SUBJECT" >> $TMPEMAIL
		echo -e "Subject: $SUBJECT" >> $OWNER_TMPEMAIL

		echo -e "\n[ This is an automated message - please do not reply ]\n" >> $TMPEMAIL
		echo -e "\n[ This is an automated message - please do not reply ]\n" >> $OWNER_TMPEMAIL

	if [ $ERROR -eq 1 ]; then
		cat $MAILFAILNOID >> $TMPEMAIL
		cat $OWNER_MAILFAILNOID >> $OWNER_TMPEMAIL
	else		
		if [ $QUAR_TYPE == "virus" ]; then
			/usr/local/bin/f-prot -silent -archive $RELEASEDIR
			VIRUS_RETURNV=$?
		fi

		if [ $VIRUS_RETURNV -eq 0 ]; then
			# No virus - release the email
			cp $DATA_FILE $OUTBOUNDQUEUEDIR
			cp $QUEUE_FILE $OUTBOUNDQUEUEDIR
			logger -p local3.info -t vpanel "$QUAR_TYPE release: $QUEUE_FILE for ${RECIPIENT[I]} released"	
			cat $MAILSUCCESSFILE >> $TMPEMAIL
			cat $OWNER_MAILSUCCESSFILE >> $OWNER_TMPEMAIL
		else
			# Virus - quarantine the email again and email the intended recipient
			logger -p local3.info -t vpanel "$QUAR_TYPE release: $QUEUE_FILE for ${RECIPIENT[I]} failed - virus"
			cat $MAILFAILVIRUS >> $TMPEMAIL
			cat $OWNER_MAILFAILVIRUS >> $OWNER_TMPEMAIL
		fi	
	fi
 
	cat $TMPEMAIL | /usr/sbin/sendmail -t -i
	cat $OWNER_TMPEMAIL | /usr/sbin/sendmail -t -i
done

rm -f $TMPEMAIL
rm -f $RELEASE_EMAIL_FILE
