#!/bin/sh

# This script is used to create SMTP forwarding and cancel all other email settings

#SMTPLINES=`cat $CREATESMTPFILE`
SEDTMP="/tmp/sed_reset_smtp.tmp"
SEDOUTPUT="/tmp/sed.out"
MAILERTABLE=/etc/mail/mailertable
ACCESSFILE=/etc/mail/access
LOCALHOSTSFILE=/etc/mail/local-host-names
	
#LDAPDELETEAUTHFILE=$LISTDIR"deleteldapauth.list"

for SMTPLINE in $@
do
	DOMAIN=`echo $SMTPLINE | cut -f1 -d","`
	IPADDRESS=`echo $SMTPLINE | cut -f2 -d","`

	logger -p local3.info -t vpanel "Installing SMTP forwarding for $DOMAIN to $IPADDRESS ..."

	if ! grep -qsE "^$DOMAIN\t\t" $MAILERTABLE; then
		# Add to mailertable
		echo -e "$DOMAIN\t\t\tsmtp:[$IPADDRESS]" >> $MAILERTABLE
		logger -p local3.info -t vpanel "Added $DOMAIN to $MAILERTABLE"
	else
		echo -e "s/^$DOMAIN.*/$DOMAIN\t\t\tsmtp:[$IPADDRESS]/" > $SEDTMP

		sed -f $SEDTMP $MAILERTABLE > $SEDOUTPUT
		mv $SEDOUTPUT $MAILERTABLE
	fi

	if ! grep -qsE "To:$DOMAIN\t" $ACCESSFILE; then
		# Add to access file
		echo -e "To:$DOMAIN\t\t\tRELAY" >> $ACCESSFILE
		logger -p local3.info -t vpanel "Added $DOMAIN to $ACCESSFILE"	
	else
		echo -e "s/^To:$DOMAIN.*/To:$DOMAIN\t\t\tRELAY/" > $SEDTMP

		sed -f $SEDTMP $ACCESSFILE > $SEDOUTPUT
		mv $SEDOUTPUT $ACCESSFILE
	fi

	# Remove from virtusertable
	#echo "/.*\@$DOMAIN/d" > $SEDTMP
	#sed -f $SEDTMP $VIRTFILE > $SEDOUTPUT
	#mv $SEDOUTPUT $VIRTFILE
	#logger -p local3.info -t vpanel "Removed $DOMAIN from $VIRTFILE"
	
	# Remove from local-hosts
	echo "/^$DOMAIN/d" > $SEDTMP
       	sed -f $SEDTMP $LOCALHOSTSFILE > $SEDOUTPUT
       	mv $SEDOUTPUT $LOCALHOSTSFILE
	logger -p local3.info -t vpanel "Removed $DOMAIN from $LOCALHOSTSFILE"

	# Remove all users except ftp users and 01 users
	DEL_USERS=`grep ":$DOMAIN:" $PASSFILE | grep -v "^ftp" | grep -v "01:x:"| cut -f1 -d":"`
	#for DEL_USER in $DEL_USERS
	#do
	#	MBOX="/var/spool/mail/"$DEL_USER
	#	HOMEDIR=`grep "^$DEL_USER:" $PASSFILE | cut -f6 -d":"`
	#	/usr/sbin/userdel $DEL_USER
	#	logger -p local3.info -t vpanel "$DEL_USER deleted as part of installing SMTP forwarding for $DOMAIN"
	#	if [ -e $MBOX ]; then
	#		rm -f $MBOX
	#		logger -p local3.info -t vpanel "$DEL_USER mailbox deleted as part of installing SMTP forwarding for $DOMAIN"
	#	fi
	#	if [ -e $HOMEDIR ]; then
	#		rm -rf $HOMEDIR
	#		logger -p local3.info -t vpanel "$DEL_USER homedir deleted as part of installing SMTP forwarding for $DOMAIN"
	#	fi

	#	# LDAP MODIFICATION
	#	/usr/local/bin/ldapdelete -H ${LDAPHOST} -x -D ${LDAPADMIN} -w ${LDAPPASS} -r "uid=${DEL_USER},cn=${DOMAIN},ou=domains,dc=ieinternet,dc=net"
	#	# remove from authorised
	#	echo "dn: cn=${DOMAIN},ou=domains,dc=ieinternet,dc=net" >> $LDAPDELETEAUTHFILE
	#	echo "changetype: modify" >> $LDAPDELETEAUTHFILE
	#	echo "delete: memberUid" >> $LDAPDELETEAUTHFILE
	#	echo "memberUid: $DEL_USER" >> $LDAPDELETEAUTHFILE
	#	echo >> $LDAPDELETEAUTHFILE

	#done
	# Now delete the mailbox of the main user
	#MAINUSER=`grep ":$DOMAIN:" $PASSFILE | grep -v "^ftp" | grep -v "^spam" | grep "01:x:" | cut -f1 -d":"`
	#MAINSPOOL="/var/spool/mail/"$MAINUSER
	#if [ -e $MAINSPOOL ]; then
	#	rm -f $MAINSPOOL
	#	logger -p local3.info -t vpanel "$MAINUSER mailbox deleted as part of installing SMTP forwarding for $DOMAIN"
	#fi

	logger -p local3.info -t vpanel "SMTP forwarding for $DOMAIN to $IPADDRESS installed"
done
# LDAP MODIFICATION
#/usr/local/bin/ldapmodify -H ${LDAPHOST} -x -D ${LDAPADMIN} -w ${LDAPPASS} -f $LDAPDELETEAUTHFILE
#rm -f $LDAPDELETEAUTHFILE

rm -f $SEDOUTPUT
rm -f $SEDTMP
#rm -f $CREATESMTPFILE
