#!/bin/bash

# Script to ammend the advanced virus scanning features to 
# create filetype scanning by removing the domain from the FILETYPE_SCANNING_RULES_FILE file

OUTFILE="/tmp/change_filetype_scanning.tmp"
SEDFILE="/tmp/change_filetype_scanning.sed"

#DOMAINLINES=`cat $CHANGE_FILETYPE_SCANNING_FILE`

for DOMAINLINE in $@
do
	FLAG=`echo $DOMAINLINE | cut -f1 -d,`
	DOMAIN=`echo $DOMAINLINE | cut -f2 -d,`
	DOMAIN_ENTRY="*@$DOMAIN"

	logger -p local3.info -t vpanel "Changing filetype scanning for $DOMAIN - changing to $FLAG"

	# remove domain from the file
	echo "/$DOMAIN_ENTRY/d" > $SEDFILE
	sed -f $SEDFILE $FILETYPE_SCANNING_RULES_FILE > $OUTFILE
	mv $OUTFILE $FILETYPE_SCANNING_RULES_FILE

	# remove default line
	grep -v "default" $FILETYPE_SCANNING_RULES_FILE > $OUTFILE

        # This function checks to see which of the four options below are relevant [ if any ] for the domain
        # default: filetype.everything.conf

	if [ $FLAG == "everything" ] ;then
		echo -e "FromOrTo:\t$DOMAIN_ENTRY\t\t\t/etc/MailScanner/filetype.everything.conf" >> $OUTFILE

	elif [ $FLAG == "only_spam" ] ;then
		echo -e "FromOrTo:\t$DOMAIN_ENTRY\t\t\t/etc/MailScanner/filetype.justimages.conf" >> $OUTFILE

	elif [ $FLAG == "only_virus" ] ;then
		# The default option is only virus
		echo ""

	elif [ $FLAG == "nothing" ] ;then
		echo -e "FromOrTo:\t$DOMAIN_ENTRY\t\t\t/etc/MailScanner/filetype.nothing.conf" >> $OUTFILE

	else
		# Incorrect parameters passed
		logger -p local3.info -t vpanel "Error: didn't change filetype scanning for $DOMAIN - incorrect parameters passed"
	fi

	# Add in default setting
	echo -e "FromOrTo:\tdefault\t\t\t\t/etc/MailScanner/filetype.justvirus.conf" >> $OUTFILE
	mv $OUTFILE $FILETYPE_SCANNING_RULES_FILE
done

rm -f $SEDFILE	
rm -f $OUTFILE
#rm -f $CHANGE_FILETYPE_SCANNING_FILE


