#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);

# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header("Advanced Virus protection features for $domainname");

print<<HEAD;
	Apart from the normal scanning of all your emails for conventional viruses, MailWall also offers you an extensive
	range of additional features, designed to further enhance your internet security. Below are listed all these additional
	features and the current status of each. <BR><BR>
HEAD

# There are five elements to the advanced virus scanning section:
# 1. Suspect HTML. Converts it to text.
#    File is rules/virus/suspect.html.rules (default YES)

	$suspect_html_scanning_status = virus_advanced_scanning_status($domainname, "Suspect HTML");
	if ( $suspect_html_scanning_status eq "on" )
	{
		show_status_of_service( "on", $turn_off_suspect_html_scanning, "Suspect HTML scanning" );
	} else {
		show_status_of_service( "off", $turn_on_suspect_html_scanning, "Suspect HTML scanning" );
	}

# 2. Dangerous HTML code - eg. Iframes. Treated as a virus.
#    File is rules/virus/dangerous.html.rules (default NO)

	$dangerous_html_scanning_status = virus_advanced_scanning_status($domainname, "Dangerous HTML");
	if ( $dangerous_html_scanning_status eq "on" )
	{
		show_status_of_service( "on", $turn_off_dangerous_html_scanning, "Dangerous HTML scanning" );
	} else {
		show_status_of_service( "off", $turn_on_dangerous_html_scanning, "Dangerous HTML scanning" );
	}

# 3. Strange message structures and attachments. 
#    File is rules/virus/suspect.content.rules (default NO)

	$suspect_content_scanning_status = virus_advanced_scanning_status($domainname, "Suspect content" );
	if ( $suspect_content_scanning_status eq "on" )
	{
		show_status_of_service( "on", $turn_off_suspect_content_scanning, "Suspect content scanning" );
	} else {
		show_status_of_service( "off", $turn_on_suspect_content_scanning, "Suspect content scanning" );
	}

# 4. Double extensions etc.
#    File is rules/virus/filename.scanning.rules (default /etc/MailScanner/filename.rules.conf)

	$filename_scanning_status = virus_advanced_scanning_status($domainname, "Filename");

	if ( $filename_scanning_status eq "on" )
	{
		show_status_of_service( "on", $turn_off_filename_scanning, "File name scanning" );
	} else {
		show_status_of_service( "off", $turn_on_filename_scanning, "File name scanning" );
	}

# 5. Movies, exes and self extracting archives. 

	$filetype_scanning_status = filetype_scanning_status($domainname);
	if ( ($filetype_scanning_status eq "everything") || ($filetype_scanning_status eq "only_virus") )
	{
		show_status_of_service( "on", "$change_filetype_scanning?change=voff", "File type scanning" );
	} else {
		show_status_of_service( "off", "$change_filetype_scanning?change=von", "File type scanning" );
	}


show_meaning_of_icons($tabnum_mailwall);

require $footer;
