#!/bin/bash

# This script outputs the space usage for a given domain
# The main parts are:
# 1. Website ###
# 2. Webmail ###
# 3. Mailboxes ### 
# 4. Spam Trap ###
# 4. Summary ###

# Script called in two ways:
# 1. with the "shell" argument - output is for shell not website and webmail and email users are emailed if their size are large.
# 2. with only the domain name as argument - output is formatted for HTML output to vpanel, space check is logged.
if [ $# -eq 2 ]; then
	if [ "$2" != "shell" ]; then
		echo -e "Error!\nUsage: `basename $0` <domain> [<shell>]\n"
		exit
	else
		NEWLINE="\n"
		BOLD=""
		CLOSEBOLD=""
		ITALICS=""
		CLOSEITALICS=""
	fi
elif [ $# -eq 0 ]; then
	echo -e "Error!\nUsage: `basename $0` <domain> [<shell>]\n"
        exit
elif [ $# -eq 1 ]; then
	NEWLINE="<BR>"
	BOLD="<b>"
        CLOSEBOLD="</b>"
        ITALICS="<i>"
        CLOSEITALICS="</i>"
elif [ $# -gt 2 ]; then
        echo -e "Error!\nUsage: `basename $0` <domain> [<shell>]\n"
        exit
fi

### Define variables
DOMAIN=$1
HOMEDIR="/var/customers/www.$DOMAIN"
WEBSITE="$HOMEDIR/website/htdocs"
HOMES="$HOMEDIR/homes/"
SPOOL="/var/spool/mail"
LOGS="$HOMEDIR/website/logs"
DOMAININFOFILE="/var/customers/domain-data/domains.data"
PASSFILE="/etc/passwd"
KBTOTALSPOOLSIZE=0
KBTOTALWEBMAILSIZE=0
SPAMTRAP=0
KBTOTALSPAMSIZE=0
MAXTRASHLIMIT=3000 # Kb
MAXMAILBOXSIZE=15000 # Kb

#################
## 1. Website ###
#################

if [ -e $WEBSITE ]
then
	WEBSIZE=`du -bs $WEBSITE | cut -f1`
fi
[ -z "$WEBSIZE" ] && WEBSIZE=0

if [ -e $LOGS ]
then
	LOGSIZE=`du -bs $LOGS | cut -f1`
fi
[ -z "$LOGSIZE" ] && LOGSIZE=0

KBWEBSIZE=`expr $WEBSIZE / 1024`
KBLOGSIZE=`expr $LOGSIZE / 1024`
KBTOTALWEBSIZE=`expr $KBWEBSIZE + $KBLOGSIZE`

echo -e "$BOLD Your website:$CLOSEBOLD$NEWLINE$NEWLINE"

if [ $KBWEBSIZE -gt 1024 ]
then
	MBWEBSIZE=`expr $KBWEBSIZE / 1024`
	echo -e "Website: $MBWEBSIZE Mb$NEWLINE"
else
	echo -e "Website: $KBWEBSIZE Kb$NEWLINE"
fi

if [ $KBLOGSIZE -gt 1024 ]
then
	MBLOGSIZE=`expr $KBLOGSIZE / 1024`
	echo -e "Website Logs: $MBLOGSIZE Mb$NEWLINE"
else
	echo -e "Website Logs: $KBLOGSIZE Kb$NEWLINE"
fi

if [ $KBTOTALWEBSIZE  -gt 1024 ]
then
        MBTOTALWEBSIZE=`expr $KBTOTALWEBSIZE / 1024`
	echo -e "$ITALICS Total size of your website: $MBTOTALWEBSIZE Mb$CLOSEITALICS$NEWLINE"
else
	echo -e "$ITALICS Total size of your website: $KBTOTALWEBSIZE Kb$CLOSEITALICS$NEWLINE"
fi

################
# 2. Webmail ###
################

# USERS="`grep \":$DOMAIN:\" $PASSFILE | cut -f1 -d:`"
USERS="`grep \":$DOMAIN:\" $PASSFILE | grep -v spam | cut -f1 -d:`"

echo -e "$NEWLINE$NEWLINE$BOLD Your webmail folders:$CLOSEBOLD$NEWLINE$NEWLINE"

for WEBMAILUSER in $USERS
do
	if [ ${WEBMAILUSER:0:3} == "ftp" ]; then
		# skip
		echo -e ""
	else
		# perform different check on the main user
		TWOFROMEND=`expr ${#WEBMAILUSER} - 2`
		HOMEDIR=`grep "^$WEBMAILUSER" /etc/passwd | cut -f6 -d":"`
		if [ ${WEBMAILUSER:$TWOFROMEND:2} == "01" ]; then
			KBWEBMAILSIZE=`du -caS --max-depth=0 --exclude=htdocs --exclude=logs $HOMEDIR | tail -1 | cut -f1`
		else	
			# get the user's home directory
			if [ -e $HOMEDIR ] ; then 
				KBWEBMAILSIZE=`du -s $HOMEDIR | cut -f1`
			fi
		fi
		if [ "$KBWEBMAILSIZE" ]; then
			TRASHFOLDER=$HOMEDIR"/Trash"
			# if called by shell, then it's time to send a weekly reminder to users with huge Trash folders
				if [ "$2" == "shell" -a -e $TRASHFOLDER ]; then					
					TRASHSIZE=`du -s $TRASHFOLDER | cut -f1`
					if [ $TRASHSIZE -gt $MAXTRASHLIMIT ]; then
echo -e "To: $WEBMAILUSER
From: support@ieinternet.com (IE Internet Space Monitor)
Reply-To: do-not-reply@ieinternet.com
Subject: Excess Space Usage Warning - webmail account $WEBMAILUSER

[ This is an automated message - please do not reply ]

Dear IE Internet webmail user,

You are receiving this email because it has come to the attention of our systems that you may
not be deleting emails from your webmail correctly. At the moment when you delete emails
these emails are not deleted; instead they are placed into your Trash folder.

We advise you to empty your Trash folder regularly, as the continued increase in size of your
Trash folder may lead to your account exceeding its space limit.

To empty your Trash folder, please login to webmail and on the left hand side of the screen,
click on the '(purge)' option beside 'Trash'.

--

Kind regards,

Technical Department,
IE Internet.

" | /usr/sbin/sendmail -t -i
				logger -p local3.info -t vpanel "Space warning given to webmail user $WEBMAILUSER of $DOMAIN"
					fi
				fi
		else
			KBWEBMAILSIZE=0
		fi

		if [ $KBWEBMAILSIZE -gt 1024 ]
		then
		        MBWEBMAILSIZE=`expr $KBWEBMAILSIZE / 1024`
			echo -e "$WEBMAILUSER: \t $MBWEBMAILSIZE Mb$NEWLINE"
		else
			echo -e "$WEBMAILUSER: \t $KBWEBMAILSIZE Kb$NEWLINE"
		fi
		KBTOTALWEBMAILSIZE=`expr $KBTOTALWEBMAILSIZE + $KBWEBMAILSIZE`
	fi
done

if [ $KBTOTALWEBMAILSIZE  -gt 1024 ]
then
        MBTOTALWEBMAILSIZE=`expr $KBTOTALWEBMAILSIZE / 1024`
        echo -e "$ITALICS Total size of your webmail folders: $MBTOTALWEBMAILSIZE Mb$CLOSEITALICS$NEWLINE"
else
        echo -e "$ITALICS Total size of your webmail folders: $KBTOTALWEBMAILSIZE Kb$CLOSEITALICS$NEWLINE"
fi


##################
# 3. Mailboxes ###
##################

echo -e "$NEWLINE$NEWLINE$BOLD Your user accounts/mailboxes:$CLOSEBOLD$NEWLINE$NEWLINE"

for MAILUSER in $USERS
do
	if [ ${MAILUSER:0:3} == "ftp" ]; then
                # skip
                echo -e ""
        else
		MAILBOX=$SPOOL/$MAILUSER
		if [ -e $MAILBOX ]; then
			BOXSIZE=`du -bs $MAILBOX | cut -f1`
			KBBOXSIZE=`expr $BOXSIZE / 1024`

			# Send an email if the user's mailbox is too large
			if [ $KBBOXSIZE -gt $MAXMAILBOXSIZE -a "$2" == "shell" ]; then

echo -e "To: $MAILUSER
From: support@ieinternet.com (IE Internet Space Monitor)
Reply-To: do-not-reply@ieinternet.com
Subject: Excess Space Usage Warning - email account $MAILUSER

[ This is an automated message - please do not reply ]

Dear IE Internet email user,

You are receiving this email because it has come to the attention of our systems that your email
account is quite large. You would be advised to ensure that your email account remains within the
limits of your hosting plan to avoid any unnecessary downtime on your account. You can do this by 
setting up your PC so that when you download emails you have not asked your PC to leave 
a copy of emails on the server.

The exact size of your email account may be determined through your IE Internet control panel. If 
you do not have the login details to your control panel, please contact your IT department.

Your assistance in this regard is appreciated. 

--

Kind regards,

Technical Department,
IE Internet.

" | /usr/sbin/sendmail -t -i
				logger -p local3.info -t vpanel "Space warning given to email mailbox user $MAILUSER of $DOMAIN"
			fi

			if [ $KBBOXSIZE -gt 1024 ]
			then
				MBBOXSIZE=`expr $KBBOXSIZE / 1024`
				echo -e "$MAILUSER: \t$MBBOXSIZE Mb$NEWLINE"
			else
				echo -e "$MAILUSER: $KBBOXSIZE Kb$NEWLINE"	
			fi
			KBTOTALSPOOLSIZE=`expr $KBTOTALSPOOLSIZE + $KBBOXSIZE`
		fi
	fi
done

if [ $KBTOTALSPOOLSIZE -gt 1024 ]; then
	MBTOTALSPOOLSIZE=`expr $KBTOTALSPOOLSIZE / 1024`
	echo -e "$ITALICS Total size of your mailboxes: $MBTOTALSPOOLSIZE Mb$CLOSEITALICS$NEWLINE"
else
	echo -e "$ITALICS Total size of your mailboxes: $KBTOTALSPOOLSIZE kb$CLOSEITALICS$NEWLINE"
fi

##################
# 4. Spam Trap ###
##################


SPAMTRAP=`grep "^spam.*:$DOMAIN:" $PASSFILE | grep -c spam`

if [ "$SPAMTRAP" -ne 0 ]; then
	echo -e "$NEWLINE$NEWLINE$BOLD Your Spam Trap:$CLOSEBOLD$NEWLINE$NEWLINE"
	
	# Get mailbox size
	SPAMTRAPUSER=`grep "^spam.*:$DOMAIN:" $PASSFILE | cut -f1 -d":"`
	SPAMMAILBOX=$SPOOL/$SPAMTRAPUSER
	
	if [ -e $SPAMMAILBOX ]; then
		SPAMBOXSIZE=`du -bs $SPAMMAILBOX | cut -f1`
        	KBSPAMBOXSIZE=`expr $SPAMBOXSIZE / 1024`

		if [ ! "$KBSPAMBOXSIZE" ]; then
			KBSPAMBOXSIZE=0
		fi

	        if [ $KBSPAMBOXSIZE -gt 1024 ]
        	then
	        	MBSPAMBOXSIZE=`expr $KBSPAMBOXSIZE / 1024`
			echo -e "Your Spam Trap mailbox size: \t$MBSPAMBOXSIZE Mb$NEWLINE"
	        else
        	        echo -e "Your Spam Trap mailbox size: \t$KBSPAMBOXSIZE Kb$NEWLINE"
	        fi
	
		# Get webmail folder size
		HOMEDIR=`grep "^$SPAMTRAPUSER" /etc/passwd | cut -f6 -d":"`
		KBWEBMAILSIZE=`du -s $HOMEDIR | cut -f1`
        	# if null value returned, set the user's home folder size to zero
	        if [ "$KBWEBMAILSIZE" ]; then
        		echo -e ""
	        else
        		KBWEBMAILSIZE=0
	        fi
	
		if [ $KBWEBMAILSIZE -gt 1024 ]
	        then
        	        MBWEBMAILSIZE=`expr $KBWEBMAILSIZE / 1024`
                	echo -e "Your Spam Trap's webmail folders size: \t$KBWEBMAILSIZE Mb$NEWLINE"
		else
			echo -e "Your Spam Trap's webmail folders size: \t$KBWEBMAILSIZE kb$NEWLINE"
		fi
		
		KBTOTALSPAMSIZE=`expr $KBWEBMAILSIZE + $KBSPAMBOXSIZE`

		if [ $KBTOTALSPAMSIZE -gt 1024 ]; then
        		MBTOTALSPAMSIZE=`expr $KBTOTALSPAMSIZE / 1024`
	        	echo -e "$ITALICS Total size of your Spam Trap: $MBTOTALSPAMSIZE Mb$CLOSEITALICS$NEWLINE"
		else
        		echo -e "$ITALICS Total size of your Spam Trap: $KBTOTALSPAMSIZE Kb$CLOSEITALICS$NEWLINE"
		fi
	else
		KBTOTALSPAMSIZE=0
		echo -e "$ITALICS Total size of your Spam Trap: $KBTOTALSPAMSIZE Kb$CLOSEITALICS$NEWLINE"
	fi
else
	KBTOTALSPAMSIZE=0
fi

##################
# 4. Summary ###
##################

echo -e "$NEWLINE$NEWLINE$BOLD Your Total Space Usage:$CLOSEBOLD$NEWLINE$NEWLINE"

KBTOTALSIZE=`expr $KBTOTALWEBSIZE + $KBTOTALSPOOLSIZE + $KBTOTALWEBMAILSIZE + $KBTOTALSPAMSIZE`

# Get server limit

MBDOMAINLIMIT=`grep -E "^$DOMAIN," $DOMAININFOFILE | cut -f3 -d","`
[ -z "$MBDOMAINLIMIT" ] && MBDOMAINLIMIT=1;
KBDOMAINLIMIT=`expr $MBDOMAINLIMIT \* 1024`

PERCENTLIMIT=`expr $KBTOTALSIZE \* 100`
PERCENTLIMIT=`expr $PERCENTLIMIT / $KBDOMAINLIMIT`

if [ "$PERCENTLIMIT" -eq 0 ]; then
	PERCENTLIMIT=1
fi

if [ $KBTOTALSIZE -gt 1024 ]
then
	MBTOTALSIZE=`expr $KBTOTALSIZE / 1024`
	echo -e "Total size of your account: $MBTOTALSIZE Mb.$NEWLINE"
	echo -e "Limit for your current hosting plan: $MBDOMAINLIMIT Mb.$NEWLINE"
	echo -e "Percentage of allotted space used:  $PERCENTLIMIT%.$NEWLINE"
	if [ "$2" != "shell" ]; then
		logger -p local3.info -t vpanel "Space checked for domain $DOMAIN: size is $MBTOTALSIZE Mb."
	fi
else
	echo -e "Total size of your account: $KBTOTALSIZE Kb.$NEWLINE"
	echo -e "Limit for your current hosting plan: $MBDOMAINLIMIT Mb.$NEWLINE"
	echo -e "Percentage of allotted space used:  $PERCENTLIMIT%.$NEWLINE"
	if [ "$2" != "shell" ]; then
		logger -p local3.info -t vpanel "Space checked for domain $DOMAIN: size is $KBTOTALSIZE Kb."
	fi
fi

# Get server limit

DOMAINLIMIT=`grep "^$DOMAIN," $DOMAININFOFILE | cut -f3 -d","`
[ -z "$DOMAINLIMIT" ] && DOMAINLIMIT=1;
DOMAINLIMIT=`expr $DOMAINLIMIT \* 1024`

if [ $KBTOTALSIZE -gt $DOMAINLIMIT ]
then
	if [ "$2" != "shell" ]; then
		logger -p local3.info -t vpanel "Vpanel warning given to $DOMAIN: server space: $KBTOTALSIZE Kb; Allowance: $DOMAINLIMIT Kb"
		echo -e "$NEWLINE$NEWLINE$BOLD <font color=#cc0000>Important Notice</font>$CLOSEBOLD$NEWLINE$NEWLINE"
		echo -e "<tr><font-size=8px; color=#DD0000;>You are currently exceeding your allocated server space."
		echo -e "This may result in a charge being incurred for the additional $NEWLINE server resources being consumed."
		echo -e "If you have any queries please contact our <a href=mailto:accounts@ieinternet.com>Accounts Department</a>."
	else
		# Called automatically - send an email to customer
		echo -e "\t\t\tThis account is currently exceeding its allocated server space."
		logger -p local3.info -t vpanel "Email sent re: overuse of space for $DOMAIN: $KBTOTALSIZE Kb used; $DOMAINLIMIT Kb allowed"
		RECIPIENT="info@$DOMAIN"

echo -e "To: $RECIPIENT
From: support@ieinternet.com (IE Internet Space Monitor)
Reply-To: do-not-reply@ieinternet.com
Subject: Excess Space Usage Warning - $DOMAIN

[ This is an automated message - please do not reply ]

Dear Customer,

This is an automated email generated to draw your attention to the fact that you are 
currently exceeding the space allowance on your hosting account with IE Internet.

The percentage of your alloted space you are currently using is: $PERCENTLIMIT%

The purpose of this email is simply to alert you to the fact that you may need to 
more effectively manage your space usage. This can be done in the following ways:

* delete any unused files from your website;
* ensure that when you download emails you do not leave a copy of these emails on the server; and
* when you delete emails in webmail, you 'purge' the Trash folder to permanently delete these emails.

Full details of where you are using space on your account is available through your control panel. To access
your control panel please visit www.ieinternet.com/mycontrolpanel.htm

We encourage you to take action to ensure that your account remains within its allocation.

--

Kind regards,

Technical Department,
IE Internet.

" | /usr/sbin/sendmail -t -i
		logger -p local3.info -t vpanel "Warning email sent to $DOMAIN: server space: $KBTOTALSIZE Kb; Allowance: $DOMAINLIMIT Kb"
	fi
fi

