#!/bin/bash

# This script removes all email settings in the virtusertable and replaces it with a multidrop

MULTIDROPS=`cat $OVERWRITEWITHMULTIDROPFILE`
SEDFILE="/tmp/vpanel.sed.tmp"
OUTFILE="/tmp/multidrop-output.vpanel"

for MD in $MULTIDROPS
do
	MULTIDROPNAME=`echo $MD | cut -f1 -d","`
	TARGET=`echo $MD | cut -f2 -d","`
	
	LENGTH=${#MULTIDROPNAME};
	DOMLENGTH=`expr $LENGTH - 1`
	DOMAIN=${MD:1:$DOMLENGTH}

	logger -p local3.info -t vpanel "Replacing email set up for $DOMAIN with multidrop to $TARGET ..."

	echo "/.*\@$DOMAIN/d" > $SEDFILE
	sed -f $SEDFILE $VIRTFILE > $OUTFILE
	mv $OUTFILE $VIRTFILE
	echo -e "$MULTIDROPNAME\t\t\t$TARGET" >> $VIRTFILE

	# Remove all users except ftp users and 01 users
	DEL_USERS=`grep ":$DOMAIN:" $PASSFILE | grep -v "^ftp" | grep -v "01:x:"| cut -f1 -d":"`
	for DEL_USER in $DEL_USERS
	do
		MBOX="/var/spool/mail/"$DEL_USER
		HOMEDIR=`grep $DEL_USER $PASSFILE | cut -f6 -d":"`
		/usr/sbin/userdel $DEL_USER
		logger -p local3.info -t vpanel "$DEL_USER deleted as part of installing multidrop for $DOMAIN"
		rm -f $MBOX
		logger -p local3.info -t vpanel "$DEL_USER mailbox deleted as part of installing multidrop for $DOMAIN"
		rm -rf $HOMEDIR
		logger -p local3.info -t vpanel "$DEL_USER homedir deleted as part of installing multidrop for $DOMAIN"
	done

	logger -p local3.info -t vpanel "Replaced email set up for $DOMAIN with multidrop to $TARGET"

	rm -f $SEDFILE
done

rm -f $OVERWRITEWITHMULTIDROPFILE

