#!/bin/sh

# This script deletes a mailbox so long as the mailbox belongs tp the domain name

DELLINES=`cat $EMPTYMAILBOXFILE`

for DELLINE in $DELLINES
do
	USER=`echo $DELLINE | cut -f1 -d,`
	DOMAIN=`echo $DELLINE | cut -f2 -d,`

	MAILBOX_DOMAIN=`grep "^$USER:" $PASSFILE |  cut -f5 -d:`
	
	if [ $MAILBOX_DOMAIN == $DOMAIN ]; then
		MAILBOX=$MAILSPOOL$USER
		rm -f $MAILBOX
		logger -p local3.info -t vpanel "Emptied mailbox of $USER for $DOMAIN"
	else
		logger -p local3.info -t vpanel "Attempt to delete mailbox for $USER failed - not owned by inputted domain $DOMAIN"
	fi
done

rm -f $EMPTYMAILBOXFILE
