#!/bin/bash

# This script removes a multidrop account and replaces it with the three default email addresses attached to the mainuser for the domain

DELMULTIDROPS=`cat $DELETEMULTIDROPFILE`
SEDFILE="/tmp/vpanel.sed.tmp"
OUTFILE="/tmp/multidrop-output.vpanel"

for MD in $DELMULTIDROPS
do
	MULTIDROPDOMAIN=`echo $MD | cut -f2 -d"@"`
	MAINUSER=`grep $MULTIDROPDOMAIN $PASSFILE | grep "01:x:" | head -n1 | cut -f1 -d:`

	INFO="info@$MULTIDROPDOMAIN"
	ABUSE="abuse@$MULTIDROPDOMAIN"
	POSTMASTER="postmaster@$MULTIDROPDOMAIN"
	RESET=0

	# Remove multidrop
		echo "/^@$MULTIDROPDOMAIN/d" > $SEDFILE
		sed -f $SEDFILE $VIRTFILE > $OUTFILE
		mv $OUTFILE $VIRTFILE

	# Insert three default email addresses if they do not already exist
	COUNTINFO=`grep -c "^$INFO" $VIRTFILE`
	if [ $COUNTINFO -eq 0 ]; then
		echo -e "$INFO\t\t\t$MAINUSER" >> $VIRTFILE
		RESET=1
	fi
	COUNTABUSE=`grep -c "^$ABUSE" $VIRTFILE`
	if [ $COUNTABUSE -eq 0 ]; then
		echo -e "$ABUSE\t\t\t$INFO" >> $VIRTFILE
		RESET=1
	fi
	COUNTPOSTMASTER=`grep -c "^$POSTMASTER" $VIRTFILE`
	if [ $COUNTPOSTMASTER -eq 0 ]; then
		echo -e "$POSTMASTER\t\t\t$INFO" >> $VIRTFILE
		RESET=1
	fi
	if [ $RESET -eq 1 ]; then
		logger -p local3.info -t vpanel "Deleted multidrop for $MULTIDROPDOMAIN and reset the account with its default email setup"
	else
		logger -p local3.info -t vpanel "Deleted multidrop for $MULTIDROPDOMAIN"
	fi
	rm -f $SEDFILE
done

rm -f $DELETEMULTIDROPFILE

