#!/bin/sh

# This script is used to create SMTP forwarding and cancel all other email settings

SMTPLINES=`cat $CREATESMTPFILE`
SEDTMP="/tmp/sed_reset_smtp.tmp"
SEDOUTPUT="/tmp/sed.out"

for SMTPLINE in $SMTPLINES
do
	DOMAIN=`echo $SMTPLINE | cut -f1 -d","`
	IPADDRESS=`echo $SMTPLINE | cut -f2 -d","`
	
	logger -p local3.info -t vpanel "Installing SMTP forwarding for $DOMAIN to $IPADDRESS ..."

	# Add to mailertable
	echo -e "$DOMAIN\t\t\tsmtp:[$IPADDRESS]" >> $MAILERTABLE
	logger -p local3.info -t vpanel "Added $DOMAIN to $MAILERTABLE"

	# Add to access file
	echo -e "$DOMAIN\t\t\tRELAY" >> $ACCESSFILE
	logger -p local3.info -t vpanel "Added $DOMAIN to $ACCESSFILE"	

	# Remove from virtusertable
	echo "/.*\@$DOMAIN/d" > $SEDTMP
	sed -f $SEDTMP $VIRTFILE > $SEDOUTPUT
	mv $SEDOUTPUT $VIRTFILE
	logger -p local3.info -t vpanel "Removed $DOMAIN from $VIRTFILE"
	
	# Remove from local-hosts
	echo "/^$DOMAIN/d" > $SEDTMP
        sed -f $SEDTMP $LOCALHOSTSFILE > $SEDOUTPUT
        mv $SEDOUTPUT $LOCALHOSTSFILE
	logger -p local3.info -t vpanel "Removed $DOMAIN from $LOCALHOSTSFILE"

	# Remove all users except ftp users and 01 users
	DEL_USERS=`grep ":$DOMAIN:" $PASSFILE | grep -v "^ftp" | grep -v "01:x:"| cut -f1 -d":"`
	for DEL_USER in $DEL_USERS
	do
		MBOX="/var/spool/mail/"$DEL_USER
		HOMEDIR=`grep "^$DEL_USER:" $PASSFILE | cut -f6 -d":"`
		/usr/sbin/userdel $DEL_USER
		logger -p local3.info -t vpanel "$DEL_USER deleted as part of installing SMTP forwarding for $DOMAIN"
		if [ -e $MBOX ]; then
			rm -f $MBOX
			logger -p local3.info -t vpanel "$DEL_USER mailbox deleted as part of installing SMTP forwarding for $DOMAIN"
		fi
		if [ -e $HOMEDIR ]; then
			rm -rf $HOMEDIR
			logger -p local3.info -t vpanel "$DEL_USER homedir deleted as part of installing SMTP forwarding for $DOMAIN"
		fi
	done
	# Now delete the mailbox of the main user
	MAINUSER=`grep ":$DOMAIN:" $PASSFILE | grep -v "^ftp" | grep -v "^spam" | grep "01:x:" | cut -f1 -d":"`
	MAINSPOOL="/var/spool/mail/"$MAINUSER
	if [ -e $MAINSPOOL ]; then
		rm -f $MAINSPOOL
		logger -p local3.info -t vpanel "$MAINUSER mailbox deleted as part of installing SMTP forwarding for $DOMAIN"
	fi

	logger -p local3.info -t vpanel "SMTP forwarding for $DOMAIN to $IPADDRESS installed"
done

rm -f $SEDOUTPUT
rm -f $SEDTMP
rm -f $CREATESMTPFILE
