#!/bin/sh

# This script calls a script which adds full htdig functionality to a website

DOMAINS=`cat $CREATESEARCHENGINEFILE`
EMAILFILE=$MANDIR"search_engine.email"
TMPEMAILFILE="/tmp/search_engine.email"
SEDFILE="/tmp/search_engine.sed"

for DOMAIN in $DOMAINS
do
	/usr/local/bin/add_htdig.sh $DOMAIN
	logger -p local3.info -t vpanel "Added search engine to www.$DOMAIN"

	# Email customer with details
	echo "s/DOMAIN/$DOMAIN/" > $SEDFILE
	sed -f $SEDFILE $EMAILFILE > $TMPEMAILFILE
	
	mail -s "Installation of a Search Engine $DOMAIN" info@$DOMAIN < $TMPEMAILFILE
	 
done

rm -f $SEDFILE
rm -f $TMPEMAILFILE
rm -f $CREATESEARCHENGINEFILE

