#!/bin/bash

# Script to install a password protected area on a website.
# NMD, July 2004

PWPROTECTION_EMAIL="/tmp/pw_protection.email"

# Get variables from list file
PWLINES=`cat $CREATEPWPROTECTIONFILE`

for PWLINE in $PWLINES
do
	DOMAIN=`echo $PWLINE | cut -f1 -d,`
	USER=`echo $PWLINE | cut -f2 -d,`
	PASSWORD=`echo $PWLINE | cut -f3 -d,`
	FOLDER=`echo $PWLINE | cut -f4 -d,`

	if [ $DOMAIN == "" ] ||[ $USER == "" ] || [ $PASSWORD == "" ] || [ $FOLDER == "" ]; then
		echo "Error in input to password protection script - exiting."
		logger -p local3.info -t vpanel "Password protection failed for $DOMAIN - invalid inputs"
		exit	
	fi

	# Get names of domain's folder
	HTPASSWD_FILE="/var/customers/www."$DOMAIN"/website/.htpasswd"
	CGIBIN="/var/customers/www."$DOMAIN"/website/htdocs/cgi-bin"
	PW_FOLDER="/var/customers/www."$DOMAIN"/website/htdocs/"$FOLDER
	HTACCESS_FILE=$PW_FOLDER"/.htaccess"

	# Ensure inputted folder exists	
	if [ ! -e $PW_FOLDER ]; then
		echo "Error in input to password protection script - $PW_FOLDER does not exist - exiting."
		logger -p local3.info -t vpanel "Password protection failed for $DOMAIN - $PW_FOLDER does not exist"
		exit
	fi

	# copy files to their correct location
	cp $PWPROTECTIONDIR"/passwordprotection.html" $PW_FOLDER
	cp $PWPROTECTIONDIR"/pw_manageusers.pl" $CGIBIN
	cp $PWPROTECTIONDIR"/pw_updateusers.pl" $CGIBIN
	cp $PWPROTECTIONDIR"/pw_variables.pm" $CGIBIN

	# update permissions on these new files
	chown apache:apache $PW_FOLDER"/passwordprotection.html"
	chown root:root $CGIBIN"/pw_manageusers.pl"
	chown root:root $CGIBIN"/pw_updateusers.pl"
	chown root:root $CGIBIN"/pw_variables.pm"
	chmod o+x $CGIBIN"/pw_manageusers.pl"
	chmod o+x $CGIBIN"/pw_updateusers.pl"
	chmod o+r $CGIBIN"/pw_variables.pm"

	# Create the htaccess file
#	echo -e "<Files \".ht*\">\norder deny,allow\ndeny from all\n</Files>" > $HTACCESS_FILE
	echo -e "AuthUserFile $HTPASSWD_FILE" > $HTACCESS_FILE
	echo -e "AuthName \"IE Internet Password Protected Directory\"" >> $HTACCESS_FILE
	echo -e "AuthType Basic\n<Limit GET>\n\trequire valid-user\n</Limit>" >> $HTACCESS_FILE
	
	# Create and populate the htpasswd file with the inputted username and password
	htpasswd -m -b -c $HTPASSWD_FILE $USER $PASSWORD
	chmod o+r $HTPASSWD_FILE
	
	logger -p local3.info -t vpanel "Password protected $FOLDER for $DOMAIN : $USER, $PASSWORD"

	echo -e "Dear Customer,\n\nPlease find below details of the password protection you requested:\n\n" > $PWPROTECTION_EMAIL
	echo -e "Protected part of your website: www.$DOMAIN/$FOLDER\n" >> $PWPROTECTION_EMAIL
	echo -e "Main user: $USER\n" >> $PWPROTECTION_EMAIL
	echo -e "Password: $PASSWORD\n" >> $PWPROTECTION_EMAIL
	echo -e "Web page to manage users: www.$DOMAIN/$FOLDER/passwordprotection.html\n\n" >> $PWPROTECTION_EMAIL
	echo -e "--\n\nThank you,\n\nTechnial Department\nIE Internet\n" >> $PWPROTECTION_EMAIL

	mail -s "Creation of a password protected area for $DOMAIN" info@$DOMAIN < $PWPROTECTION_EMAIL
	rm -rf $PWPROTECTION_EMAIL
done

rm -f $CREATEPWPROTECTIONFILE
