#!/bin/bash

# Script to remove virus scanning for a domain

# Removes domain from the following files:
# 1. AVFILE - virus.scanning.rules
# 2. SUS_HTML_RULES_FILE - suspect.html.rules
# 3. DANG_HTML_RULES_FILE - dangerous.html.rules
# 4. SUS_CONTENT_RULES_FILE - suspect.content.rules
# 5. FILENAME_SCANNING_RULES_FILE - filename.scanning.rules
# 6. FILETYPE_SCANNING_RULES_FILE - filetype.scanning.rules

TMPSEDFILE="/tmp/add_virus_scanning.sed"
OUTFILE="/tmp/virus_addition.tmp"

RemoveDomain ()
{
	SEARCH="@$DOMAIN"
	echo -e "/$SEARCH/d" > $TMPSEDFILE

	grep -q $SEARCH $AVFILE
	CmdOp=$?

	if [ $CmdOp -eq 0 ]
	then
		# This means that the domain has had virus scanning disabled
		logger -p local3.info -t vpanel "Reinstalling Virus Scanning for $DOMAIN ..."

		# 1. AVFILE - virus.scanning.rules
			sed -f $TMPSEDFILE $AVFILE > $OUTFILE
			mv $OUTFILE $AVFILE
			logger -p local3.info -t vpanel " - virus library scanning: turned on"

		# 2. SUS_HTML_RULES_FILE - suspect.html.rules
			sed -f $TMPSEDFILE $SUS_HTML_RULES_FILE > $OUTFILE
			mv $OUTFILE $SUS_HTML_RULES_FILE
			logger -p local3.info -t vpanel " - virus suspect html scanning: turned on"

		# 3. DANG_HTML_RULES_FILE - dangerous.html.rules
			sed -f $TMPSEDFILE $DANG_HTML_RULES_FILE > $OUTFILE
			mv $OUTFILE $DANG_HTML_RULES_FILE
			logger -p local3.info -t vpanel " - virus dangerous html scanning: turned on"
		
		# 4. SUS_CONTENT_RULES_FILE - suspect.content.rules
			sed -f $TMPSEDFILE $SUS_CONTENT_RULES_FILE > $OUTFILE
			mv $OUTFILE $SUS_CONTENT_RULES_FILE
			logger -p local3.info -t vpanel " - virus suspect content scanning: turned on"

		# 5. FILENAME_SCANNING_RULES_FILE - filename.scanning.rules
			sed -f $TMPSEDFILE $FILENAME_SCANNING_RULES_FILE > $OUTFILE
			mv $OUTFILE $FILENAME_SCANNING_RULES_FILE
			logger -p local3.info -t vpanel " - virus filename scanning: turned on"

		# 6. FILETYPE_SCANNING_RULES_FILE - filetype.scanning.rules
			# this is taken care of through a different list file

		logger -p local3.info -t vpanel "All Virus scanning reinstalled for $DOMAIN"
	else 
		logger -p local3.info -t vpanel "Attempt to reinstall virus scanning for $DOMAIN - already installed"
	fi
	return 0
}

DOMAINS=`cat $CREATEVIRUSSCANNINGFILE`

for DOMAIN in $DOMAINS
do
	RemoveDomain
done

rm -f $CREATEVIRUSSCANNINGFILE
rm -f $OUTFILE
rm -f $TMPSEDFILE
