#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
use Net::LDAP;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$hostingplan = find_hosting_plan ($domainname);
$spacelimit = find_space_limit ($domainname);
$userlimit = find_user_limit ($hostingplan);
$usersused = find_number_users ($domainname);
$spaceused = find_space_used ($domainname);
@mailservers = find_mail_servers($domainname);
$numservers = @mailservers;
# @nameservers = find_name_servers("eircom.net");
@nameservers = find_name_servers($domainname);
$numnameservers = @nameservers;


sub user_not_authorised
{
        print "
		<p class=text> According to our records you are not listed as technical contact for this domain name.<BR><BR> 
		For this reason we cannot grant you access to this Control Panel.<BR><BR>
        ";
        print_support_contact_information();
        require $footer;
        exit;
}

sub domain_suspended
{
        print "
                <p class=text> According to our records your domain has been suspended.<BR><BR>
                For this reason we cannot grant you access to this Control Panel.<BR><BR>
                In order to fix this problem please contact our Billing Department.<BR><BR>
        ";
        print_support_contact_information();
        require $footer;
        exit;
}
$ldap = Net::LDAP->new("ldaps://localhost");
$ldap->bind;
$mesg = $ldap->search(  filter=>"(&(cn=$domainname)(memberUid=$loggeduser))", base=>"ou=domains,dc=ieinternet,dc=net", scope=>"one");
@entries = $mesg->entries;
$num_entries = @entries;
if ( $num_entries eq 0 ) 
{
  user_not_authorised;
}

# $mesg = $ldap->search(  filter=>"(&(cn=$domainname)(domainStatus=Active))", base=>"ou=domains,dc=ieinternet,dc=net", scope=>"one");
# @entries = $mesg->entries;
# $num_entries = @entries;
# if ( $num_entries eq 0 )
# {
#   print "$domainname<BR>";
#   domain_suspended;
# }


$ldap->unbind;



($rump, $spacenumber, $spaceunit ) = split ( /\s/, $spaceused);

# Define the tab which appears to the front
$tab_section = $tabnum_home;

# Create the body section associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

if ( ( ! $hostingplan ) || ( ! $domainname ) || ( ! $spacelimit ) || ( ! $userlimit ) || ( ! $usersused ) || ( $numservers == 1 ) )
{
        quit_with_errors ("Incorrect domain parameters passed from get_account_info module for $domainname: 
	$hostingplan $domainname $spacelimit $userlimit $usersused $numservers");
}

$previously_shown = 0;
open ( LOGGEDALREADY, "<$loggedinuserfile") || file_error ($loggedinuserfile);
while (<LOGGEDALREADY>)
{
	if (/$mainuser/)
	{
		$previously_shown = 1;
	}
}
close (LOGGEDALREADY);

if ( $previously_shown == 0 )
{
        # show the improvements which have been made to the control panel since their last logon
        require $vpanel_changes_file;

        open ( LOGGED, ">>$loggedinuserfile") || file_error ($loggedinuserfile);
        print LOGGED "$mainuser\n";
        close LOGGED;
} else {
	# output the contant of this tab
	require $tab_front[$tab_section-1];
}

require $footer;
