#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;
$domainname = find_domain ($mainuser);
$delete_address = param('address');
$delete_user = param('user');

# Define the tab which appears to the front
$tab_section = $tabnum_email;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header ("Deletion of an email address for $domainname");

($deluser, $deldomain ) = split (/@/, $delete_address);

if ( $deldomain ne $domainname)
{
	# do not allow deletion of this address
	print "Sorry but you don't seem to have permission to delete this email address. ";
	print_support_contact_information();
} elsif ( $deluser =~ /^info$/ ) {

	# The info@email address cannot be deleted, only moved to another target

	print qq!
		Sorry but the email address $delete_address cannot be deleted. Instead you can choose to send emails for
		$delete_address to either another user on your account or to another email address. Please select the
		option which best suits your needs:<br><br>
	!;

	#####
	# option one - forward info@ to another user
	#####

	print qq!
		<p class=homeprice>1 - Forward emails for $delete_address to another user on your account
		<p class=text>Please select the user from the list below:
	!;

	@userlist = find_valid_users($domainname);
	$numusers = @userlist;
	print "<form method=post action=/$script_bin/change_info_address.pl>";
	print "<input type=hidden name=address value=none>";
	print "<select name=user class=text>";
	for $_ (@userlist)
	{
		if ( !(/^ftp/) && !(/^spam/) )
		{
			print "<option value='$_'>$_ ";
		}
	}	
	print "</select>";
	print_end_of_form();

	#####
	# option two - forward info@ to another email address
	#####

	print qq!
		<p class=homeprice>2 - Forward emails for $delete_address to another email address
		<p class=text>Please type in the email address below:
		<form class=text action=/$script_bin/change_info_address.pl method=post>
		<input type=hidden name=user value=none>
	!;

	print "info\@$domainname will be forwarded to <input type=text class=text name=address length=50 size=30>";
	print_end_of_form();

} else {
	# All is OK - delete the email address

	# check to see if the email address is a multidrop
	if ( $deluser eq "" )
	{
		$awaiting_deletion = 0;
		@multidrops_awaiting_deletion = find_multidrops_awaiting_deletion();	
		for $delete_multidrop (@multidrops_awaiting_deletion)
		{
			chomp ($delete_multidrop);
			if ( $delete_multidrop eq $delete_address )
			{
				$awaiting_deletion = 1;
				break;
			}
		}	
		if ( $awaiting_deletion == 0 )
		{
			$ret = php_request ("setMultiDrop", "scope=domain:$domainname", "multiDrop=no", "multiDropTarget= ");

			print "Thank you for your request to delete your multidrop acount";
			show_time_to_change();
		} else {
			print "Sorry, but it seems that this multi-drop account is already in the process of being deleted.<BR>"
		}
	} else {
		# It's an ordinary email address - delete it
		@addresses_awaiting_deletion = find_addresses_awaiting_deletion();
		$awaiting_deletion = 0;
		chomp ($delete_address);
		for $del_address (@addresses_awaiting_deletion)
		{
			chomp ($del_address);
			if ( $del_address eq $delete_address ) 
			{
				$awaiting_deletion = 1;
				break;
			}
		}
	
		if ( $awaiting_deletion == 0 && ( $delete_address ne $abuse ) && ( $delete_address ne $postmaster ) )
		{
			if ($delete_user) {
				$ret = php_request ("setDelChild", "scope=user:$delete_user\@$domainname", "childName=email:$delete_address\@$domainname");
			} else {
				$ret = php_request ("setDelChild", "scope=domain:$domainname", "childName=forward:$delete_address");
			}

			print "Thank you for your request to delete the email address $delete_address.";
			show_time_to_change();
		} else {
			print "Sorry, but it seems that the email address $delete_address is already in the process of being deleted.<BR>";
		}

	}
}
require $footer;
