#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;
$domainname = find_domain ($mainuser);

# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

$ipaddress = param('ipaddress');

print_header ("Creation of SMTP forwarding for $domainname");

if ( is_ip_address_syntax_correct($ipaddress) eq "no" )
{
	print "Sorry, but the format of the IP address you supplied ($ipaddress) does not seem to be correct.";
	print_support_contact_information();	
} elsif ( is_ip_address_syntax_correct($ipaddress) eq "restricted" ) {
	print "
	Sorry, but the IP address you supplied ($ipaddress) is from a restricted range and cannot be used
	for SMTP forwarding. You might like to contact your IT Department for further information.<BR><BR>
	";
	print_support_contact_information();
} else {
	# Ensure that forwarding has not already been set up
	if ( is_mailertable($domainname) ne "0" )
	{
		print "Sorry, but it seems that your account already has SMTP forwarding installed.";
		print_support_contact_information();
	} else {	
		# FIXME: this is not implemented in the SOAP server yet
		$ret = php_request ("setSMTPForward", "scope=domain:$domainname", "smtpForward=Yes", "ipAddress=$ipaddress");
		if (defined ($ret) && ref ($ret) ne "SCALAR") {
			print "
			Thank you for your request to install SMTP forwarding for $domainname to the mail server at the
			IP address $ipaddress.
			";
			show_time_to_change();
		} else {
			print "
			Installing SMTP Forwarding for $domainname failed.
			";
		}
		#open (SMTP, ">>$create_smtp_forwarding_file") || file_error($create_smtp_forwarding_file);
		#print SMTP "$domainname,$ipaddress\n";
		#close (SMTP);
	}
}
require $footer;
