#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);

$multidroptype = param ('multidrop');
$emailaddress = param ('emailaddress');
$multidrop_address = "\@$domainname";

# Define the tab which appears to the front
$tab_section = $tabnum_email;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header("Creation of a 'multi-drop' ('catch-all') email account for $domainname");

$address_exists = find_if_address_exists($multidrop_address);
if ( $address_exists != 0 )
{
	print "Sorry, but this multidrop appears to already exist.<BR><BR>";
        print_support_contact_information();
} else {

	if ( ( $emailaddress ne "none" ) && ( check_email_address_syntax($emailaddress) ) )
	{
		print "Sorry, but the syntax of the email address you supplied ($emailaddress) is incorrect.<BR><BR>";
		print_support_contact_information();
	} else {
		if ( $multidroptype eq "rem_user" )
		{
			#
			# Send emails for non-existent addresses to the main user
			#

			$ret = php_request ("setMultiDrop", "scope=domain:$domainname", "multiDrop=mainuser", "multiDropTarget=ignore");

			print "Thank you. All emails sent to non-existent email addresses \@$domainname will be sent to the user $mainuser.";
			show_time_to_change();
	
		} elsif ( $multidroptype eq "rem_email" ) {

			#
			# Send emails for non-existent addresses to another email address
			#

			$ret = php_request ("setMultiDrop", "scope=domain:$domainname", "multiDrop=email", "multiDropTarget=$emailaddress");
			print "Thank you. All emails sent to non-existent email addresses \@$domainname will be forwarded to $emailaddress.";

			show_time_to_change();
	
		} elsif ( $multidroptype eq "all_user" ) {

			#
			# Send emails for all addresses to the main user
			#	

			print qq!

			<form method=post action=/$script_bin/$confirm_overwrite_with_multidrop class=text>
			<input type=hidden name=user value=$mainuser>
			<input type=hidden name=address value=none>

			<font color=#cc0000>*Warning:</font> 
			You have chosen to send emails for all addresses \@$domainname to your main user $mainuser. If you choose this
			option <i>all</i> your current email addresses and email users will be removed and replaced by this configuration. 

			In addition, all mailboxes, whether or they contain emails, will be deleted.<br><BR>
	
			To confirm that this is what you wish to do, please click on the submit button. Once you click submit 
			all users and all emails held on the server will be permanently deleted.
		
			!;

			print_end_of_form();	

		} elsif ( $multidroptype eq "all_email" ) {

			#
			# Send emails for non-existent addresses to another email address
			#

			print qq!

			<form method=post action=/$script_bin/$confirm_overwrite_with_multidrop class=text>
                        <input type=hidden name=user value=none>
                        <input type=hidden name=address value=$emailaddress>

			<font color=#cc0000>*Warning:</font>
			You have chosen to send emails for all addresses \@$domainname to $emailaddress. If you choose this
			option <i>all</i> your current email addresses and email users will be removed and replaced by this 
			configuration. In addition, all mailboxes, whether or they contain emails, will be deleted.<br><br>

			To confirm that this is what you wish to do, please click on the submit button. Once you 
			click submit all users and all emails held on the server will be permanently deleted.

			!;
		
			print_end_of_form();
		}

	}
}
require $footer;
