#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$multidroptype = param ('multidrop');

# Define the tab which appears to the front
$tab_section = $tabnum_email;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

print_header("Creation of a 'multi-drop' ('catch-all') email account for $domainname");

print qq!

<form action=/$script_bin/$final_confirm_create_multidrop method=post class=text>
<input type=hidden name=multidrop value=$multidroptype>

!;

if ( $multidroptype eq "" )
{
	# Error -exit
	quit_with_errors();	

} elsif ( $multidroptype eq "rem_user" ) {
	#
	# Send emails for non-existent addresses to the main user
	#

	print qq!

	You have chosen to send emails for all non-existent addresses \@$domainname to your main user $mainuser.<BR><BR>
	To install this configuration, please click on the submit button:
	<input type=hidden name=emailaddress value='none'

	!;

} elsif ( $multidroptype eq "rem_email" ) {

	#
	# Send emails for non-existent addresses to another email address
	#

	print qq!

	You have chosen to send emails for non-existent addresses \@$domainname to another email address.<BR><BR>

	Please input the email address you wish to forward these emails to and click on the submit button:
	
	<BR><BR>Email address: <input type=text name=emailaddress size=40>

	!;


} elsif ( $multidroptype eq "all_user" ) {

	#
	# Send emails for all addresses to the main user
	#

	print qq!

	You have chosen to send emails for all addresses \@$domainname to your main user $mainuser. <BR><BR>

	If you choose this option all your current email addresses and email users will be removed and replaced by this configuration. In 
	addition, all mailboxes, whether they contain emails or not, <b>will be deleted</b>.<BR><BR>

	To install this configuration, please click on the submit button:
	<input type=hidden name=emailaddress value='none'>

	!;

} elsif ( $multidroptype eq "all_email" ) {

	#
	# Send emails for non-existent addresses to another email address
	#

	print qq!

	You have chosen to send emails for all addresses \@$domainname to another email address. If you choose this 
	option all your current email addresses and email users will be removed and replaced by this configuration. In
	addition, all mailboxes, whether they contain emails or not, <b>will be deleted</b>. Once installed, you will be unable to
	change this configuration through your control panel.<BR><BR>
	To install this configuration, please input the email address you wish to forward these emails to and click on 
	the submit button:
	
	<BR><BR>Email address: <input type=text name=emailaddress size=40>

	!;
}

print_end_of_form();

require $footer;
