#!/bin/sh

# This script will go through all domains and will send an email to recipient if the domain is over-quota

# Get list of domains
BASEDIR="/var/customers"
DIRS=`ls $BASEDIR | grep -v CANCELLED | grep -v template | grep -v domain-data`
SPACE_NOTICE="/tmp/space.notice"
IEINTER_EMAIL="/tmp/over_quota_email_for_ie_support.email"
RECIPIENT="overquota@ieinternet.com"

echo -e "\n\nChecking domains for space limits\n"
logger -p local3.info -t vpanel "Beginning check of space usage for all domains ..."

for DIR in $DIRS
do
	CANCELLED_DIR=$BASEDIR"/"$DIR"."CANCELLED
	DOMAIN=`echo $DIR | cut -f2-4 -d"."`
	if [ -e $CANCELLED_DIR ]; then
		echo -e "\t\tSkipping cancelled account $DOMAIN"
	else
		echo -e "\tChecking Space for $DOMAIN"
	        /var/www/html/vpanel/cgi-bin/space.sh $DOMAIN shell > $SPACE_NOTICE
		grep "currently exceeding" $SPACE_NOTICE
		RETURNV=$?	
		if [ $RETURNV -eq 0 ]; then
			PERCENT=`grep "Percentage of allotted space used" $SPACE_NOTICE | cut -f2 -d:`
			echo -e "To: $RECIPIENT" >  $IEINTER_EMAIL
			echo -e "From: support@ieinternet.com (IE Internet Space Monitor)" >> $IEINTER_EMAIL
			echo -e "Reply-To: do-not-reply@ieinternet.com" >> $IEINTER_EMAIL
			echo -e "Subject: $DOMAIN - using$PERCENT of space\n\n" >> $IEINTER_EMAIL
			echo -e "[ This is an automated message - please do not reply ]\n" >> $IEINTER_EMAIL
			cat $SPACE_NOTICE >> $IEINTER_EMAIL
			cat $IEINTER_EMAIL | /usr/sbin/sendmail -t -i
		fi
	fi
	rm -f $SPACE_NOTICE
	rm -f $IEINTER_EMAIL
done

echo -e "All domains completed\n"
logger -p local3.info -t check-space "Finished check of space usage for all domains"
