#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$change = param('change');

# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

# get the correct definition of the change
if ( $change eq "von" )
{
	$change_string = "turn on file type scanning";
} elsif ( $change eq "voff" ) {
	$change_string = "turn off file type scanning";
} elsif ( $change eq "son" ) {
	$change_string = "turn on image filtering";	
} elsif ( $change eq "soff" ) {
	$change_string = "turn off image filtering";
} else {
	print "It seems that we cannot proceed as an error has occured - an incorrect parameter has been passed. ";
	quit_with_errors("An incorrect parameter was passed to the $change_filetype_scanning script for $domainname");
}

print_header("Request to $change_string for $domainname");

print qq!

<form action=/$script_bin/$confirm_change_filetype_scanning method=post class=text>

To make this change to your MailWall set-up please click on the submit button below. Please ensure that 
you are aware of the effects your decision to $change_string for your account may have.
<BR>

<input type=hidden name=change value=$change>
!;

print_end_of_form();

require $footer;
