#!/usr/bin/perl

print "Content-Type: Text/HTML\n\n";

use CGI ':standard';
use Vpanel 1.00;
require $header;
require $accountinfo;

$domainname = find_domain ($mainuser);
$change = param('change');

# Define the tab which appears to the front
$tab_section = $tabnum_mailwall;

# Output the content associated with this tab
print "<body class=section-$tab_section>";

# display tabs
require $tabdisplay;

# default status is 'no error'
$error = 0;

# Get current status of filetype scanning for the account
# Status can be one of four options:
# virus_and_spam
# only_virus
# only_spam
# nothing
$filetype_scanning_status = filetype_scanning_status($domainname);

# get the correct definition of the change
if ( $change eq "von" )
{
        $change_string = "turn on file type scanning";
	if ( $filetype_scanning_status eq "only_spam" )
	{
		$list_file_flag = "everything";
	} elsif ( $filetype_scanning_status eq "nothing" ) {
		$list_file_flag = "only_virus";
	} else {
		$error = 1;
	}
} elsif ( $change eq "voff" ) {
        $change_string = "turn off file type scanning";
	if ( $filetype_scanning_status eq "everything" )
	{
		$list_file_flag = "only_spam";
	} elsif ( $filetype_scanning_status eq "only_virus" ) {
		$list_file_flag = "nothing";
	} else {
		$error = 1;
	}	
} elsif ( $change eq "son" ) {
        $change_string = "turn on image filtering";
	if ( $filetype_scanning_status eq "only_virus" )
	{
		$list_file_flag = "everything";
	} elsif ( $filetype_scanning_status eq "nothing" ) {
		$list_file_flag = "only_spam";
	} else {
		$error = 1;
	}
} elsif ( $change eq "soff" ) {
        $change_string = "turn off image filtering";
	if ( $filetype_scanning_status eq "everything" )
	{
		$list_file_flag = "only_virus";
	} elsif ( $filetype_scanning_status eq "only_spam" ) {
		$list_file_flag = "nothing";
	} else {
		$error = 1;
	}
} else {
        print "It seems that we cannot proceed as an error has occured - an incorrect parameter has been passed. ";
        quit_with_errors("An incorrect parameter was passed to the $change_filetype_scanning script for $domainname");
}

print_header("Request to $change_string for $domainname");

if ( $error == 1 )
{
	print qq!
	Sorry, but your request to $change_string has failed. This may be because the requested action is 
	awaiting activation.
	!;
	print_support_contact_information();
} else {
	print "Thank you for your request to $change_string.";
	show_time_to_change();
	
	# proceed with the change	
	open ( CHANGE, ">>$change_filetype_scanning_file") || file_error($change_filetype_scanning_file);
	print CHANGE "$list_file_flag,$domainname\n";
	close (CHANGE);
}

require $footer;
