# Vpanel package containing all common variables

package Vpanel;
require Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw( @tab_headings @tab_front @section_file $numberoftabs $footer $header $tabdisplay $accountinfo
		$tabnum_home $tabnum_mailwall $tabnum_email $tabnum_website $tabnum_features $tabnum_support $tabnum_help $tabnum_feedback
		$tabnum_report_spam $listdir
		$showsmtpforwarding $showcustomsmtpforwarding $scanningdir $whitelistdir log_error $windows_ip $dedicated_server_prefix $dedicated_server_ip_prefix
		$default_whitelist_ip_addresses_file $dedicated_server_suffix $mailwall_inset $release_email_file
		$virus_scanningdir $spam_scanningdir $content_quarantine_tag $virus_quarantine_tag $delete_spam_trap_mailbox
		$sohouserlimit $bususerlimit $appuserlimit $sohospacelimit $busspacelimit $appspacelimit $numpasswords $domain_data_file
		$turn_off_suspect_html_scanning $confirm_turn_off_suspect_html_scanning
		$turn_on_suspect_html_scanning $confirm_turn_on_suspect_html_scanning
		$turn_off_dangerous_html_scanning $confirm_turn_off_dangerous_html_scanning
		$turn_on_dangerous_html_scanning $confirm_turn_on_dangerous_html_scanning
		$turn_off_suspect_content_scanning $confirm_turn_off_suspect_content_scanning
		$turn_on_suspect_content_scanning $confirm_turn_on_suspect_content_scanning
		$turn_off_filename_scanning $confirm_turn_off_filename_scanning
		$turn_on_filename_scanning $confirm_turn_on_filename_scanning
		$change_filetype_scanning $confirm_change_filetype_scanning
		$virus_scanning_file $spam_scanning_file $spam_trap_file $help_topics_list $submit_feedback show_meaning_of_icons
		$virus_suspect_html_file $virus_dangerous_html_file $virus_filetype_scanning_file $virus_suspect_content_file
		$virus_filename_file $filetype_file $content_management_file
		$virus_filename_scanning_file $databasedir $searchenginedir $boarddir $shopdir $helpdir $virus_notification_file $mailprog
		quit_with_errors file_error print_header print_sub_header show_time_to_change 
		print_email_confirmation print_support_contact_information
		$backup_website $view_space $view_statistics $loggedinuserfile $vpanel_changes_file
		show_option_to_go_back show_help show_option check_if_allowed_on_soho print_end_of_form print_version show_status_of_service show_status_of_service_unmodifiable
		$deleteaddressfile $deletemultidropfile $deleteuserfile $newftpuserfile $newuserfile $newaddressfile $newforwardinglist
		$userresponsefile $uservacationfile $deleteforwardingfile $changepasswordfile $removevacationfile $changeinfofile
		$upgradespamfile $removespamfile $removevirusfile $releaseemailfile $overwrite_email_with_multidrop_file $emptymailboxfile
		$create_spam_trap_file $delete_spam_trap_file $create_search_engine_file $confirm_create_search_engine
		$create_content_management_file $remove_content_management_file
		$create_pw_protection_file $create_spam_whitelist_file
		$delete_multidrop_file $deleteftpuserfile $reset_password $confirm_reset_password
		$remove_suspect_html_scanning_file $create_suspect_html_scanning_file 
		$remove_dangerous_html_scanning_file $create_dangerous_html_scanning_file
		$remove_suspect_content_scanning_file $create_suspect_content_scanning_file
		$remove_filename_scanning_file $create_filename_scanning_file
		$change_filetype_scanning_file 
		$view_ftp_users $create_ftp_user $confirm_create_ftp_user $delete_ftp_user $confirm_delete_ftp_user $check_perl
		$vpanel_dir $script_bin $create_user $view_forwarding $view_email_setup $delete_user $confirm_delete_user $create_address
		$delete_address $confirm_delete_address $create_forwarding $confirm_create_forwarding $helpdesk_website_page
		$create_multidrop $confirm_create_multidrop $final_confirm_create_multidrop
		$delete_multidrop $confirm_delete_multidrop $final_confirm_delete_multidrop $confirm_overwrite_with_multidrop
		$create_out_of_office $delete_out_of_office $confirm_create_out_of_office $confirm_delete_out_of_office 
		$empty_mailbox $confirm_empty_mailbox $final_confirm_empty_mailbox
		$reset_smtp_forwarding $confirm_reset_smtp_forwarding $create_smtp_forwarding $confirm_create_smtp_forwarding
		$create_spam_protection_file $remove_spam_protection_file $create_virus_protection_file $remove_virus_protection_file
		$remove_virus_notification_file $create_virus_notification_file
		$reset_smtp_forwarding_file $remove_from_quarantine_file $final_confirm_create_smtp_forwarding $create_smtp_forwarding_file
		$quarantine_management_1 $quarantine_management_2 $quarantine_management_3 $quarantine_management_4
		$content_management_quarantine_1 $content_management_quarantine_2 
		$add_to_spam_whitelist $confirm_add_to_spam_whitelist $turn_on_spam_whitelist $confirm_turn_on_spam_whitelist
		$turn_on_virus_notification $confirm_turn_on_virus_notification $turn_off_virus_notification
		$confirm_turn_off_virus_notification
		$soho_address_limit
		$turn_on_virus $confirm_turn_on_virus $turn_off_virus $confirm_turn_off_virus $advanced_virus_features
		$turn_on_spam $confirm_turn_on_spam $turn_off_spam $confirm_turn_off_spam
		$turn_on_spamtrap $confirm_turn_on_spamtrap $turn_off_spamtrap $confirm_turn_off_spamtrap
		$create_database $confirm_create_database $create_shop $confirm_create_shop $create_search_engine $create_board 
		$confirm_create_board $create_password_protection $confirm_create_password_protection $password_protection_entry_page
		$turn_on_content_management $confirm_turn_on_content_management $turn_off_content_management 
		$confirm_turn_off_content_management $turn_on_image_filtering $confirm_turn_on_image_filtering
		$turn_off_image_filtering $confirm_turn_off_image_filtering
		$submit_spam_report
);

use Sys::Hostname;
our $VERSION = 1.00;

# Common folders
$databasedir = "/var/lib/mysql/";
$searchenginedir = "/usr/local/htdig/conf/";
$boarddir = "/var/boards/";
$shopdir = "/var/shops/shared/";
$helpdir = $vpaneldir . "help/";
$script_bin = "vcgi-bin";
$vpanel_dir = "vpanel/";
$images_dir = "/vpanel/images/";

# Miscellaneous files
$loggedinuserfile = "previous_visitors.list";
$vpanel_changes_file = "new_vpanel_features.pl";
$vpanellog = "/var/log/syslog/vpanel.log";
$mailprog = "/usr/sbin/sendmail";
$tabdisplay = "tabdisplay.pl";
$footer = "footer.pl";
$header = "header.pl";
$accountinfo = "get_account_info.pl";
$absolute_accountinfo = $absolute_vpanel_cgi_path . $accountinfo;
$showsmtpforwarding = "show_smtp_forwarding.pl";
$showcustomsmtpforwarding = "show_custom_smtp_forwarding.pl";
$content_quarantine_tag = "content";
$virus_quarantine_tag = "virus";

# Normal helpdesk page called using wget in support.pl
$helpdesk_website_page = "http://support.ieinternet.com/control_panel/";
$password_protection_entry_page = "passwordprotection.html";
$domain_data_file = "/var/customers/domain-data/domains.data";

# MailScanner files and folders
$scanningdir = "/etc/MailScanner/rules/";
$virus_scanningdir = $scanningdir . "virus/";
$spam_scanningdir = $scanningdir . "spam/";
$content_scanningdir = $scanningdir . "content/";
$whitelistdir = "/etc/MailScanner/spam.bydomain/whitelist/";
$default_whitelist_ip_addresses_file = $whitelistdir. "default"; 
$virus_scanning_file = $virus_scanningdir."virus.scanning.rules";
$virus_notification_file = $virus_scanningdir."virus.notifications.rules";
$spam_scanning_file = $spam_scanningdir."spam.scanning.rules";
$spam_trap_file = $spam_scanningdir."spam.actions.rules";
$virus_suspect_html_file = $virus_scanningdir."suspect.html.rules";
$virus_dangerous_html_file = $virus_scanningdir."dangerous.html.rules";
$virus_suspect_content_file = $virus_scanningdir."suspect.content.rules";
$virus_filename_file = $virus_scanningdir."filename.scanning.rules";
$filetype_file = $virus_scanningdir."filetype.scanning.rules";
$content_management_file = $content_scanningdir . "content.filtering.rules";

# Account limits
$sohouserlimit = 1;
$bususerlimit = 20;
$appuserlimit = 100;
$sohospacelimit = 20;
$busspacelimit = 50;
$appspacelimit = 110;
$soho_address_limit = 8; # info, abuse, postmaster + 5 others

# IP addresses 
$windows_ip = "66.36.249.127";
$plesk_web_01 = "209.160.76.73";
$plesk_web_02 = "209.160.68.232";
$dedicated_server_prefix = "host-";
$dedicated_server_ip_prefix = "66.36.";
$dedicated_server_suffix = ".ieinternet.net";

# Number of passwords to display when setting/changing passwords
$numpasswords = 10;

# define the order of the tabs
$tabnum_home = 1;
$tabnum_mailwall = 2;
$tabnum_email = 3;
$tabnum_website = 4;
$tabnum_features = 5;
$tabnum_support = 6;
$tabnum_help = 7;
$tabnum_feedback = 8;
$tabnum_report_spam = 9;

# fill the array with the name of each tab
@tab_headings[$tabnum_home-1] = "Home";
@tab_headings[$tabnum_mailwall-1] = "MailWall";
@tab_headings[$tabnum_email-1] = "Email Set-up";
@tab_headings[$tabnum_website-1] = "Website Set-up";
@tab_headings[$tabnum_features-1] = "Other Features";
@tab_headings[$tabnum_support-1] = "Request Support";
@tab_headings[$tabnum_help-1] = "Help";
@tab_headings[$tabnum_feedback-1] = "Feedback";
@tab_headings[$tabnum_report_spam-1] = "Report Spam";

$numberoftabs = @tab_headings;

# define the pages which appear as default for each tab
@tab_front[$tabnum_home-1] = "tab_home.pl";
@tab_front[$tabnum_mailwall-1] = "tab_mailwall.pl";
@tab_front[$tabnum_email-1] = "tab_email.pl";
@tab_front[$tabnum_website-1] = "tab_website.pl";
@tab_front[$tabnum_features-1] = "tab_features.pl";
@tab_front[$tabnum_support-1] = "tab_support.pl";
@tab_front[$tabnum_help-1] = "tab_help.pl";
@tab_front[$tabnum_feedback-1] = "tab_feedback.pl";
@tab_front[$tabnum_report_spam-1] = "tab_report_spam.pl";

# define the name of each file which then calls each tab and tab contents
@section_file[$tabnum_home-1] = "home.pl";
@section_file[$tabnum_mailwall-1] = "mailwall.pl";
@section_file[$tabnum_email-1] = "email.pl";
@section_file[$tabnum_website-1] = "website.pl";
@section_file[$tabnum_features-1] = "features.pl";
@section_file[$tabnum_support-1] = "support.pl";
@section_file[$tabnum_help-1] = "help.pl";
@section_file[$tabnum_feedback-1] = "feedback.pl";
@section_file[$tabnum_report_spam-1] = "report_spam.pl";

# Images
$more_icon = $images_dir . "orange_arrow.gif";
$help_icon = $images_dir . "help_small.gif";
$on_icon = $images_dir . "on_tick.png";
$off_icon = $images_dir . "off_tick.png";

$mailwall_inset = "&nbsp;&nbsp;&nbsp;";

# File names

	$reset_password = "reset_password.pl";
	$confirm_reset_password = "reset_password-confirm.pl";

	# Email Files
	$create_user = "create_user.pl";
	$view_forwarding = "view_forwarding.pl";
	$view_email_setup = "view_email_setup.pl";
	$delete_user = "delete_user.pl";
	$confirm_delete_user = "delete_user-confirm.pl";
	$create_address = "create_address.pl";
	$delete_address = "delete_address.pl";
	$confirm_delete_address = "delete_address-confirm.pl";
	$create_forwarding = "create_forwarding.pl";
	$confirm_create_forwarding = "create_forwarding-confirm.pl";
	$create_multidrop = "create_multidrop.pl";
	$delete_multidrop = "delete_multidrop.pl";
	$confirm_create_multidrop = "create_multidrop-confirm.pl";
	$final_confirm_create_multidrop = "create_multidrop-final-confirm.pl";
	$confirm_delete_multidrop = "delete_multidrop-confirm.pl";
	$confirm_overwrite_with_multidrop = "overwrite_email_with_multidrop-confirm.pl";
	$create_out_of_office = "create_out_of_office.pl";
	$confirm_create_out_of_office = "create_out_of_office-confirm.pl";
	$delete_out_of_office = "delete_out_of_office.pl";
	$confirm_delete_out_of_office = "delete_out_of_office-confirm.pl";
	$empty_mailbox = "empty_mailbox.pl";
	$confirm_empty_mailbox = "empty_mailbox-confirm.pl";
	$final_confirm_empty_mailbox = "empty_mailbox-final-confirm.pl";
	$submit_spam_report = "submit_spam_report.pl";

	# MailWall Script Files
		# Virus files
		$turn_on_virus = "virus_turn_on.pl";
		$confirm_turn_on_virus = "virus_turn_on-confirm.pl";
		$turn_off_virus = "virus_turn_off.pl";
		$confirm_turn_off_virus = "virus_turn_off-confirm.pl";
		$quarantine_management_1 = "quarantine_management_1.pl";
		$quarantine_management_2 = "quarantine_management_2.pl";
		$quarantine_management_3 = "quarantine_management_3.pl";
		$quarantine_management_4 = "quarantine_management_4.pl";
		$turn_on_virus_notification = "virus_turn_on_notification.pl";
		$confirm_turn_on_virus_notification = "virus_turn_on_notification-confirm.pl";
		$turn_off_virus_notification = "virus_turn_off_notification.pl";
		$confirm_turn_off_virus_notification = "virus_turn_off_notification-confirm.pl";

		# Spam files
		$turn_on_spam = "spam_turn_on.pl";
		$confirm_turn_on_spam = "spam_turn_on-confirm.pl";
		$turn_off_spam = "spam_turn_off.pl";
		$confirm_turn_off_spam = "spam_turn_off-confirm.pl";
		$turn_on_spamtrap = "spam_trap_turn_on.pl";
		$confirm_turn_on_spamtrap = "spam_trap_turn_on-confirm.pl";
		$turn_off_spamtrap = "spam_trap_turn_off.pl";
		$confirm_turn_off_spamtrap = "spam_trap_turn_off-confirm.pl";
		$turn_on_spam_whitelist = "spam_whitelist_turn_on.pl";
		$confirm_turn_on_spam_whitelist = "spam_whitelist-turn_on-confirm.pl";
		$add_to_spam_whitelist = "add_to_spam_whitelist.pl";
		$confirm_add_to_spam_whitelist = "add_to_spam_whitelist-confirm.pl";
		$content_management_quarantine_1 = "content_management_quarantine_1.pl";
		$content_management_quarantine_2 = "content_management_quarantine_2.pl";

		# Content management 
		$turn_on_content_management = "content_management_turn_on.pl";
		$confirm_turn_on_content_management = "content_management_turn_on-confirm.pl";
		$turn_off_content_management = "content_management_turn_off.pl";
		$confirm_turn_off_content_management = "content_management_turn_off-confirm.pl";
		$turn_on_image_filtering = "turn_on_image_filtering.pl";
		$confirm_turn_on_image_filtering = "turn_on_image_filtering-confirm.pl";
		$turn_off_image_filtering = "turn_off_image_filtering.pl";
		$confirm_turn_off_image_filtering = "turn_off_image_filtering-confirm.pl";

		# SMTP forwarding
		$reset_smtp_forwarding = "reset_smtp_forwarding.pl";
		$confirm_reset_smtp_forwarding = "reset_smtp_forwarding-confirm.pl";	
		$create_smtp_forwarding = "create_smtp_forwarding.pl";
		$confirm_create_smtp_forwarding = "create_smtp_forwarding-confirm.pl";
		$final_confirm_create_smtp_forwarding = "create_smtp_forwarding-final-confirm.pl";

		# Advanced Virus scanning files
		$advanced_virus_features = "virus_advanced_features.pl";
		$turn_off_suspect_html_scanning = "virus_suspect_html_scanning_turn_off.pl";
		$confirm_turn_off_suspect_html_scanning = "virus_suspect_html_scanning_turn_off-confirm.pl";
		$turn_on_suspect_html_scanning = "virus_suspect_html_scanning_turn_on.pl";
		$confirm_turn_on_suspect_html_scanning = "virus_suspect_html_scanning_turn_on-confirm.pl";
		$turn_off_dangerous_html_scanning = "virus_dangerous_html_scanning_turn_off.pl";
		$confirm_turn_off_dangerous_html_scanning = "virus_dangerous_html_scanning_turn_off-confirm.pl";
		$turn_on_dangerous_html_scanning = "virus_dangerous_html_scanning_turn_on.pl";
		$confirm_turn_on_dangerous_html_scanning = "virus_dangerous_html_scanning_turn_on-confirm.pl";
		$turn_off_suspect_content_scanning = "virus_suspect_content_scanning_turn_off.pl";
		$confirm_turn_off_suspect_content_scanning = "virus_suspect_content_scanning_turn_off-confirm.pl";
		$turn_on_suspect_content_scanning = "virus_suspect_content_scanning_turn_on.pl";
		$confirm_turn_on_suspect_content_scanning = "virus_suspect_content_scanning_turn_on-confirm.pl";
		$turn_off_filename_scanning = "virus_filename_scanning_turn_off.pl";
		$confirm_turn_off_filename_scanning = "virus_filename_scanning_turn_off-confirm.pl";
		$turn_on_filename_scanning = "virus_filename_scanning_turn_on.pl";
		$confirm_turn_on_filename_scanning = "virus_filename_scanning_turn_on-confirm.pl";
		$change_filetype_scanning = "change_filetype_scanning.pl";
		$confirm_change_filetype_scanning = "change_filetype_scanning-confirm.pl";

	# Website Files
	$backup_website = "backup_website.pl";
	$view_space = "space.pl";
	$view_statistics = "view_statistics.pl";
	$view_ftp_users = "view_ftp_users.pl";
	$create_ftp_user = "create_ftp_user.pl";
	$confirm_create_ftp_user = "create_ftp_user-confirm.pl";
	$delete_ftp_user = "delete_ftp_user.pl";
	$confirm_delete_ftp_user = "delete_ftp_user-confirm.pl";
	$check_perl = "perlchecker.pl";
	$create_password_protection = "create_password_protection.pl";
	$confirm_create_password_protection = "create_password_protection-confirm.pl";

	# Features Files
	$create_database = "create_database.pl";
	$confirm_create_database = "create_database-confirm.pl";
	$create_search_engine = "create_search_engine.pl";
	$confirm_create_search_engine = "create_search_engine-confirm.pl";
	$create_shop = "create_shop.pl";
	$confirm_create_shop= "create_shop-confirm.pl";
	$create_board = "create_board.pl";
	$confirm_create_board = "create_board-confirm.pl";

	# Help Files
	$help_topics_list = "helptopics.txt";

	# Feedback Files
	$submit_feedback = "submit_feedback.pl";
		
# List files

	$listdir = "/var/www/html/vpanel/lists/";

	# Email
	$deleteaddressfile = $listdir."deleteaddress.list";
	$deletemultidropfile = $listdir."delete_multidrop.list";
	$deleteuserfile = $listdir."deleteuser.list";
	
	$newuserfile = $listdir."newuser.list";
	$newaddressfile = $listdir."newaddress.list";
	$newforwardingfile = $listdir."newforwarding.list";

	$userresponsefile = $listdir."vacation.email";
	$uservacationfile = $listdir."vacationusers.list";
	$deleteforwardingfile = $listdir."deleteforwarding.list";
	$changepasswordfile = $listdir."changepassword.list";
	$removevacationfile = $listdir."removevacationusers.list";
	$changeinfofile = $listdir."changeinfoaccount.list";
	$emptymailboxfile = $listdir."emptymailbox.list";	

	# MailWall
		# Virus scanning
		$create_virus_protection_file = $listdir."addvirusscanning.list";
		$remove_virus_protection_file = $listdir."removevirusscanning.list";
		$create_virus_notification_file = $listdir."add_virus_notification.list";
		$remove_virus_notification_file = $listdir."remove_virus_notification.list";
		$remove_from_quarantine_file = $listdir."releaseemail.list";
		$release_email_file = $listdir."release_from_quarantine.list";
		$remove_suspect_html_scanning_file = $listdir."remove_suspect_html_scanning.list";
		$create_suspect_html_scanning_file = $listdir."create_suspect_html_scanning.list";
		$remove_dangerous_html_scanning_file = $listdir."remove_dangerous_html_scanning.list";
		$create_dangerous_html_scanning_file = $listdir."create_dangerous_html_scanning.list";
		$remove_suspect_content_scanning_file = $listdir."remove_suspect_content_scanning.list";
		$create_suspect_content_scanning_file = $listdir."create_suspect_content_scanning.list";
		$remove_filename_scanning_file = $listdir."remove_filename_scanning.list";
		$create_filename_scanning_file = $listdir."create_filename_scanning.list";
		$change_filetype_scanning_file = $listdir."change_filetype_scanning.list";

		# Spam scanning
		$upgradespamfile = $listdir."upgradespamscanning.list";
		$create_spam_protection_file = $listdir."addspamscanning.list";
		$remove_spam_protection_file = $listdir."removespamscanning.list";
		$create_spam_whitelist_file = $listdir."create_spam_whitelist.list";
		$create_spam_trap_file = $listdir."create_spamtrap.list";
		$delete_spam_trap_file = $listdir."delete_spamtrap.list";
		$create_content_management_file = $listdir."create_content_management.list";
		$remove_content_management_file = $listdir."remove_content_management.list";

		# Mail forwarding
		$create_smtp_forwarding_file = $listdir."create_smtpforwarding.list";
		$reset_smtp_forwarding_file = $listdir."resetsmtpforwarding.list";
		$overwrite_email_with_multidrop_file = $listdir."overwrite_email_with_multidrop.list";
		$delete_multidrop_file = $listdir."delete_multidrop.list";


	# Website 
	$newftpuserfile = $listdir."newftpuser.list";
	$deleteftpuserfile = $deleteuserfile;
	$create_search_engine_file = $listdir."create_search_engine.list";
	$create_pw_protection_file = $listdir."create_password_protection.list";

# Functions common to all pages

sub print_version
{
	print "<p align=right class=copyright>Vpanel version 2.1 </p>";
}

sub print_header
{
	print "<b>> $_[0]</b><BR><BR>";
}

sub print_sub_header
{
	print "<b>$mailwall_inset $mailwall_inset>> $_[0]</b><BR><BR>";
}

sub file_error
{
	$file_details = "Couldn't access file $_[0]";
	quit_with_errors($file_details);
}

sub quit_with_errors
{
	$lower=10000;
	$upper=20000;
	$random_number = int(rand( $upper-$lower+1 ) ) + $lower;
	print "
		<p class=text><img src=/vpanel/images/warning_1.png align=center> An error has occurred.<BR><BR>
		Please note the following error number generated by this error: <b>$random_number</b><BR><BR>
	";
	log_error ($random_number, $_[0]);
	print_support_contact_information();
	require $footer;
	exit;
}

sub log_error
{
	# error number passed as first argument, message string as second argument
	system ("logger -p local3.info -t vpanel \"$_[0] $_[1]\"");
}

sub show_time_to_change
{
	$minutes_between_updates = "5"; # number of minutes between vpanel updates	
	@now = localtime(time());
	$minutes_remaining = (60 - $now[1]) % $minutes_between_updates;
	print "<BR><BR>This change will take effect within the next ";
	if ( ( $minutes_remaining != 1 ) && ( $minutes_remaining != 0 ) )
	{
		print "$minutes_remaining minutes.";
	} else {
		print "minute.";
	}
	print "<BR><BR>";
}

sub print_email_confirmation
{
	print "An email will be sent to info\@$_[0] confirming this change.<BR>";
}

sub print_support_contact_information
{
	print qq!

	<p class="text" style="border-top: solid 1px #ccc; margin-top: 30px; padding-top: 20px ">If you have any queries in relation to this matter please get in touch with our Support Department:</p>
	<table width=40% border=0 class=text>
	<TR><TD width=10%>&nbsp;</TD><TD>
	<B>Support Department:</b></TD><TD> <a href=/$script_bin/support.pl><font color=#CC0000>
	For support please click here</font></a></TD></TR>
	</table>
	!;
	show_option_to_go_back();
}

sub show_option_to_go_back
{
	# If a first argument is passed this is to allow a variable to be passed back to the previous page
	# First wipe out any other get information i.e. anything after the ? in the referer link
	$link = $ENV{'HTTP_REFERER'};
	$link =~ s/\?.*//;
	print "<p class=\"text\">Please <a href=$link$_[0]><font color=#cc0000>click here</font></a> to go back and try again.</p>";
}

sub show_help
{
	print qq!

	<span class=sidepanel><a href="/$script_bin/help.pl?topic=$_[0]" title="Click here for help ...">
	<img align=center src=$help_icon
	height=22 width=21 border=0 alt='Click here for help'></span><br>

	!;
}

sub show_option
{
	print qq!
	<span class=sidepanel><a href=/$script_bin/$_[0] title="Click here for more ...">
	<img align=center height=22 width=21 border=0 alt='Click here for more ...' src=$more_icon>
	</span>

	!;

}

sub show_meaning_of_icons
{
	# If mailwall's tab number is passed then the meaning of the tick and cross options are shown	
	print "<BR><BR><BR>";
	
	if ( $_[0] == $tabnum_mailwall ) 
	{
		print qq!
		<table class=insidetext border=0 width=80%>
		<TR><TD>
		<img align=middle height=16 width=16 src="$on_icon">&nbsp;This indicates the relevant feature is active<BR>	
		<img align=middle height=16 width=16 src="$off_icon">&nbsp;This icon is displayed beside all deactivated features<BR>
		</TD>
		<TD>
		!;
	} 

	print qq!	
	<span class=insidetext>
	<img align=middle height=18 width=18 src="$more_icon">&nbsp;Click this icon to edit/activate/de-activate the chosen option<BR>
	<img align=middle height=18 width=18 src="$help_icon">&nbsp;Click this icon for help on the relevant topic</span>
	</span>
	!;
	
	if ( $_[0] == $tabnum_mailwall )
	{
		print "</TD></TR>";
	}

}
	
# SOHO restrictions

sub check_if_allowed_on_soho
{
	if ( $_[0] eq $view_forwarding )
	{
		return "no";
	}

	if ( $_[0] eq $create_user ) 
	{ 
		return "no"; 
	} 
	
	if ( $_[0] eq $delete_user )
	{
		return "no";
	}

	if ( $_[0] eq $reset_email_password )
	{
		return "no";
	}

	if ( $_[0] eq $create_address )
	{
		return "yes";
	}

	if ( $_[0] eq $delete_address )
	{
		return "yes";
	}

	if ( $_[0] eq $create_forwarding )
	{
		return "no";
	}

	if ( $_[0] eq $create_multidrop )
	{
		return "no";
	}

	if ( $_[0] eq $backup_website )
	{
		return "yes";
	}

	if ( $_[0] eq $check_perl )
	{
		return "yes";
	}

	if ( $_[0] eq "is_ftp_allowed_for_soho" )
	{
		return "no";
	}

	if ( $_[0] eq "is_anti-virus_allowed_for_soho" )
	{
		return "yes";
	}

	if ( $_[0] eq "is_anti-spam_allowed_for_soho" )
	{
		return "no";
	}

	if ( $_[0] eq $create_database )
	{
		return "no";
	}

	if ( $_[0] eq $create_search_engine )
	{
		return "no";
	}

	if ( $_[0] eq $create_shop )
	{
		return "no";
	}
	
	if ( $_[0] eq $create_board )
	{
		return "no";
	}
	
	if ( $_[0] eq $create_password_protection )
	{
		return "no";
	}

	if ( $_[0] eq $create_smtp_forwarding )
	{
		return "no";
	}
}

sub print_end_of_form
{
	$previous_page = $ENV{'HTTP_REFERER'};
	print qq!

	<BR><BR>
	<a href=$previous_page><input type=image src=/vpanel/images/button_reset.gif alt='Go back'></a>
	<input type=image src=/vpanel/images/button_submit.gif alt='Submit this change'></form>

	!;
}

sub show_status_of_service
{
	if ( $_[0] eq "on" )
	{
		$image = "$on_icon";
	} else {
		$image = "$off_icon";
	}

	print qq!

	<table class=text width=50% border=0>
	<td width=8% align=middle valign=middle>
	<img src=$image></td>
	<td width=22%>$_[2]</td>
	!;

	print "<td width=3% align=right valign=middle>";
	show_option($_[1]);
	print "</td>";

	print "<td width=3% align=left valign=middle>";
	show_help($_[1]);
	print "</td></tr></table>";
}

sub show_status_of_service_unmodifiable
{
	if ( $_[0] eq "on" )
	{
		$image = "$on_icon";
	} else {
		$image = "$off_icon";
	}

	print qq!

	<table class=text width=50% border=0>
	<td width=8% align=middle valign=middle>
	<img src=$image></td>
	<td width=22%>$_[2]</td>
	!;

    print "<td width=3% align=right valign=middle>";
#    show_option($_[1]);
    print "</td>";

    print "<td width=3% align=left valign=middle>";
#    show_help($_[1]);
    print "</td></tr></table>";

}
